/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.CompressUtil;
import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProdBundleUtils {
    private ProdBundleUtils() {
    }

    public static File getProdBundle(File projectDir) {
        return new File(projectDir, "src/main/bundles/prod.bundle");
    }

    public static String findBundleStatsJson(File projectDir, ClassFinder finder) throws IOException {
        URL statsJson;
        String statsFile = "config/stats.json";
        File prodBundleFile = ProdBundleUtils.getProdBundle(projectDir);
        if (prodBundleFile.exists()) {
            try {
                String stats = CompressUtil.readFileContentFromZip(prodBundleFile, statsFile);
                if (stats != null) {
                    return stats;
                }
            }
            catch (IOException e) {
                ProdBundleUtils.getLogger().error("Failed to read stats.json from the production bundle", (Throwable)e);
            }
        }
        if ((statsJson = finder.getResource("vaadin-prod-bundle/" + statsFile)) == null) {
            ProdBundleUtils.getLogger().warn("There is no prod-bundle in the project or on the classpath nor is there a default production bundle included.");
            return null;
        }
        return FileIOUtils.urlToString(statsJson);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ProdBundleUtils.class);
    }

    public static void compressBundle(File projectDir, File prodBundleFolder) {
        File bundleFile = new File(projectDir, "src/main/bundles/prod.bundle");
        if (bundleFile.exists()) {
            bundleFile.delete();
        } else {
            bundleFile.getParentFile().mkdirs();
        }
        CompressUtil.compressDirectory(prodBundleFolder, bundleFile);
    }

    public static void unpackBundle(File projectDir, File prodBundleFolder) {
        File bundleFile = new File(projectDir, "src/main/bundles/prod.bundle");
        CompressUtil.uncompressFile(bundleFile, prodBundleFolder);
    }
}

