/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.internal.UsageStatistics;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import tools.jackson.databind.JsonNode;

public class AbstractConfigurationFactory
implements Serializable {
    public static final String DEV_FOLDER_MISSING_MESSAGE = "Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/latest/flow/production/overview";

    protected Map<String, String> getConfigParametersUsingTokenData(JsonNode buildInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (buildInfo.has("productionMode")) {
            params.put("productionMode", String.valueOf(buildInfo.get("productionMode").booleanValue()));
        }
        if (buildInfo.has("externalStatsFile") || buildInfo.has("externalStatsUrl")) {
            params.put("external.stats.file", Boolean.toString(true));
            if (buildInfo.has("externalStatsUrl")) {
                params.put("external.stats.url", buildInfo.get("externalStatsUrl").asString());
            }
            return params;
        }
        if (buildInfo.has("eagerServerLoad")) {
            params.put("eagerServerLoad", String.valueOf(buildInfo.get("eagerServerLoad").booleanValue()));
            System.clearProperty("vaadin.eagerServerLoad");
        }
        if (buildInfo.has("npmFolder")) {
            params.put("project.basedir", buildInfo.get("npmFolder").asString());
            this.verifyFolderExists(params, buildInfo.get("npmFolder").asString());
        }
        if (buildInfo.has("node.version")) {
            params.put("node.version", buildInfo.get("node.version").asString());
        }
        if (buildInfo.has("node.download.root")) {
            params.put("node.download.root", buildInfo.get("node.download.root").asString());
        }
        if (buildInfo.has("frontendFolder")) {
            params.put("vaadin.frontend.folder", buildInfo.get("frontendFolder").asString());
            if (!buildInfo.has("npmFolder") || !buildInfo.get("frontendFolder").asString().startsWith(buildInfo.get("npmFolder").asString())) {
                this.verifyFolderExists(params, buildInfo.get("frontendFolder").asString());
            }
        }
        if (buildInfo.has("frontend.hotdeploy")) {
            params.put("frontend.hotdeploy", String.valueOf(buildInfo.get("frontend.hotdeploy").booleanValue()));
        }
        if (buildInfo.has("reuseDevServer")) {
            params.put("reuseDevServer", String.valueOf(buildInfo.get("reuseDevServer").booleanValue()));
        }
        if (buildInfo.has("connect.javaSourceFolder")) {
            params.put("connect.javaSourceFolder", buildInfo.get("connect.javaSourceFolder").asString());
        }
        if (buildInfo.has("javaResourceFolder")) {
            params.put("javaResourceFolder", buildInfo.get("javaResourceFolder").asString());
        }
        if (buildInfo.has("connect.openApiFile")) {
            params.put("connect.openApiFile", buildInfo.get("connect.openApiFile").asString());
        }
        if (buildInfo.has("connect.applicationProperties")) {
            params.put("connect.applicationProperties", buildInfo.get("connect.applicationProperties").asString());
        }
        if (buildInfo.has("project.frontend.generated")) {
            params.put("project.frontend.generated", buildInfo.get("project.frontend.generated").asString());
        }
        if (buildInfo.has("build.folder")) {
            params.put("build.folder", buildInfo.get("build.folder").asString());
        }
        if (buildInfo.has("disable.prepare.frontend.cache")) {
            UsageStatistics.markAsUsed("flow/always-execute-prepare-frontend", null);
        }
        if (buildInfo.has("react.enable")) {
            params.put("react.enable", String.valueOf(buildInfo.get("react.enable").booleanValue()));
        }
        if (buildInfo.has("applicationIdentifier")) {
            params.put("applicationIdentifier", buildInfo.get("applicationIdentifier").asString());
        }
        if (buildInfo.has("dau.enable")) {
            params.put("dau.enable", String.valueOf(buildInfo.get("dau.enable").booleanValue()));
        }
        if (buildInfo.has("premiumFeatures.enable")) {
            params.put("premiumFeatures.enable", String.valueOf(buildInfo.get("premiumFeatures.enable").booleanValue()));
        }
        if (buildInfo.has("devmode.frontendExtraFileExtensions")) {
            params.put("devmode.frontendExtraFileExtensions", buildInfo.get("devmode.frontendExtraFileExtensions").asString());
        }
        if (buildInfo.has("npm.excludeWebComponents")) {
            params.put("npm.excludeWebComponents", String.valueOf(buildInfo.get("npm.excludeWebComponents").booleanValue()));
        }
        if (buildInfo.has("commercialBanner.enable")) {
            params.put("commercialBanner.enable", String.valueOf(buildInfo.get("commercialBanner.enable").booleanValue()));
        }
        this.setDevModePropertiesUsingTokenData(params, buildInfo);
        return params;
    }

    protected void setDevModePropertiesUsingTokenData(Map<String, String> params, JsonNode buildInfo) {
        if (params.get("pnpm.enable") == null && buildInfo.has("pnpm.enable")) {
            params.put("pnpm.enable", String.valueOf(buildInfo.get("pnpm.enable").booleanValue()));
        }
        if (params.get("bun.enable") == null && buildInfo.has("bun.enable")) {
            params.put("bun.enable", String.valueOf(buildInfo.get("bun.enable").booleanValue()));
        }
        if (params.get("require.home.node") == null && buildInfo.has("require.home.node")) {
            params.put("require.home.node", String.valueOf(buildInfo.get("require.home.node").booleanValue()));
        }
    }

    protected String getTokenFileContent(Function<String, String> locationProvider) {
        String location = locationProvider.apply("vaadin.frontend.token.file");
        String json = null;
        try {
            File tokenFile;
            if (location != null && (tokenFile = new File(location)) != null && tokenFile.canRead()) {
                json = Files.readString(tokenFile.toPath());
            }
            return json;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void verifyFolderExists(Map<String, String> params, String folder) {
        Boolean productionMode = Boolean.parseBoolean(params.getOrDefault("productionMode", "false"));
        if (!productionMode.booleanValue() && !new File(folder).exists()) {
            String message = String.format(DEV_FOLDER_MISSING_MESSAGE, folder);
            throw new IllegalStateException(message);
        }
    }
}

