/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.frontendtools.internal.commons.compress.compressors.pack200;

import com.vaadin.frontendtools.internal.commons.compress.compressors.CompressorOutputStream;
import com.vaadin.frontendtools.internal.commons.compress.compressors.pack200.AbstractStreamBridge;
import com.vaadin.frontendtools.internal.commons.compress.compressors.pack200.Pack200Strategy;
import com.vaadin.frontendtools.internal.commons.compress.java.util.jar.Pack200;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarInputStream;

public class Pack200CompressorOutputStream
extends CompressorOutputStream<OutputStream> {
    private final AbstractStreamBridge abstractStreamBridge;
    private final Map<String, String> properties;

    public Pack200CompressorOutputStream(OutputStream out) throws IOException {
        this(out, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorOutputStream(OutputStream out, Map<String, String> props) throws IOException {
        this(out, Pack200Strategy.IN_MEMORY, props);
    }

    public Pack200CompressorOutputStream(OutputStream out, Pack200Strategy mode) throws IOException {
        this(out, mode, null);
    }

    public Pack200CompressorOutputStream(OutputStream out, Pack200Strategy mode, Map<String, String> props) throws IOException {
        super(out);
        this.abstractStreamBridge = mode.newStreamBridge();
        this.properties = props;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            try {
                this.abstractStreamBridge.stop();
            }
            finally {
                super.close();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.isFinished()) {
            super.finish();
            Pack200.Packer p = Pack200.newPacker();
            if (this.properties != null) {
                p.properties().putAll(this.properties);
            }
            try (JarInputStream ji = new JarInputStream(this.abstractStreamBridge.getInputStream());){
                p.pack(ji, this.out);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.abstractStreamBridge.write(b);
    }

    @Override
    public void write(byte[] b, int from, int length) throws IOException {
        this.abstractStreamBridge.write(b, from, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.abstractStreamBridge.write(b);
    }
}

