/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.TopicConnectionRegistration;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractCollaborationManager
implements Serializable {
    private final SerializableSupplier<CollaborationEngine> ceSupplier;
    private final UserInfo localUser;
    private final String topicId;
    private transient TopicConnectionRegistration topicRegistration;
    private ActivationHandler activationHandler;
    private Registration deactivationHandler;
    private transient TopicConnectionRegistration.ConnectionFailedAction connectionFailedAction;
    private boolean active;

    protected AbstractCollaborationManager(UserInfo localUser, String topicId, SerializableSupplier<CollaborationEngine> ceSupplier) {
        this.localUser = Objects.requireNonNull(localUser);
        this.topicId = Objects.requireNonNull(topicId);
        this.ceSupplier = Objects.requireNonNull(ceSupplier);
    }

    protected void openTopicConnection(ConnectionContext context, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
        }
        this.topicRegistration = this.getCollaborationEngine().openTopicConnection(context, this.topicId, this.localUser, (SerializableFunction<TopicConnection, Registration>)(SerializableFunction & Serializable)connection -> {
            this.active = true;
            Registration callbackRegistration = (Registration)connectionActivationCallback.apply(connection);
            if (this.activationHandler != null) {
                this.deactivationHandler = this.activationHandler.onActivation();
            }
            return callbackRegistration != null ? Registration.combine((Registration[])new Registration[]{callbackRegistration, this::onTopicRegistrationRemove}) : this::onTopicRegistrationRemove;
        });
        if (this.connectionFailedAction != null) {
            this.topicRegistration.onConnectionFailed(this.connectionFailedAction);
        }
    }

    public void setActivationHandler(ActivationHandler handler) {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
            this.deactivationHandler = null;
        }
        this.activationHandler = handler;
        if (this.active && this.activationHandler != null) {
            this.deactivationHandler = this.activationHandler.onActivation();
        }
    }

    public void onConnectionFailed(TopicConnectionRegistration.ConnectionFailedAction connectionFailedAction) {
        this.connectionFailedAction = connectionFailedAction;
        if (this.connectionFailedAction != null && this.topicRegistration != null) {
            this.topicRegistration.onConnectionFailed(this.connectionFailedAction);
        }
    }

    private void onTopicRegistrationRemove() {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
        }
        this.active = false;
    }

    protected CollaborationEngine getCollaborationEngine() {
        return (CollaborationEngine)this.ceSupplier.get();
    }

    public UserInfo getLocalUser() {
        return this.localUser;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void close() {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
    }

    @FunctionalInterface
    public static interface ActivationHandler
    extends Serializable {
        public Registration onActivation();
    }
}

