/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplaceWithCounterTransformation
implements EntryTransformation {
    private final AtomicLong counter;
    private final boolean replaceInRDN;
    private final long incrementAmount;
    private final Schema schema;
    private final Set<String> names;
    private final String afterText;
    private final String beforeText;

    public ReplaceWithCounterTransformation(Schema schema, String attributeName, long initialValue, long incrementAmount, String beforeText, String afterText, boolean replaceInRDN) {
        AttributeTypeDefinition at;
        this.incrementAmount = incrementAmount;
        this.replaceInRDN = replaceInRDN;
        this.counter = new AtomicLong(initialValue);
        this.beforeText = beforeText == null ? "" : beforeText;
        this.afterText = afterText == null ? "" : afterText;
        Schema s = schema;
        if (s == null) {
            try {
                s = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s;
        HashSet<String> nameSet = new HashSet<String>(StaticUtils.computeMapCapacity(5));
        String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(attributeName));
        nameSet.add(baseName);
        if (s != null && (at = s.getAttributeType(baseName)) != null) {
            nameSet.add(StaticUtils.toLowerCase(at.getOID()));
            for (String name : at.getNames()) {
                nameSet.add(StaticUtils.toLowerCase(name));
            }
        }
        this.names = Collections.unmodifiableSet(nameSet);
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        String dn = e.getDN();
        String newValue = null;
        if (this.replaceInRDN) {
            try {
                DN parsedDN = new DN(dn);
                RDN rdn = parsedDN.getRDN();
                for (String name : this.names) {
                    if (!rdn.hasAttribute(name)) continue;
                    newValue = this.beforeText + this.counter.getAndAdd(this.incrementAmount) + this.afterText;
                    break;
                }
                if (newValue != null) {
                    if (rdn.isMultiValued()) {
                        String[] attrNames = rdn.getAttributeNames();
                        byte[][] originalValues = rdn.getByteArrayAttributeValues();
                        byte[][] newValues = new byte[originalValues.length][];
                        for (int i = 0; i < attrNames.length; ++i) {
                            newValues[i] = this.names.contains(StaticUtils.toLowerCase(attrNames[i])) ? StaticUtils.getBytes(newValue) : originalValues[i];
                        }
                        dn = new DN(new RDN(attrNames, newValues, this.schema), parsedDN.getParent()).toString();
                    } else {
                        dn = new DN(new RDN(rdn.getAttributeNames()[0], newValue, this.schema), parsedDN.getParent()).toString();
                    }
                }
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        if (newValue == null) {
            boolean hasAttribute = false;
            for (String name : this.names) {
                if (!e.hasAttribute(name)) continue;
                hasAttribute = true;
                break;
            }
            if (!hasAttribute) {
                return e;
            }
        }
        if (newValue == null) {
            newValue = this.beforeText + this.counter.getAndAdd(this.incrementAmount) + this.afterText;
        }
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> updatedAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            if (this.names.contains(StaticUtils.toLowerCase(a.getBaseName()))) {
                updatedAttributes.add(new Attribute(a.getName(), this.schema, newValue));
                continue;
            }
            updatedAttributes.add(a);
        }
        return new Entry(dn, this.schema, updatedAttributes);
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }
}

