/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.ManageCertificates;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SelfSignedCertificateGenerator {
    private SelfSignedCertificateGenerator() {
    }

    public static ObjectPair<File, char[]> generateTemporarySelfSignedCertificate(String toolName, String keyStoreType) throws CertException {
        File keyStoreFile;
        try {
            keyStoreFile = File.createTempFile("temp-keystore-", ".jks");
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(ListenerMessages.ERR_SELF_SIGNED_CERT_GENERATOR_CANNOT_CREATE_FILE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        keyStoreFile.delete();
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[50];
        random.nextBytes(randomBytes);
        String keyStorePIN = Base64.encode(randomBytes);
        SelfSignedCertificateGenerator.generateSelfSignedCertificate(toolName, keyStoreFile, keyStorePIN, keyStoreType, "server-cert");
        return new ObjectPair<File, char[]>(keyStoreFile, keyStorePIN.toCharArray());
    }

    public static void generateSelfSignedCertificate(String toolName, File keyStoreFile, String keyStorePIN, String keyStoreType, String alias) throws CertException {
        NameResolver nameResolver = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER;
        LinkedHashSet<InetAddress> localAddresses = new LinkedHashSet<InetAddress>(20);
        try {
            localAddresses.add(nameResolver.getLocalHost());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
                while (interfaceAddresses.hasMoreElements()) {
                    localAddresses.add(interfaceAddresses.nextElement());
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            localAddresses.add(nameResolver.getLoopbackAddress());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        LinkedHashSet<String> localAddressNames = new LinkedHashSet<String>(20);
        for (InetAddress localAddress : localAddresses) {
            String hostAddress = localAddress.getHostAddress();
            String trimmedHostAddress = SelfSignedCertificateGenerator.trimHostAddress(hostAddress);
            String canonicalHostName = nameResolver.getCanonicalHostName(localAddress);
            if (canonicalHostName.equalsIgnoreCase(hostAddress) || canonicalHostName.equalsIgnoreCase(trimmedHostAddress)) continue;
            localAddressNames.add(canonicalHostName);
        }
        DN subjectDN = localAddresses.isEmpty() ? new DN(new RDN("CN", toolName)) : new DN(new RDN("CN", nameResolver.getCanonicalHostName((InetAddress)localAddresses.iterator().next())), new RDN("OU", toolName));
        long oneDayAgoTime = System.currentTimeMillis() - 86400000L;
        Date oneDayAgoDate = new Date(oneDayAgoTime);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String yesterdayTimeStamp = dateFormatter.format(oneDayAgoDate);
        ArrayList<String> argList = new ArrayList<String>(30);
        argList.add("generate-self-signed-certificate");
        argList.add("--keystore");
        argList.add(keyStoreFile.getAbsolutePath());
        argList.add("--keystore-password");
        argList.add(keyStorePIN);
        argList.add("--keystore-type");
        argList.add(keyStoreType);
        argList.add("--alias");
        argList.add(alias);
        argList.add("--subject-dn");
        argList.add(subjectDN.toString());
        argList.add("--days-valid");
        argList.add("3650");
        argList.add("--validityStartTime");
        argList.add(yesterdayTimeStamp);
        argList.add("--key-algorithm");
        argList.add("RSA");
        argList.add("--key-size-bits");
        argList.add("2048");
        argList.add("--signature-algorithm");
        argList.add("SHA256withRSA");
        for (String hostName : localAddressNames) {
            argList.add("--subject-alternative-name-dns");
            argList.add(hostName);
        }
        for (InetAddress address : localAddresses) {
            argList.add("--subject-alternative-name-ip-address");
            argList.add(SelfSignedCertificateGenerator.trimHostAddress(address.getHostAddress()));
        }
        argList.add("--key-usage");
        argList.add("digitalSignature");
        argList.add("--key-usage");
        argList.add("keyEncipherment");
        argList.add("--extended-key-usage");
        argList.add("server-auth");
        argList.add("--extended-key-usage");
        argList.add("client-auth");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ResultCode resultCode = ManageCertificates.main(null, output, output, argList.toArray(StaticUtils.NO_STRINGS));
        if (resultCode != ResultCode.SUCCESS) {
            throw new CertException(ListenerMessages.ERR_SELF_SIGNED_CERT_GENERATOR_ERROR_GENERATING_CERT.get(StaticUtils.toUTF8String(output.toByteArray())));
        }
    }

    private static String trimHostAddress(String hostAddress) {
        int percentPos = hostAddress.indexOf(37);
        if (percentPos > 0) {
            return hostAddress.substring(0, percentPos);
        }
        return hostAddress;
    }
}

