/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdge;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIndex;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.id.IdElement;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertex;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIndex;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public class IdGraph<T extends KeyIndexableGraph>
implements KeyIndexableGraph,
WrapperGraph<T>,
IndexableGraph,
TransactionalGraph {
    public static final String ID = "__id";
    private final T baseGraph;
    private final IdFactory vertexIdFactory;
    private final IdFactory edgeIdFactory;
    private final boolean vertexIndexing;
    private final boolean edgeIndexing;
    private final Features features;
    private boolean uniqueIds = true;

    public IdGraph(T baseGraph) {
        this(baseGraph, null);
    }

    public IdGraph(T baseGraph, IdFactory idFactory) {
        this(baseGraph, idFactory, idFactory);
    }

    public IdGraph(T baseGraph, IdFactory vertexIdFactory, IdFactory edgeIdFactory) {
        this.baseGraph = baseGraph;
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
        this.features.ignoresSuppliedIds = false;
        this.vertexIdFactory = null == vertexIdFactory ? new DefaultIdFactory() : vertexIdFactory;
        this.edgeIdFactory = null == edgeIdFactory ? new DefaultIdFactory() : edgeIdFactory;
        this.vertexIndexing = baseGraph.getFeatures().supportsVertexIndex;
        this.edgeIndexing = baseGraph.getFeatures().supportsEdgeIndex;
        this.createIndices();
    }

    public IdFactory getVertexIdFactory() {
        return this.vertexIdFactory;
    }

    public IdFactory getEdgeIdFactory() {
        return this.edgeIdFactory;
    }

    private void createIndices() {
        if (!this.baseGraph.getIndexedKeys(Vertex.class).contains(ID)) {
            this.baseGraph.createKeyIndex(ID, Vertex.class);
        }
        if (!this.baseGraph.getIndexedKeys(Edge.class).contains(ID)) {
            this.baseGraph.createKeyIndex(ID, Edge.class);
        }
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public Vertex addVertex(Object id) {
        Object v;
        if (this.uniqueIds && null != id && null != this.getVertex(id)) {
            throw new IllegalArgumentException("Vertex with given id already exists: '" + id + "'");
        }
        Vertex base = this.baseGraph.addVertex(null);
        Object object = v = null == id ? this.vertexIdFactory.createId() : id;
        if (null == v) {
            base.removeProperty(ID);
        } else {
            base.setProperty(ID, v);
        }
        return new IdVertex(base);
    }

    @Override
    public Vertex getVertex(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        Iterable<Vertex> i = this.baseGraph.getVertices(ID, id);
        Iterator<Vertex> iter = i.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Vertex e = iter.next();
        if (iter.hasNext()) {
            throw new IllegalStateException("multiple vertices exist with id '" + id + "'");
        }
        return new IdVertex(e);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        IdGraph.verifyNativeElement(vertex);
        this.baseGraph.removeVertex(((IdVertex)vertex).getBaseVertex());
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new IdVertexIterable(this.baseGraph.getVertices());
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        if (key.equals(ID)) {
            throw new IllegalArgumentException("Index key __id is reserved by IdGraph");
        }
        return new IdVertexIterable(this.baseGraph.getVertices(key, value));
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Object v;
        if (this.uniqueIds && null != id && null != this.getEdge(id)) {
            throw new IllegalArgumentException("Edge with given id already exists: " + id);
        }
        IdGraph.verifyNativeElement(outVertex);
        IdGraph.verifyNativeElement(inVertex);
        Edge base = this.baseGraph.addEdge(null, ((IdVertex)outVertex).getBaseVertex(), ((IdVertex)inVertex).getBaseVertex(), label);
        Object object = v = null == id ? this.edgeIdFactory.createId() : id;
        if (null == v) {
            base.removeProperty(ID);
        } else {
            base.setProperty(ID, v);
        }
        return new IdEdge(base);
    }

    @Override
    public Edge getEdge(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        Iterable<Edge> i = this.baseGraph.getEdges(ID, id);
        Iterator<Edge> iter = i.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Edge e = iter.next();
        if (iter.hasNext()) {
            throw new IllegalStateException("Multiple edges exist with id " + id);
        }
        return new IdEdge(e);
    }

    @Override
    public void removeEdge(Edge edge) {
        IdGraph.verifyNativeElement(edge);
        this.baseGraph.removeEdge(((IdEdge)edge).getBaseEdge());
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new IdEdgeIterable(this.baseGraph.getEdges());
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        if (key.equals(ID)) {
            throw new IllegalArgumentException("Index key __id is reserved by IdGraph");
        }
        return new IdEdgeIterable(this.baseGraph.getEdges(key, value));
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (this.baseGraph instanceof TransactionalGraph) {
            ((TransactionalGraph)this.baseGraph).stopTransaction(conclusion);
        }
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    private static void verifyNativeElement(Element e) {
        if (!(e instanceof IdElement)) {
            throw new IllegalArgumentException("Given element was not created in this graph");
        }
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        if (key.equals(ID)) {
            throw new IllegalArgumentException("Index key __id is reserved by IdGraph");
        }
        this.baseGraph.dropKeyIndex(key, elementClass);
    }

    @Override
    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass) {
        if (key.equals(ID)) {
            throw new IllegalArgumentException("Index key __id is reserved by IdGraph");
        }
        this.baseGraph.createKeyIndex(key, elementClass);
    }

    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.baseGraph.getIndexedKeys(elementClass));
        keys.remove(ID);
        return keys;
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    public void enforceUniqueIds(boolean enforceUniqueIds) {
        this.uniqueIds = enforceUniqueIds;
    }

    @Override
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        this.verifyBaseGraphIsIndexableGraph();
        return this.isVertexClass(indexClass) ? new IdVertexIndex(((IndexableGraph)this.baseGraph).createIndex(indexName, indexClass, indexParameters)) : new IdEdgeIndex(((IndexableGraph)this.baseGraph).createIndex(indexName, indexClass, indexParameters));
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        this.verifyBaseGraphIsIndexableGraph();
        if (this.isVertexClass(indexClass)) {
            Index<Vertex> baseIndex = ((IndexableGraph)this.baseGraph).getIndex(indexName, indexClass);
            return null == baseIndex ? null : new IdVertexIndex(baseIndex);
        }
        Index<Edge> baseIndex = ((IndexableGraph)this.baseGraph).getIndex(indexName, indexClass);
        return null == baseIndex ? null : new IdEdgeIndex(baseIndex);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        throw new UnsupportedOperationException("sorry, you currently can't get a list of indexes through IdGraph");
    }

    @Override
    public void dropIndex(String indexName) {
        this.verifyBaseGraphIsIndexableGraph();
        ((IndexableGraph)this.baseGraph).dropIndex(indexName);
    }

    private void verifyBaseGraphIsIndexableGraph() {
        if (!(this.baseGraph instanceof IndexableGraph)) {
            throw new IllegalStateException("base graph is not an indexable graph");
        }
    }

    private boolean isVertexClass(Class c) {
        return Vertex.class.isAssignableFrom(c);
    }

    private static class DefaultIdFactory
    implements IdFactory {
        private DefaultIdFactory() {
        }

        @Override
        public Object createId() {
            return UUID.randomUUID().toString();
        }
    }

    public static interface IdFactory {
        public Object createId();
    }
}

