/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event.listener;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.util.ArrayList;
import java.util.List;

public class StubGraphChangedListener
implements GraphChangedListener {
    private int addEdgeEvent = 0;
    private int addVertexEvent = 0;
    private int vertexPropertyChangedEvent = 0;
    private int vertexPropertyRemovedEvent = 0;
    private int vertexRemovedEvent = 0;
    private int edgePropertyChangedEvent = 0;
    private int edgePropertyRemovedEvent = 0;
    private int edgeRemovedEvent = 0;
    private final List<String> order = new ArrayList<String>();

    public void reset() {
        this.addEdgeEvent = 0;
        this.addVertexEvent = 0;
        this.vertexPropertyChangedEvent = 0;
        this.vertexPropertyRemovedEvent = 0;
        this.vertexRemovedEvent = 0;
        this.edgePropertyChangedEvent = 0;
        this.edgePropertyRemovedEvent = 0;
        this.edgeRemovedEvent = 0;
        this.order.clear();
    }

    public List<String> getOrder() {
        return this.order;
    }

    @Override
    public void vertexAdded(Vertex vertex) {
        ++this.addVertexEvent;
        this.order.add("v-added-" + vertex.getId());
    }

    @Override
    public void vertexPropertyChanged(Vertex vertex, String s, Object o) {
        ++this.vertexPropertyChangedEvent;
        this.order.add("v-property-changed-" + vertex.getId() + "-" + s + ":" + o);
    }

    @Override
    public void vertexPropertyRemoved(Vertex vertex, String s, Object o) {
        ++this.vertexPropertyRemovedEvent;
        this.order.add("v-property-removed-" + vertex.getId() + "-" + s + ":" + o);
    }

    @Override
    public void vertexRemoved(Vertex vertex) {
        ++this.vertexRemovedEvent;
        this.order.add("v-removed-" + vertex.getId());
    }

    @Override
    public void edgeAdded(Edge edge) {
        ++this.addEdgeEvent;
        this.order.add("e-added-" + edge.getId());
    }

    @Override
    public void edgePropertyChanged(Edge edge, String s, Object o) {
        ++this.edgePropertyChangedEvent;
        this.order.add("e-property-changed-" + edge.getId() + "-" + s + ":" + o);
    }

    @Override
    public void edgePropertyRemoved(Edge edge, String s, Object o) {
        ++this.edgePropertyRemovedEvent;
        this.order.add("e-property-removed-" + edge.getId() + "-" + s + ":" + o);
    }

    @Override
    public void edgeRemoved(Edge edge) {
        ++this.edgeRemovedEvent;
        this.order.add("e-removed-" + edge.getId());
    }

    public int addEdgeEventRecorded() {
        return this.addEdgeEvent;
    }

    public int addVertexEventRecorded() {
        return this.addVertexEvent;
    }

    public int vertexPropertyChangedEventRecorded() {
        return this.vertexPropertyChangedEvent;
    }

    public int vertexPropertyRemovedEventRecorded() {
        return this.vertexPropertyRemovedEvent;
    }

    public int vertexRemovedEventRecorded() {
        return this.vertexRemovedEvent;
    }

    public int edgePropertyChangedEventRecorded() {
        return this.edgePropertyChangedEvent;
    }

    public int edgePropertyRemovedEventRecorded() {
        return this.edgePropertyRemovedEvent;
    }

    public int edgeRemovedEventRecorded() {
        return this.edgeRemovedEvent;
    }
}

