/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.blueprints.util.wrappers.event.listener.Event;
import java.util.ArrayList;
import java.util.List;

class EventTrigger {
    private final ThreadLocal<List<Event>> eventQueue = new ThreadLocal<List<Event>>(){

        @Override
        protected List<Event> initialValue() {
            return new ArrayList<Event>();
        }
    };
    private final boolean enqueEvents;
    private final EventGraph graph;

    public EventTrigger(EventGraph graph, boolean enqueEvents) {
        this.enqueEvents = enqueEvents;
        this.graph = graph;
    }

    public void addEvent(Event evt) {
        this.eventQueue.get().add(evt);
        if (!this.enqueEvents) {
            this.fireEventQueue();
            this.resetEventQueue();
        }
    }

    public void resetEventQueue() {
        this.eventQueue.set(new ArrayList());
    }

    public void fireEventQueue() {
        for (Event event : this.eventQueue.get()) {
            event.fireEvent(this.graph.getListenerIterator());
        }
    }
}

