/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.wrappers.event.EventTrigger;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgePropertyChangedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgePropertyRemovedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexPropertyChangedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexPropertyRemovedEvent;
import java.util.List;
import java.util.Set;

public abstract class EventElement
implements Element {
    protected final EventTrigger trigger;
    protected final Element baseElement;
    protected final List<GraphChangedListener> graphChangedListeners;

    protected EventElement(Element baseElement, List<GraphChangedListener> graphChangedListeners, EventTrigger trigger) {
        this.baseElement = baseElement;
        this.graphChangedListeners = graphChangedListeners;
        this.trigger = trigger;
    }

    protected void onVertexPropertyChanged(Vertex vertex, String key, Object newValue) {
        this.trigger.addEvent(new VertexPropertyChangedEvent(vertex, key, newValue));
    }

    protected void onEdgePropertyChanged(Edge edge, String key, Object newValue) {
        this.trigger.addEvent(new EdgePropertyChangedEvent(edge, key, newValue));
    }

    protected void onVertexPropertyRemoved(Vertex vertex, String key, Object newValue) {
        this.trigger.addEvent(new VertexPropertyRemovedEvent(vertex, key, newValue));
    }

    protected void onEdgePropertyRemoved(Edge edge, String key, Object removedValue) {
        this.trigger.addEvent(new EdgePropertyRemovedEvent(edge, key, removedValue));
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.baseElement.getPropertyKeys();
    }

    @Override
    public Object getId() {
        return this.baseElement.getId();
    }

    @Override
    public Object removeProperty(String key) {
        Object propertyRemoved = this.baseElement.removeProperty(key);
        if (this instanceof Vertex) {
            this.onVertexPropertyRemoved((Vertex)((Object)this), key, propertyRemoved);
        } else if (this instanceof Edge) {
            this.onEdgePropertyRemoved((Edge)((Object)this), key, propertyRemoved);
        }
        return propertyRemoved;
    }

    @Override
    public Object getProperty(String key) {
        return this.baseElement.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.baseElement.setProperty(key, value);
        if (this instanceof Vertex) {
            this.onVertexPropertyChanged((Vertex)((Object)this), key, value);
        } else if (this instanceof Edge) {
            this.onEdgePropertyChanged((Edge)((Object)this), key, value);
        }
    }

    public String toString() {
        return this.baseElement.toString();
    }

    public int hashCode() {
        return this.baseElement.hashCode();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    public Element getBaseElement() {
        return this.baseElement;
    }
}

