/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.HashMap;
import java.util.Map;

public class ObjectIDVertexCache
implements VertexCache {
    private static final int INITIAL_CAPACITY = 1000;
    private final Graph graph;
    private final Map<Object, Object> map;

    public ObjectIDVertexCache(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph expected.");
        }
        this.graph = graph;
        this.map = new HashMap<Object, Object>(1000);
    }

    @Override
    public Object getEntry(Object externalID) {
        return this.map.get(externalID);
    }

    @Override
    public void set(Vertex vertex, Object externalID) {
        this.map.put(externalID, vertex);
    }

    @Override
    public void newTransaction() {
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            if (!(entry.getValue() instanceof Vertex)) continue;
            Vertex v = (Vertex)entry.getValue();
            entry.setValue(v.getId());
        }
    }
}

