/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.batch.WritethroughGraph;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.LongIDVertexCache;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.ObjectIDVertexCache;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.StringIDVertexCache;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.URLCompression;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.Iterator;
import java.util.Set;

public class BatchGraph<T extends TransactionalGraph>
implements TransactionalGraph,
WrapperGraph<T> {
    public static final long DEFAULT_BUFFER_SIZE = 100000L;
    private final T baseGraph;
    private String vertexIdKey = null;
    private String edgeIdKey = null;
    private boolean loadingFromScratch = true;
    private final VertexCache cache;
    private long bufferSize = 100000L;
    private long remainingBufferSize;
    private BatchEdge currentEdge = null;
    private Edge currentEdgeCached = null;

    public BatchGraph(T graph, IdType type, long bufferSize) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph may not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type may not be null");
        }
        if (bufferSize <= 0L) {
            throw new IllegalArgumentException("BufferSize must be positive");
        }
        this.baseGraph = graph;
        this.bufferSize = bufferSize;
        this.vertexIdKey = null;
        this.edgeIdKey = null;
        this.cache = type.getVertexCache(this.baseGraph);
        this.remainingBufferSize = this.bufferSize;
    }

    public BatchGraph(T graph) {
        this(graph, IdType.OBJECT, 100000L);
    }

    public static BatchGraph wrap(Graph graph) {
        if (graph instanceof BatchGraph) {
            return (BatchGraph)graph;
        }
        if (graph instanceof TransactionalGraph) {
            return new BatchGraph<TransactionalGraph>((TransactionalGraph)graph);
        }
        return new BatchGraph<WritethroughGraph<Graph>>(new WritethroughGraph<Graph>(graph));
    }

    public static BatchGraph wrap(Graph graph, long buffer) {
        if (graph instanceof BatchGraph) {
            return (BatchGraph)graph;
        }
        if (graph instanceof TransactionalGraph) {
            return new BatchGraph<TransactionalGraph>((TransactionalGraph)graph, IdType.OBJECT, buffer);
        }
        return new BatchGraph<WritethroughGraph<Graph>>(new WritethroughGraph<Graph>(graph), IdType.OBJECT, buffer);
    }

    public void setVertexIdKey(String key) {
        if (!this.loadingFromScratch && key == null && this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            throw new IllegalStateException("Cannot set vertex id key to null when not loading from scratch while ids are ignored.");
        }
        this.vertexIdKey = key;
    }

    public String getVertexIdKey() {
        return this.vertexIdKey;
    }

    public void setEdgeIdKey(String key) {
        this.edgeIdKey = key;
    }

    public String getEdgeIdKey() {
        return this.edgeIdKey;
    }

    public void setLoadingFromScratch(boolean fromScratch) {
        if (!fromScratch && this.vertexIdKey == null && this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            throw new IllegalStateException("Vertex id key is required to query existing vertices in wrapped graph.");
        }
        this.loadingFromScratch = fromScratch;
    }

    public boolean isLoadingFromScratch() {
        return this.loadingFromScratch;
    }

    private void nextElement() {
        this.currentEdge = null;
        this.currentEdgeCached = null;
        if (this.remainingBufferSize <= 0L) {
            this.baseGraph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            this.cache.newTransaction();
            this.remainingBufferSize = this.bufferSize;
        }
        --this.remainingBufferSize;
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (conclusion != TransactionalGraph.Conclusion.SUCCESS) {
            throw new IllegalArgumentException("Cannot abort batch loading");
        }
        this.currentEdge = null;
        this.currentEdgeCached = null;
        this.remainingBufferSize = 0L;
        this.baseGraph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
    }

    @Override
    public void shutdown() {
        this.baseGraph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        this.baseGraph.shutdown();
        this.currentEdge = null;
        this.currentEdgeCached = null;
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Features getFeatures() {
        Features features = this.baseGraph.getFeatures().copyFeatures();
        features.ignoresSuppliedIds = false;
        features.isWrapper = true;
        features.supportsEdgeIteration = false;
        features.supportsThreadedTransactions = false;
        features.supportsVertexIteration = false;
        return features;
    }

    private Vertex retrieveFromCache(Object externalID) {
        Object internal = this.cache.getEntry(externalID);
        if (internal instanceof Vertex) {
            return (Vertex)internal;
        }
        if (internal != null) {
            Vertex v = this.baseGraph.getVertex(internal);
            this.cache.set(v, externalID);
            return v;
        }
        return null;
    }

    private Vertex getCachedVertex(Object externalID) {
        Vertex v = this.retrieveFromCache(externalID);
        if (v == null) {
            throw new IllegalArgumentException("Vertex for given ID cannot be found: " + externalID);
        }
        return v;
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex v = this.retrieveFromCache(id);
        if (v == null) {
            if (this.loadingFromScratch) {
                return null;
            }
            if (this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
                assert (this.vertexIdKey != null);
                Iterator<Vertex> iter = this.baseGraph.getVertices(this.vertexIdKey, id).iterator();
                if (!iter.hasNext()) {
                    return null;
                }
                v = iter.next();
                if (iter.hasNext()) {
                    throw new IllegalArgumentException("There are multiple vertices with the provided id in the database: " + id);
                }
            } else {
                v = this.baseGraph.getVertex(id);
                if (v == null) {
                    return null;
                }
            }
            this.cache.set(v, id);
        }
        return new BatchVertex(id);
    }

    @Override
    public Vertex addVertex(Object id) {
        if (id == null) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (this.retrieveFromCache(id) != null) {
            throw ExceptionFactory.vertexWithIdAlreadyExists(id);
        }
        this.nextElement();
        Vertex v = this.baseGraph.addVertex(id);
        if (this.vertexIdKey != null) {
            v.setProperty(this.vertexIdKey, id);
        }
        this.cache.set(v, id);
        return new BatchVertex(id);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        if (!BatchVertex.class.isInstance(outVertex) || !BatchVertex.class.isInstance(inVertex)) {
            throw new IllegalArgumentException("Given element was not created in this baseGraph");
        }
        this.nextElement();
        Vertex ov = this.getCachedVertex(outVertex.getId());
        Vertex iv = this.getCachedVertex(inVertex.getId());
        this.currentEdgeCached = this.baseGraph.addEdge(id, ov, iv, label);
        if (this.edgeIdKey != null && id != null) {
            this.currentEdgeCached.setProperty(this.edgeIdKey, id);
        }
        this.currentEdge = new BatchEdge();
        return this.currentEdge;
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public Edge getEdge(Object id) {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public void removeVertex(Vertex vertex) {
        throw BatchGraph.removalNotSupported();
    }

    @Override
    public Iterable<Vertex> getVertices() {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public void removeEdge(Edge edge) {
        throw BatchGraph.removalNotSupported();
    }

    @Override
    public Iterable<Edge> getEdges() {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        throw BatchGraph.retrievalNotSupported();
    }

    private static UnsupportedOperationException retrievalNotSupported() {
        return new UnsupportedOperationException("Retrieval operations are not supported during batch loading");
    }

    private static UnsupportedOperationException removalNotSupported() {
        return new UnsupportedOperationException("Removal operations are not supported during batch loading");
    }

    private class BatchEdge
    implements Edge {
        private BatchEdge() {
        }

        @Override
        public Vertex getVertex(Direction direction) throws IllegalArgumentException {
            return this.getWrappedEdge().getVertex(direction);
        }

        @Override
        public String getLabel() {
            return this.getWrappedEdge().getLabel();
        }

        @Override
        public void setProperty(String key, Object value) {
            this.getWrappedEdge().setProperty(key, value);
        }

        @Override
        public Object getId() {
            return this.getWrappedEdge().getId();
        }

        @Override
        public Object getProperty(String key) {
            return this.getWrappedEdge().getProperty(key);
        }

        @Override
        public Set<String> getPropertyKeys() {
            return this.getWrappedEdge().getPropertyKeys();
        }

        @Override
        public Object removeProperty(String key) {
            return this.getWrappedEdge().removeProperty(key);
        }

        private Edge getWrappedEdge() {
            if (this != BatchGraph.this.currentEdge) {
                throw new UnsupportedOperationException("This edge is no longer in scope");
            }
            return BatchGraph.this.currentEdgeCached;
        }

        public String toString() {
            return this.getWrappedEdge().toString();
        }
    }

    private class BatchVertex
    implements Vertex {
        private final Object externalID;

        BatchVertex(Object id) {
            if (id == null) {
                throw new IllegalArgumentException("External id may not be null");
            }
            this.externalID = id;
        }

        @Override
        public Iterable<Edge> getEdges(Direction direction, String ... labels) {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public Query query() {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public void setProperty(String key, Object value) {
            BatchGraph.this.getCachedVertex(this.externalID).setProperty(key, value);
        }

        @Override
        public Object getId() {
            return this.externalID;
        }

        @Override
        public Object getProperty(String key) {
            return BatchGraph.this.getCachedVertex(this.externalID).getProperty(key);
        }

        @Override
        public Set<String> getPropertyKeys() {
            return BatchGraph.this.getCachedVertex(this.externalID).getPropertyKeys();
        }

        @Override
        public Object removeProperty(String key) {
            return BatchGraph.this.getCachedVertex(this.externalID).removeProperty(key);
        }

        public String toString() {
            return "v[" + this.externalID + "]";
        }
    }

    public static enum IdType {
        OBJECT,
        NUMBER,
        STRING,
        URL;


        private VertexCache getVertexCache(Graph g) {
            switch (this) {
                case OBJECT: {
                    return new ObjectIDVertexCache(g);
                }
                case NUMBER: {
                    return new LongIDVertexCache(g);
                }
                case STRING: {
                    return new StringIDVertexCache(g);
                }
                case URL: {
                    return new StringIDVertexCache(g, new URLCompression());
                }
            }
            throw new IllegalArgumentException("Unrecognized ID type: " + (Object)((Object)this));
        }
    }
}

