/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.mount.Mount;
import com.spotify.docker.client.messages.swarm.AutoValue_ContainerSpec;
import com.spotify.docker.client.messages.swarm.ConfigBind;
import com.spotify.docker.client.messages.swarm.DnsConfig;
import com.spotify.docker.client.messages.swarm.SecretBind;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ContainerSpec {
    @JsonProperty(value="Image")
    public abstract String image();

    @Nullable
    @JsonProperty(value="Hostname")
    public abstract String hostname();

    @Nullable
    @JsonProperty(value="Labels")
    public abstract ImmutableMap<String, String> labels();

    @Nullable
    @JsonProperty(value="Command")
    public abstract ImmutableList<String> command();

    @Nullable
    @JsonProperty(value="Args")
    public abstract ImmutableList<String> args();

    @Nullable
    @JsonProperty(value="Env")
    public abstract ImmutableList<String> env();

    @Nullable
    @JsonProperty(value="Dir")
    public abstract String dir();

    @Nullable
    @JsonProperty(value="User")
    public abstract String user();

    @Nullable
    @JsonProperty(value="Groups")
    public abstract ImmutableList<String> groups();

    @Nullable
    @JsonProperty(value="TTY")
    public abstract Boolean tty();

    @Nullable
    @JsonProperty(value="Mounts")
    public abstract ImmutableList<Mount> mounts();

    @Nullable
    @JsonProperty(value="StopGracePeriod")
    public abstract Long stopGracePeriod();

    @Nullable
    @JsonProperty(value="Healthcheck")
    public abstract ContainerConfig.Healthcheck healthcheck();

    @Nullable
    @JsonProperty(value="Hosts")
    public abstract ImmutableList<String> hosts();

    @Nullable
    @JsonProperty(value="Secrets")
    public abstract ImmutableList<SecretBind> secrets();

    @Nullable
    @JsonProperty(value="Configs")
    public abstract ImmutableList<ConfigBind> configs();

    @Nullable
    @JsonProperty(value="DNSConfig")
    public abstract DnsConfig dnsConfig();

    public static Builder builder() {
        return new AutoValue_ContainerSpec.Builder();
    }

    @JsonCreator
    static ContainerSpec create(@JsonProperty(value="Image") String image, @JsonProperty(value="Labels") Map<String, String> labels, @JsonProperty(value="Hostname") String hostname, @JsonProperty(value="Command") List<String> command, @JsonProperty(value="Args") List<String> args, @JsonProperty(value="Env") List<String> env, @JsonProperty(value="Dir") String dir, @JsonProperty(value="User") String user, @JsonProperty(value="Groups") List<String> groups, @JsonProperty(value="TTY") Boolean tty, @JsonProperty(value="Mounts") List<Mount> mounts, @JsonProperty(value="StopGracePeriod") Long stopGracePeriod, @JsonProperty(value="Healthcheck") ContainerConfig.Healthcheck healthcheck, @JsonProperty(value="Hosts") List<String> hosts, @JsonProperty(value="Secrets") List<SecretBind> secrets, @JsonProperty(value="DNSConfig") DnsConfig dnsConfig, @JsonProperty(value="Configs") List<ConfigBind> configs) {
        Builder builder = ContainerSpec.builder().image(image).hostname(hostname).args(args).env(env).dir(dir).user(user).groups(groups).tty(tty).mounts(mounts).stopGracePeriod(stopGracePeriod).healthcheck(healthcheck).hosts(hosts).dnsConfig(dnsConfig);
        if (labels != null) {
            builder.labels(labels);
        }
        if (command != null) {
            builder.command(command);
        }
        if (secrets != null) {
            builder.secrets(secrets);
        }
        if (configs != null) {
            builder.configs(configs);
        }
        return builder.build();
    }

    public static abstract class Builder {
        public abstract Builder image(String var1);

        @Deprecated
        public Builder withImage(String image) {
            this.image(image);
            return this;
        }

        abstract ImmutableMap.Builder<String, String> labelsBuilder();

        public Builder addLabel(String label, String value) {
            this.labelsBuilder().put(label, value);
            return this;
        }

        @Deprecated
        public Builder withLabel(String label, String value) {
            this.addLabel(label, value);
            return this;
        }

        public abstract Builder hostname(String var1);

        public abstract Builder labels(Map<String, String> var1);

        public abstract Builder command(String ... var1);

        public abstract Builder command(List<String> var1);

        @Deprecated
        public Builder withCommands(String ... commands) {
            if (commands != null && commands.length > 0) {
                this.command(commands);
            }
            return this;
        }

        @Deprecated
        public Builder withCommands(List<String> commands) {
            if (commands != null && !commands.isEmpty()) {
                this.command(commands);
            }
            return this;
        }

        public abstract Builder args(String ... var1);

        public abstract Builder args(List<String> var1);

        @Deprecated
        public Builder withArgs(String ... args) {
            if (args != null && args.length > 0) {
                this.args(args);
            }
            return this;
        }

        @Deprecated
        public Builder withArgs(List<String> args) {
            if (args != null && !args.isEmpty()) {
                this.args(args);
            }
            return this;
        }

        public abstract Builder env(String ... var1);

        public abstract Builder env(List<String> var1);

        @Deprecated
        public Builder withEnv(String ... env) {
            if (env != null && env.length > 0) {
                this.env(env);
            }
            return this;
        }

        @Deprecated
        public Builder withEnv(List<String> env) {
            this.env(env);
            return this;
        }

        public abstract Builder dir(String var1);

        @Deprecated
        public Builder withDir(String dir) {
            this.dir(dir);
            return this;
        }

        public abstract Builder user(String var1);

        @Deprecated
        public Builder withUser(String user) {
            this.user(user);
            return this;
        }

        public abstract Builder groups(String ... var1);

        public abstract Builder groups(List<String> var1);

        @Deprecated
        public Builder withGroups(String ... groups) {
            if (groups != null && groups.length > 0) {
                this.groups(groups);
            }
            return this;
        }

        @Deprecated
        public Builder withGroups(List<String> groups) {
            if (groups != null && !groups.isEmpty()) {
                this.groups(groups);
            }
            return this;
        }

        public abstract Builder tty(Boolean var1);

        @Deprecated
        public Builder withTty() {
            this.tty(true);
            return this;
        }

        @Deprecated
        public Builder withTty(boolean tty) {
            this.tty(tty);
            return this;
        }

        public abstract Builder mounts(Mount ... var1);

        public abstract Builder mounts(List<Mount> var1);

        @Deprecated
        public Builder withMounts(Mount ... mounts) {
            if (mounts != null && mounts.length > 0) {
                this.mounts(mounts);
            }
            return this;
        }

        @Deprecated
        public Builder withMounts(List<Mount> mounts) {
            if (mounts != null && !mounts.isEmpty()) {
                this.mounts(mounts);
            }
            return this;
        }

        public abstract Builder stopGracePeriod(Long var1);

        @Deprecated
        public Builder withStopGracePeriod(long stopGracePeriod) {
            this.stopGracePeriod(stopGracePeriod);
            return this;
        }

        public abstract Builder dnsConfig(DnsConfig var1);

        public abstract Builder healthcheck(ContainerConfig.Healthcheck var1);

        public abstract Builder hosts(List<String> var1);

        public abstract Builder secrets(List<SecretBind> var1);

        public abstract Builder configs(List<ConfigBind> var1);

        public abstract ContainerSpec build();
    }
}

