/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.spotify.docker.client.messages.AutoValue_ContainerConfig;
import com.spotify.docker.client.messages.AutoValue_ContainerConfig_Healthcheck;
import com.spotify.docker.client.messages.AutoValue_ContainerConfig_NetworkingConfig;
import com.spotify.docker.client.messages.EndpointConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableSet;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ContainerConfig {
    @Nullable
    @JsonProperty(value="Hostname")
    public abstract String hostname();

    @Nullable
    @JsonProperty(value="Domainname")
    public abstract String domainname();

    @Nullable
    @JsonProperty(value="User")
    public abstract String user();

    @Nullable
    @JsonProperty(value="AttachStdin")
    public abstract Boolean attachStdin();

    @Nullable
    @JsonProperty(value="AttachStdout")
    public abstract Boolean attachStdout();

    @Nullable
    @JsonProperty(value="AttachStderr")
    public abstract Boolean attachStderr();

    @Nullable
    @JsonProperty(value="PortSpecs")
    public abstract ImmutableList<String> portSpecs();

    @Nullable
    @JsonProperty(value="ExposedPorts")
    public abstract ImmutableSet<String> exposedPorts();

    @Nullable
    @JsonProperty(value="Tty")
    public abstract Boolean tty();

    @Nullable
    @JsonProperty(value="OpenStdin")
    public abstract Boolean openStdin();

    @Nullable
    @JsonProperty(value="StdinOnce")
    public abstract Boolean stdinOnce();

    @Nullable
    @JsonProperty(value="Env")
    public abstract ImmutableList<String> env();

    @Nullable
    @JsonProperty(value="Cmd")
    public abstract ImmutableList<String> cmd();

    @Nullable
    @JsonProperty(value="Image")
    public abstract String image();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public Set<String> volumeNames() {
        return this.volumes() == null ? Collections.emptySet() : this.volumes().keySet();
    }

    @Nullable
    @JsonProperty(value="Volumes")
    public abstract ImmutableMap<String, Map> volumes();

    @Nullable
    @JsonProperty(value="WorkingDir")
    public abstract String workingDir();

    @Nullable
    @JsonProperty(value="Entrypoint")
    public abstract ImmutableList<String> entrypoint();

    @Nullable
    @JsonProperty(value="NetworkDisabled")
    public abstract Boolean networkDisabled();

    @Nullable
    @JsonProperty(value="OnBuild")
    public abstract ImmutableList<String> onBuild();

    @Nullable
    @JsonProperty(value="Labels")
    public abstract ImmutableMap<String, String> labels();

    @Nullable
    @JsonProperty(value="MacAddress")
    public abstract String macAddress();

    @Nullable
    @JsonProperty(value="HostConfig")
    public abstract HostConfig hostConfig();

    @Nullable
    @JsonProperty(value="StopSignal")
    public abstract String stopSignal();

    @Nullable
    @JsonProperty(value="Healthcheck")
    public abstract Healthcheck healthcheck();

    @Deprecated
    public String getStopSignal() {
        return this.stopSignal();
    }

    @Nullable
    @JsonProperty(value="NetworkingConfig")
    public abstract NetworkingConfig networkingConfig();

    @JsonCreator
    static ContainerConfig create(@JsonProperty(value="Hostname") String hostname, @JsonProperty(value="Domainname") String domainname, @JsonProperty(value="User") String user, @JsonProperty(value="AttachStdin") Boolean attachStdin, @JsonProperty(value="AttachStdout") Boolean attachStdout, @JsonProperty(value="AttachStderr") Boolean attachStderr, @JsonProperty(value="PortSpecs") List<String> portSpecs, @JsonProperty(value="ExposedPorts") Set<String> exposedPorts, @JsonProperty(value="Tty") Boolean tty, @JsonProperty(value="OpenStdin") Boolean openStdin, @JsonProperty(value="StdinOnce") Boolean stdinOnce, @JsonProperty(value="Env") List<String> env, @JsonProperty(value="Cmd") List<String> cmd, @JsonProperty(value="Image") String image, @JsonProperty(value="Volumes") Map<String, Map> volumes, @JsonProperty(value="WorkingDir") String workingDir, @JsonProperty(value="Entrypoint") List<String> entrypoint, @JsonProperty(value="NetworkDisabled") Boolean networkDisabled, @JsonProperty(value="OnBuild") List<String> onBuild, @JsonProperty(value="Labels") Map<String, String> labels, @JsonProperty(value="MacAddress") String macAddress, @JsonProperty(value="HostConfig") HostConfig hostConfig, @JsonProperty(value="StopSignal") String stopSignal, @JsonProperty(value="Healthcheck") Healthcheck healthcheck, @JsonProperty(value="NetworkingConfig") NetworkingConfig networkingConfig) {
        Builder builder = ContainerConfig.builder().hostname(hostname).domainname(domainname).user(user).attachStdin(attachStdin).attachStdout(attachStdout).attachStderr(attachStderr).tty(tty).openStdin(openStdin).stdinOnce(stdinOnce).image(image).workingDir(workingDir).networkDisabled(networkDisabled).macAddress(macAddress).hostConfig(hostConfig).stopSignal(stopSignal).networkingConfig(networkingConfig);
        if (portSpecs != null) {
            builder.portSpecs(portSpecs);
        }
        if (exposedPorts != null) {
            builder.exposedPorts(exposedPorts);
        }
        if (env != null) {
            builder.env(env);
        }
        if (cmd != null) {
            builder.cmd(cmd);
        }
        if (volumes != null) {
            builder.volumes(volumes);
        }
        if (entrypoint != null) {
            builder.entrypoint(entrypoint);
        }
        if (onBuild != null) {
            builder.onBuild(onBuild);
        }
        if (labels != null) {
            builder.labels(labels);
        }
        if (healthcheck != null) {
            builder.healthcheck(healthcheck);
        }
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ContainerConfig.Builder();
    }

    public static abstract class NetworkingConfig {
        @JsonProperty(value="EndpointsConfig")
        public abstract ImmutableMap<String, EndpointConfig> endpointsConfig();

        @JsonCreator
        public static NetworkingConfig create(@JsonProperty(value="EndpointsConfig") Map<String, EndpointConfig> endpointsConfig) {
            ImmutableMap<String, EndpointConfig> endpointsConfigCopy = endpointsConfig == null ? ImmutableMap.of() : ImmutableMap.copyOf(endpointsConfig);
            return new AutoValue_ContainerConfig_NetworkingConfig(endpointsConfigCopy);
        }
    }

    public static abstract class Healthcheck {
        @Nullable
        @JsonProperty(value="Test")
        public abstract ImmutableList<String> test();

        @Nullable
        @JsonProperty(value="Interval")
        public abstract Long interval();

        @Nullable
        @JsonProperty(value="Timeout")
        public abstract Long timeout();

        @Nullable
        @JsonProperty(value="Retries")
        public abstract Integer retries();

        @Nullable
        @JsonProperty(value="StartPeriod")
        public abstract Long startPeriod();

        public static Healthcheck create(@JsonProperty(value="Test") List<String> test, @JsonProperty(value="Interval") Long interval, @JsonProperty(value="Timeout") Long timeout, @JsonProperty(value="Retries") Integer retries) {
            return Healthcheck.create(test, interval, timeout, retries, null);
        }

        @JsonCreator
        public static Healthcheck create(@JsonProperty(value="Test") List<String> test, @JsonProperty(value="Interval") Long interval, @JsonProperty(value="Timeout") Long timeout, @JsonProperty(value="Retries") Integer retries, @JsonProperty(value="StartPeriod") Long startPeriod) {
            return Healthcheck.builder().test(test).interval(interval).timeout(timeout).retries(retries).startPeriod(startPeriod).build();
        }

        public static Builder builder() {
            return new AutoValue_ContainerConfig_Healthcheck.Builder();
        }

        public static abstract class Builder {
            public abstract Builder test(List<String> var1);

            public abstract Builder interval(Long var1);

            public abstract Builder timeout(Long var1);

            public abstract Builder retries(Integer var1);

            public abstract Builder startPeriod(Long var1);

            public abstract Healthcheck build();
        }
    }

    public static abstract class Builder {
        public abstract Builder hostname(String var1);

        public abstract Builder domainname(String var1);

        public abstract Builder user(String var1);

        public abstract Builder attachStdin(Boolean var1);

        public abstract Builder attachStdout(Boolean var1);

        public abstract Builder attachStderr(Boolean var1);

        public abstract Builder portSpecs(List<String> var1);

        public abstract Builder portSpecs(String ... var1);

        public abstract Builder exposedPorts(Set<String> var1);

        public abstract Builder exposedPorts(String ... var1);

        public abstract Builder tty(Boolean var1);

        public abstract Builder openStdin(Boolean var1);

        public abstract Builder stdinOnce(Boolean var1);

        public abstract Builder env(List<String> var1);

        public abstract Builder env(String ... var1);

        public abstract Builder cmd(List<String> var1);

        public abstract Builder cmd(String ... var1);

        public abstract Builder image(String var1);

        abstract ImmutableMap.Builder<String, Map> volumesBuilder();

        public Builder addVolume(String volume) {
            this.volumesBuilder().put(volume, new HashMap());
            return this;
        }

        public Builder addVolumes(String ... volumes) {
            for (String volume : volumes) {
                this.volumesBuilder().put(volume, new HashMap());
            }
            return this;
        }

        public abstract Builder volumes(Map<String, Map> var1);

        @Deprecated
        public Builder volumes(Set<String> volumes) {
            if (volumes != null && !volumes.isEmpty()) {
                ImmutableMap.Builder volumesBuilder = ImmutableMap.builder();
                for (String volume : volumes) {
                    volumesBuilder.put(volume, new HashMap());
                }
                this.volumes(volumesBuilder.build());
            }
            return this;
        }

        @Deprecated
        public Builder volumes(String ... volumes) {
            if (volumes != null && volumes.length > 0) {
                this.volumes(ImmutableSet.copyOf(volumes));
            }
            return this;
        }

        public abstract Builder workingDir(String var1);

        public abstract Builder entrypoint(List<String> var1);

        public abstract Builder entrypoint(String ... var1);

        public abstract Builder networkDisabled(Boolean var1);

        public abstract Builder onBuild(List<String> var1);

        public abstract Builder onBuild(String ... var1);

        public abstract Builder labels(Map<String, String> var1);

        public abstract Builder macAddress(String var1);

        public abstract Builder hostConfig(HostConfig var1);

        public abstract Builder stopSignal(String var1);

        public abstract Builder healthcheck(Healthcheck var1);

        public abstract Builder networkingConfig(NetworkingConfig var1);

        public abstract ContainerConfig build();
    }
}

