/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.StreamResultHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.ColsChainRelativeModel;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FormatModel;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.LinkModel;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PivotModel;
import org.sagacity.sqltoy.config.model.ReverseModel;
import org.sagacity.sqltoy.config.model.RowsChainRelativeModel;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SummaryModel;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.config.model.TreeSortModel;
import org.sagacity.sqltoy.config.model.UnpivotModel;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.plugins.I18nThreadHolder;
import org.sagacity.sqltoy.plugins.calculator.ColsChainRelative;
import org.sagacity.sqltoy.plugins.calculator.GroupSummary;
import org.sagacity.sqltoy.plugins.calculator.ReverseList;
import org.sagacity.sqltoy.plugins.calculator.RowsChainRelative;
import org.sagacity.sqltoy.plugins.calculator.TreeDataSort;
import org.sagacity.sqltoy.plugins.calculator.UnpivotList;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.translate.TranslateConfigParse;
import org.sagacity.sqltoy.translate.TranslateManager;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultUtils.class);

    private ResultUtils() {
    }

    public static QueryResult processResultSet(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, Connection conn, ResultSet rs, QueryExecutorExtend queryExecutorExtend, UpdateRowHandler updateRowHandler, DecryptHandler decryptHandler, int startColIndex) throws Exception {
        QueryResult result = new QueryResult();
        int index = 0;
        if (queryExecutorExtend != null && queryExecutorExtend.rowCallbackHandler != null) {
            while (rs.next()) {
                queryExecutorExtend.rowCallbackHandler.processRow(rs, index);
                ++index;
            }
            result.setRows(queryExecutorExtend.rowCallbackHandler.getResult());
        } else {
            IgnoreCaseSet decryptColumns;
            IgnoreCaseSet ignoreCaseSet = decryptColumns = decryptHandler == null ? null : decryptHandler.getColumns();
            if (sqlToyConfig.getDecryptColumns() != null) {
                if (decryptColumns == null) {
                    decryptColumns = sqlToyConfig.getDecryptColumns();
                } else {
                    decryptColumns.addAll(sqlToyConfig.getDecryptColumns());
                }
            }
            DecryptHandler realDecryptHandler = null;
            if (decryptColumns != null && !decryptColumns.isEmpty()) {
                realDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), decryptColumns);
            }
            int rowCnt = rs.getMetaData().getColumnCount();
            Set<String> strTypeCols = ResultUtils.getStringColumns(sqlToyConfig);
            boolean hasToStrCols = !strTypeCols.isEmpty();
            String[] labelNames = new String[rowCnt - startColIndex];
            String[] labelTypes = new String[rowCnt - startColIndex];
            HashMap<String, Integer> labelIndexMap = new HashMap<String, Integer>();
            String colLabelUpperOrLower = sqlToyContext.getColumnLabelUpperOrLower();
            for (int i = startColIndex; i < rowCnt; ++i) {
                labelNames[index] = rs.getMetaData().getColumnLabel(i + 1);
                String labeNameLow = labelNames[index].toLowerCase();
                if ("lower".equals(colLabelUpperOrLower)) {
                    labelNames[index] = labelNames[index].toLowerCase();
                } else if ("upper".equals(colLabelUpperOrLower)) {
                    labelNames[index] = labelNames[index].toUpperCase();
                }
                labelIndexMap.put(labeNameLow, index);
                labelTypes[index] = rs.getMetaData().getColumnTypeName(i + 1);
                if (hasToStrCols && strTypeCols.contains(labeNameLow)) {
                    labelTypes[index] = "VARCHAR";
                }
                ++index;
            }
            result.setLabelNames(labelNames);
            result.setLabelTypes(labelTypes);
            try {
                result.setRows(ResultUtils.getResultSet(queryExecutorExtend, sqlToyConfig, sqlToyContext, conn, rs, updateRowHandler, realDecryptHandler, rowCnt, labelIndexMap, labelNames, startColIndex));
            }
            catch (Exception oie) {
                logger.error("sql={} \u63d0\u53d6\u7ed3\u679c\u53d1\u751f\u5f02\u5e38:{}!", (Object)sqlToyConfig.getId(), (Object)oie.getMessage());
                throw oie;
            }
        }
        if (result.getRows() != null) {
            result.setRecordCount(Long.valueOf(result.getRows().size()));
        }
        return result;
    }

    public static void consumeResult(SqlToyContext sqlToyContext, QueryExecutorExtend extend, SqlToyConfig sqlToyConfig, Connection conn, ResultSet rs, StreamResultHandler streamResultHandler, Class resultType, Boolean humpMapLabel, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        IgnoreCaseSet decryptColumns = sqlToyConfig.getDecryptColumns();
        DecryptHandler realDecryptHandler = null;
        if (decryptColumns != null && !decryptColumns.isEmpty()) {
            realDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), decryptColumns);
        }
        int columnSize = rs.getMetaData().getColumnCount();
        Set<String> strTypeCols = ResultUtils.getStringColumns(sqlToyConfig);
        boolean hasToStrCols = !strTypeCols.isEmpty();
        String[] labelNames = new String[columnSize];
        String[] labelTypes = new String[columnSize];
        String colLabelUpperOrLower = sqlToyContext.getColumnLabelUpperOrLower();
        int index = 0;
        for (int i = 0; i < columnSize; ++i) {
            labelNames[index] = rs.getMetaData().getColumnLabel(i + 1);
            String labeNameLow = labelNames[index].toLowerCase();
            if ("lower".equals(colLabelUpperOrLower)) {
                labelNames[index] = labelNames[index].toLowerCase();
            } else if ("upper".equals(colLabelUpperOrLower)) {
                labelNames[index] = labelNames[index].toUpperCase();
            }
            labelTypes[index] = rs.getMetaData().getColumnTypeName(i + 1);
            if (hasToStrCols && strTypeCols.contains(labeNameLow)) {
                labelTypes[index] = "VARCHAR";
            }
            ++index;
        }
        Boolean hasTranslate = !sqlToyConfig.getTranslateMap().isEmpty();
        HashMap<String, Translate> translateMap = sqlToyConfig.getTranslateMap();
        HashMap<String, HashMap<String, Object[]>> translateCache = null;
        if (hasTranslate.booleanValue()) {
            translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
            if (translateCache == null || translateCache.isEmpty()) {
                hasTranslate = false;
                logger.debug("\u901a\u8fc7\u7f13\u5b58\u914d\u7f6e\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u6570\u636e,\u8bf7\u6b63\u786e\u914d\u7f6eTranslateManager!");
            }
            if (hasTranslate.booleanValue()) {
                translateMap = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateMap);
            }
        }
        LabelIndexModel labelIndexModel = ResultUtils.wrapLabelIndexMap(labelNames);
        boolean ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
        List<SecureMask> secureMasks = sqlToyConfig.getSecureMasks();
        List<FormatModel> formatModels = sqlToyConfig.getFormatModels();
        boolean sqlSecure = !secureMasks.isEmpty();
        boolean sqlFormat = !formatModels.isEmpty();
        boolean extSecure = extend != null && !extend.secureMask.isEmpty();
        boolean extFormat = extend != null && !extend.colsFormat.isEmpty();
        DesensitizeProvider desensitizeProvider = sqlToyContext.getDesensitizeProvider();
        int type = 1;
        boolean isMap = false;
        boolean isConMap = false;
        HashMap<String, String> columnFieldMap = null;
        Method[] realMethods = null;
        String[] methodTypes = null;
        int[] methodTypeValues = null;
        Class[] genericTypes = null;
        String[] realProps = null;
        int[] indexs = null;
        HashMap<String, HashMap<String, Object[]>> cacheDatas = null;
        HashMap<String, Translate> translateConfig = null;
        String[] mapLabelNames = labelNames;
        if (resultType != null && resultType != ArrayList.class && resultType != Collection.class && resultType != List.class && !BeanUtil.isBaseDataType(resultType)) {
            if (resultType == Array.class) {
                type = 2;
            } else if (Map.class.isAssignableFrom(resultType)) {
                boolean isHumpLabel;
                type = 3;
                isMap = resultType.equals(Map.class);
                isConMap = resultType.equals(ConcurrentMap.class);
                boolean bl = isHumpLabel = humpMapLabel == null ? sqlToyContext.isHumpMapResultTypeLabel() : humpMapLabel.booleanValue();
                if (isHumpLabel) {
                    mapLabelNames = ResultUtils.humpFieldNames(labelNames, null);
                }
            } else {
                type = 4;
                if (Modifier.isAbstract(resultType.getModifiers()) || Modifier.isInterface(resultType.getModifiers())) {
                    throw new IllegalArgumentException("resultType:" + resultType.getName() + " \u662f\u62bd\u8c61\u7c7b\u6216\u63a5\u53e3,\u975e\u6cd5\u53c2\u6570!");
                }
                if (sqlToyContext.isEntity(resultType)) {
                    EntityMeta entityMeta = sqlToyContext.getEntityMeta(resultType);
                    columnFieldMap = entityMeta.getColumnFieldMap();
                }
                realProps = ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap);
                realMethods = BeanUtil.matchSetMethods(resultType, realProps);
                methodTypes = new String[columnSize];
                methodTypeValues = new int[columnSize];
                genericTypes = new Class[columnSize];
                indexs = new int[columnSize];
                for (int i = 0; i < columnSize; ++i) {
                    indexs[i] = i;
                    if (null == realMethods[i]) continue;
                    Class<?> methodType = realMethods[i].getParameterTypes()[0];
                    methodTypes[i] = methodType.getTypeName();
                    methodTypeValues[i] = DataType.getType(methodType);
                    Type[] types = realMethods[i].getGenericParameterTypes();
                    if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
                    genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
                }
                translateConfig = TranslateConfigParse.getClassTranslates(resultType);
                if (translateConfig != null && !translateConfig.isEmpty()) {
                    cacheDatas = sqlToyContext.getTranslateManager().getTranslates(translateConfig);
                }
            }
        }
        streamResultHandler.start(labelNames, labelTypes);
        index = 0;
        while (rs.next()) {
            List rowTemp = hasTranslate != false ? ResultUtils.processResultRowWithTranslate(translateMap, translateCache, labelNames, rs, columnSize, realDecryptHandler, ignoreAllEmpty) : ResultUtils.processResultRow(rs, labelNames, columnSize, realDecryptHandler, ignoreAllEmpty);
            if (rowTemp == null) continue;
            if (sqlSecure) {
                ResultUtils.secureMaskRow(desensitizeProvider, rowTemp, secureMasks.iterator(), labelIndexModel);
            }
            if (sqlFormat) {
                ResultUtils.formatRowColumn(rowTemp, formatModels.iterator(), labelIndexModel);
            }
            if (extSecure) {
                ResultUtils.secureMaskRow(desensitizeProvider, rowTemp, extend.secureMask.values().iterator(), labelIndexModel);
            }
            if (extFormat) {
                ResultUtils.formatRowColumn(rowTemp, extend.colsFormat.values().iterator(), labelIndexModel);
            }
            if (type == 1) {
                streamResultHandler.consume(rowTemp, index);
            } else if (type == 2) {
                Object[] rowAry = new Object[rowTemp.size()];
                rowTemp.toArray(rowAry);
                streamResultHandler.consume(rowAry, index);
            } else if (type == 3) {
                Map rowMap = isMap ? new HashMap() : (isConMap ? new ConcurrentHashMap() : (Map)resultType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                for (int j = 0; j < columnSize; ++j) {
                    rowMap.put(mapLabelNames[j], rowTemp.get(j));
                }
                streamResultHandler.consume(rowMap, index);
            } else {
                Object bean = BeanUtil.reflectRowToBean(sqlToyContext.getTypeHandler(), realMethods, methodTypeValues, methodTypes, genericTypes, rowTemp, indexs, realProps, resultType);
                if (cacheDatas != null) {
                    translateConfig = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateConfig);
                    ResultUtils.wrapBeanTranslate(sqlToyContext, cacheDatas, translateConfig, bean);
                }
                streamResultHandler.consume(bean, index);
            }
            ++index;
        }
        streamResultHandler.end();
        SqlExecuteStat.debug("\u64cd\u4f5c\u63d0\u793a", "\u6d41\u5f0f\u67e5\u8be2\u7d2f\u8ba1\u83b7\u53d6:{} \u6761\u8bb0\u5f55!", index);
    }

    private static void secureMask(DesensitizeProvider desensitizeProvider, List<List> rows, Iterator<SecureMask> masks, LabelIndexModel labelIndexMap) {
        while (masks.hasNext()) {
            SecureMask mask = masks.next();
            Integer index = labelIndexMap.get(mask.getColumn());
            if (index == null) continue;
            int columnIndex = index;
            for (List row : rows) {
                Object value = row.get(columnIndex);
                if (value == null) continue;
                row.set(columnIndex, desensitizeProvider.desensitize(value.toString(), mask));
            }
        }
    }

    private static void secureMaskRow(DesensitizeProvider desensitizeProvider, List row, Iterator<SecureMask> masks, LabelIndexModel labelIndexMap) {
        while (masks.hasNext()) {
            int columnIndex;
            Object value;
            SecureMask mask = masks.next();
            Integer index = labelIndexMap.get(mask.getColumn());
            if (index == null || (value = row.get(columnIndex = index.intValue())) == null) continue;
            row.set(columnIndex, desensitizeProvider.desensitize(value.toString(), mask));
        }
    }

    private static void formatColumn(List<List> rows, Iterator<FormatModel> formats, LabelIndexModel labelIndexMap) {
        while (formats.hasNext()) {
            FormatModel fmt = formats.next();
            Integer index = labelIndexMap.get(fmt.getColumn());
            if (index == null && NumberUtil.isInteger(fmt.getColumn())) {
                index = Integer.parseInt(fmt.getColumn());
            }
            if (index == null) continue;
            int columnIndex = index;
            for (List row : rows) {
                Object value = row.get(columnIndex);
                if (value == null) continue;
                if (fmt.getType() == 1) {
                    row.set(columnIndex, DateUtil.formatDate(value, fmt.getFormat(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
                    continue;
                }
                row.set(columnIndex, NumberUtil.format(value, fmt.getFormat(), fmt.getRoundingMode(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
            }
        }
    }

    private static void formatRowColumn(List row, Iterator<FormatModel> formats, LabelIndexModel labelIndexMap) {
        while (formats.hasNext()) {
            int columnIndex;
            Object value;
            FormatModel fmt = formats.next();
            Integer index = labelIndexMap.get(fmt.getColumn());
            if (index == null && NumberUtil.isInteger(fmt.getColumn())) {
                index = Integer.parseInt(fmt.getColumn());
            }
            if (index == null || (value = row.get(columnIndex = index.intValue())) == null) continue;
            if (fmt.getType() == 1) {
                row.set(columnIndex, DateUtil.formatDate(value, fmt.getFormat(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
                continue;
            }
            row.set(columnIndex, NumberUtil.format(value, fmt.getFormat(), fmt.getRoundingMode(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
        }
    }

    private static List getResultSet(QueryExecutorExtend queryExtend, SqlToyConfig sqlToyConfig, SqlToyContext sqlToyContext, Connection conn, ResultSet rs, UpdateRowHandler updateRowHandler, DecryptHandler decryptHandler, int rowCnt, HashMap<String, Integer> labelIndexMap, String[] labelNames, int startColIndex) throws Exception {
        LinkModel linkModel = sqlToyConfig.getLinkModel();
        if (queryExtend != null && queryExtend.linkModel != null) {
            linkModel = queryExtend.linkModel;
        }
        if (linkModel != null && linkModel.getColumns().length > 1) {
            return ResultUtils.getMoreLinkResultSet(sqlToyConfig, sqlToyContext, decryptHandler, conn, rs, rowCnt, labelIndexMap, labelNames, startColIndex);
        }
        ArrayList<List> items = new ArrayList<List>();
        Boolean hasTranslate = !sqlToyConfig.getTranslateMap().isEmpty();
        HashMap<String, Translate> translateMap = sqlToyConfig.getTranslateMap();
        HashMap<String, HashMap<String, Object[]>> translateCache = null;
        if (hasTranslate.booleanValue()) {
            translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
            if (translateCache == null || translateCache.isEmpty()) {
                hasTranslate = false;
                logger.debug("\u901a\u8fc7\u7f13\u5b58\u914d\u7f6e\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u6570\u636e,\u8bf7\u6b63\u786e\u914d\u7f6eTranslateManager!");
            }
            if (hasTranslate.booleanValue()) {
                translateMap = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateMap);
            }
        }
        int columnSize = labelNames.length;
        int index = 0;
        int warnThresholds = SqlToyConstants.getWarnThresholds();
        boolean warnLimit = false;
        long maxThresholds = SqlToyConstants.getMaxThresholds();
        boolean maxLimit = false;
        boolean ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
        if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
            maxThresholds = warnThresholds;
        }
        if (linkModel != null) {
            String identity = null;
            String linkColumn = linkModel.getColumns()[0];
            String linkColumnLow = linkColumn.toLowerCase();
            if (!labelIndexMap.containsKey(linkColumnLow)) {
                throw new DataAccessException("\u505alink\u64cd\u4f5c\u65f6,\u67e5\u8be2\u7ed3\u679c\u5b57\u6bb5\u4e2d\u6ca1\u6709\u5b57\u6bb5:" + linkColumn + ",\u8bf7\u68c0\u67e5sql\u6216link \u914d\u7f6e\u7684\u6b63\u786e\u6027!");
            }
            HashSet<Object> linkSet = new HashSet<Object>();
            int linkIndex = labelIndexMap.get(linkColumnLow);
            StringBuilder linkBuffer = new StringBuilder();
            boolean hasDecorate = linkModel.getDecorateAppendChar() != null;
            boolean isLeft = true;
            if (hasDecorate) {
                isLeft = "left".equals(linkModel.getDecorateAlign());
            }
            String preIdentity = null;
            boolean translateLink = hasTranslate != false ? translateMap.containsKey(linkColumnLow) : false;
            HashMap<String, Object[]> linkTranslateMap = null;
            int linkTranslateIndex = 1;
            TranslateExtend extend = null;
            if (translateLink) {
                extend = translateMap.get(linkColumnLow).getExtend();
                linkTranslateIndex = extend.index;
                linkTranslateMap = translateCache.get(extend.column);
            }
            boolean isLastProcess = false;
            boolean doLink = true;
            while (rs.next()) {
                Object linkStr;
                isLastProcess = false;
                Object linkValue = rs.getObject(linkColumn);
                if (linkValue == null) {
                    linkStr = "";
                } else if (translateLink) {
                    Object[] cacheValues = linkTranslateMap.get(linkValue.toString());
                    if (cacheValues == null) {
                        linkStr = "[" + linkValue + "]\u672a\u5339\u914d";
                        logger.debug("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{} \u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{extend.cache, extend.cacheType, linkValue});
                    } else {
                        linkStr = cacheValues[linkTranslateIndex] == null ? "" : cacheValues[linkTranslateIndex].toString();
                    }
                } else {
                    linkStr = linkValue.toString();
                }
                String string = identity = linkModel.getGroupColumns() == null ? "default" : ResultUtils.getLinkColumnsId(rs, linkModel.getGroupColumns());
                if (!identity.equals(preIdentity)) {
                    if (index != 0) {
                        ((List)items.get(items.size() - 1)).set(linkIndex, linkBuffer.toString());
                        linkBuffer.delete(0, linkBuffer.length());
                        linkSet.clear();
                    }
                    linkBuffer.append((String)linkStr);
                    linkSet.add(linkStr);
                    List rowTemp = hasTranslate != false ? ResultUtils.processResultRowWithTranslate(translateMap, translateCache, labelNames, rs, columnSize, decryptHandler, ignoreAllEmpty) : ResultUtils.processResultRow(rs, labelNames, columnSize, decryptHandler, ignoreAllEmpty);
                    if (rowTemp != null) {
                        items.add(rowTemp);
                    }
                    preIdentity = identity;
                } else {
                    isLastProcess = true;
                    doLink = true;
                    if (linkModel.isDistinct() && linkSet.contains(linkStr)) {
                        doLink = false;
                    }
                    linkSet.add(linkStr);
                    if (doLink) {
                        if (linkBuffer.length() > 0) {
                            linkBuffer.append(linkModel.getSign());
                        }
                        linkBuffer.append((String)(hasDecorate ? StringUtil.appendStr((String)linkStr, linkModel.getDecorateAppendChar(), linkModel.getDecorateSize(), isLeft) : linkStr));
                    }
                }
                if (++index == warnThresholds) {
                    warnLimit = true;
                }
                if ((long)index != maxThresholds) continue;
                maxLimit = true;
                break;
            }
            if (isLastProcess) {
                ((List)items.get(items.size() - 1)).set(linkIndex, linkBuffer.toString());
            }
        } else {
            boolean isUpdate = false;
            if (updateRowHandler != null) {
                isUpdate = true;
            }
            if (hasTranslate.booleanValue()) {
                while (rs.next()) {
                    List rowTemp;
                    if (isUpdate) {
                        updateRowHandler.updateRow(rs, index);
                        rs.updateRow();
                    }
                    if ((rowTemp = ResultUtils.processResultRowWithTranslate(translateMap, translateCache, labelNames, rs, columnSize, decryptHandler, ignoreAllEmpty)) != null) {
                        items.add(rowTemp);
                    }
                    if (++index == warnThresholds) {
                        warnLimit = true;
                    }
                    if ((long)index != maxThresholds) continue;
                    maxLimit = true;
                    break;
                }
            } else {
                while (rs.next()) {
                    List rowTemp;
                    if (isUpdate) {
                        updateRowHandler.updateRow(rs, index);
                        rs.updateRow();
                    }
                    if ((rowTemp = ResultUtils.processResultRow(rs, labelNames, columnSize, decryptHandler, ignoreAllEmpty)) != null) {
                        items.add(rowTemp);
                    }
                    if (++index == warnThresholds) {
                        warnLimit = true;
                    }
                    if ((long)index != maxThresholds) continue;
                    maxLimit = true;
                    break;
                }
            }
        }
        if (warnLimit) {
            ResultUtils.warnLog(sqlToyConfig, index);
        }
        if (maxLimit) {
            logger.error("MaxLargeResult:\u6267\u884csql\u63d0\u53d6\u6570\u636e\u8d85\u51fa\u6700\u5927\u9600\u503c\u9650\u5236{}(\u53ef\u901a\u8fc7[spring.sqltoy.pageFetchSizeLimit]\u53c2\u6570\u8c03\u6574),sqlId={},\u5177\u4f53\u8bed\u53e5={}", new Object[]{index, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
        }
        return items;
    }

    private static Object getLinkColumnsId(ResultSet rs, String[] columns) throws Exception {
        if (columns.length == 1) {
            return rs.getObject(columns[0]);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String column : columns) {
            Object colValue;
            if (index > 0) {
                result.append("_");
            }
            result.append((colValue = rs.getObject(column)) == null ? "null" : colValue.toString());
            ++index;
        }
        return result.toString();
    }

    private static List getMoreLinkResultSet(SqlToyConfig sqlToyConfig, SqlToyContext sqlToyContext, DecryptHandler decryptHandler, Connection conn, ResultSet rs, int rowCnt, HashMap<String, Integer> labelIndexMap, String[] labelNames, int startColIndex) throws Exception {
        List rowTemp;
        int i;
        LinkModel linkModel = sqlToyConfig.getLinkModel();
        ArrayList<List> items = new ArrayList<List>();
        Boolean hasTranslate = !sqlToyConfig.getTranslateMap().isEmpty();
        HashMap<String, Translate> translateMap = sqlToyConfig.getTranslateMap();
        HashMap<String, HashMap<String, Object[]>> translateCache = null;
        if (hasTranslate.booleanValue()) {
            translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
            if (translateCache == null || translateCache.isEmpty()) {
                hasTranslate = false;
                logger.debug("\u901a\u8fc7\u7f13\u5b58\u914d\u7f6e\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u6570\u636e,\u8bf7\u6b63\u786e\u914d\u7f6eTranslateManager!");
            }
            if (hasTranslate.booleanValue()) {
                translateMap = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateMap);
            }
        }
        int columnSize = labelNames.length;
        int index = 0;
        int warnThresholds = SqlToyConstants.getWarnThresholds();
        boolean warnLimit = false;
        long maxThresholds = SqlToyConstants.getMaxThresholds();
        boolean maxLimit = false;
        boolean ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
        if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
            maxThresholds = warnThresholds;
        }
        int linkCols = linkModel.getColumns().length;
        String[] linkColumns = linkModel.getColumns();
        int[] linkIndexs = new int[linkCols];
        StringBuilder[] linkBuffers = new StringBuilder[linkCols];
        HashSet[] linkSets = linkModel.isDistinct() ? new HashSet[linkCols] : null;
        boolean[] translateLinks = new boolean[linkCols];
        TranslateExtend[] transExtends = new TranslateExtend[linkCols];
        for (int i2 = 0; i2 < linkCols; ++i2) {
            linkBuffers[i2] = new StringBuilder();
            String linkColumnLow = linkColumns[i2].toLowerCase();
            if (!labelIndexMap.containsKey(linkColumnLow)) {
                throw new DataAccessException("\u505alink\u64cd\u4f5c\u65f6,\u67e5\u8be2\u7ed3\u679c\u5b57\u6bb5\u4e2d\u6ca1\u6709\u5b57\u6bb5:" + linkColumnLow + ",\u8bf7\u68c0\u67e5sql\u6216link \u914d\u7f6e\u7684\u6b63\u786e\u6027!");
            }
            linkIndexs[i2] = labelIndexMap.get(linkColumnLow);
            if (hasTranslate.booleanValue()) {
                translateLinks[i2] = translateMap.containsKey(linkColumnLow);
                if (translateLinks[i2]) {
                    transExtends[i2] = translateMap.get(linkColumnLow).getExtend();
                }
            }
            if (!linkModel.isDistinct()) continue;
            linkSets[i2] = new HashSet();
        }
        boolean hasDecorate = linkModel.getDecorateAppendChar() != null;
        boolean isLeft = true;
        if (hasDecorate) {
            isLeft = "left".equals(linkModel.getDecorateAlign());
        }
        String preIdentity = null;
        Object[] linkValues = new Object[linkCols];
        String[] linkStrs = new String[linkCols];
        TranslateExtend extend = null;
        String identity = null;
        boolean isLastProcess = false;
        boolean doLink = false;
        while (rs.next()) {
            isLastProcess = false;
            for (i = 0; i < linkCols; ++i) {
                linkValues[i] = rs.getObject(linkColumns[i]);
                if (linkValues[i] == null) {
                    linkStrs[i] = "";
                    continue;
                }
                if (translateLinks[i]) {
                    extend = transExtends[i];
                    Object[] cacheValues = translateCache.get(extend.column).get(linkValues[i].toString());
                    if (cacheValues == null) {
                        linkStrs[i] = "[" + linkValues[i] + "]\u672a\u5339\u914d";
                        logger.debug("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{} \u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{extend.cache, extend.cacheType, linkValues[i]});
                        continue;
                    }
                    linkStrs[i] = cacheValues[extend.index] == null ? "" : cacheValues[extend.index].toString();
                    continue;
                }
                linkStrs[i] = linkValues[i].toString();
            }
            String string = identity = linkModel.getGroupColumns() == null ? "default" : ResultUtils.getLinkColumnsId(rs, linkModel.getGroupColumns());
            if (!identity.equals(preIdentity)) {
                if (index != 0) {
                    rowTemp = (List)items.get(items.size() - 1);
                    for (i = 0; i < linkCols; ++i) {
                        rowTemp.set(linkIndexs[i], linkBuffers[i].toString());
                        linkBuffers[i].delete(0, linkBuffers[i].length());
                        if (!linkModel.isDistinct()) continue;
                        linkSets[i].clear();
                    }
                }
                for (i = 0; i < linkCols; ++i) {
                    linkBuffers[i].append(linkStrs[i]);
                    if (!linkModel.isDistinct()) continue;
                    linkSets[i].add(linkStrs[i]);
                }
                rowTemp = hasTranslate != false ? ResultUtils.processResultRowWithTranslate(translateMap, translateCache, labelNames, rs, columnSize, decryptHandler, ignoreAllEmpty) : ResultUtils.processResultRow(rs, labelNames, columnSize, decryptHandler, ignoreAllEmpty);
                if (rowTemp != null) {
                    items.add(rowTemp);
                }
                preIdentity = identity;
            } else {
                isLastProcess = true;
                for (i = 0; i < linkCols; ++i) {
                    doLink = true;
                    if (linkModel.isDistinct()) {
                        if (linkSets[i].contains(linkStrs[i])) {
                            doLink = false;
                        }
                        linkSets[i].add(linkStrs[i]);
                    }
                    if (!doLink) continue;
                    if (linkBuffers[i].length() > 0) {
                        linkBuffers[i].append(linkModel.getSign());
                    }
                    linkBuffers[i].append(hasDecorate ? StringUtil.appendStr(linkStrs[i], linkModel.getDecorateAppendChar(), linkModel.getDecorateSize(), isLeft) : linkStrs[i]);
                }
            }
            if (++index == warnThresholds) {
                warnLimit = true;
            }
            if ((long)index != maxThresholds) continue;
            maxLimit = true;
            break;
        }
        if (isLastProcess) {
            rowTemp = (List)items.get(items.size() - 1);
            for (i = 0; i < linkCols; ++i) {
                rowTemp.set(linkIndexs[i], linkBuffers[i].toString());
            }
        }
        if (warnLimit) {
            ResultUtils.warnLog(sqlToyConfig, index);
        }
        if (maxLimit) {
            logger.error("MaxLargeResult:\u6267\u884csql\u63d0\u53d6\u6570\u636e\u8d85\u51fa\u6700\u5927\u9600\u503c\u9650\u5236{}(\u53ef\u901a\u8fc7[spring.sqltoy.pageFetchSizeLimit]\u53c2\u6570\u8c03\u6574),sqlId={},\u5177\u4f53\u8bed\u53e5={}", new Object[]{index, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
        }
        return items;
    }

    private static List pivotResult(PivotModel pivotModel, LabelIndexModel labelIndexMap, List result, List pivotCategorySet) {
        if (result == null || result.isEmpty()) {
            return result;
        }
        if (pivotModel.getGroupCols() == null || pivotModel.getCategoryCols().length == 0) {
            return CollectionUtil.convertColToRow(result, null);
        }
        Integer[] categoryCols = ResultUtils.mappingLabelIndex(pivotModel.getCategoryCols(), labelIndexMap);
        Integer[] pivotCols = ResultUtils.mappingLabelIndex(pivotModel.getStartEndCols(), labelIndexMap);
        Integer[] groupCols = ResultUtils.mappingLabelIndex(pivotModel.getGroupCols(), labelIndexMap);
        List categoryList = pivotCategorySet == null ? ResultUtils.extractCategory(result, categoryCols) : pivotCategorySet;
        return CollectionUtil.pivotList(result, categoryList, null, groupCols, categoryCols, (int)pivotCols[0], (int)pivotCols[pivotCols.length - 1], pivotModel.getDefaultValue());
    }

    private static Integer[] mappingLabelIndex(String[] columnLabels, LabelIndexModel labelIndexMap) {
        Integer[] result = new Integer[columnLabels.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = NumberUtil.isInteger(columnLabels[i]) ? Integer.valueOf(Integer.parseInt(columnLabels[i])) : labelIndexMap.get(columnLabels[i].toLowerCase());
        }
        return result;
    }

    private static List extractCategory(List items, Integer[] categoryCols) {
        int i;
        List<List> categoryList = new ArrayList<List>();
        HashMap<String, String> identityMap = new HashMap<String, String>();
        int categorySize = categoryCols.length;
        int size = items.size();
        for (i = 0; i < size; ++i) {
            List row = (List)items.get(i);
            String tmpStr = "";
            ArrayList categoryRow = new ArrayList();
            for (int j = 0; j < categorySize; ++j) {
                Object obj = row.get(categoryCols[j]);
                categoryRow.add(obj);
                tmpStr = tmpStr.concat(obj == null ? "null" : obj.toString());
            }
            if (identityMap.containsKey(tmpStr)) continue;
            categoryList.add(categoryRow);
            identityMap.put(tmpStr, "");
        }
        if (categoryCols.length > 1) {
            categoryList = ResultUtils.sortList(categoryList, 0, 0, categoryList.size() - 1, true);
            for (i = 1; i < categoryCols.length; ++i) {
                categoryList = ResultUtils.sortGroupList(categoryList, i - 1, i, true);
            }
        }
        return CollectionUtil.convertColToRow(categoryList, null);
    }

    private static List sortGroupList(List<List> sortList, int groupCol, int orderCol, boolean ascend) {
        int length = sortList.size();
        int start = 0;
        Object compareValue = null;
        for (int i = 0; i < length; ++i) {
            Object tempObj = sortList.get(i).get(groupCol);
            if (!tempObj.equals(compareValue)) {
                int end = i - 1;
                ResultUtils.sortList(sortList, orderCol, start, end, ascend);
                start = i;
                compareValue = tempObj;
            }
            if (i != length - 1) continue;
            ResultUtils.sortList(sortList, orderCol, start, i, ascend);
        }
        return sortList;
    }

    private static List sortList(List<List> sortList, int orderCol, int start, int end, boolean ascend) {
        if (end <= start) {
            return sortList;
        }
        boolean lessThen = false;
        for (int i = start; i < end; ++i) {
            for (int j = i + 1; j < end + 1; ++j) {
                Object iData = sortList.get(i).get(orderCol);
                Object jData = sortList.get(j).get(orderCol);
                if (iData == null && jData == null || iData != null && jData == null) {
                    lessThen = false;
                } else if (iData == null && jData != null) {
                    lessThen = true;
                } else {
                    boolean bl = lessThen = iData.toString().compareTo(jData.toString()) < 0;
                }
                if ((!ascend || lessThen) && (ascend || !lessThen)) continue;
                List tempList = sortList.get(i);
                sortList.set(i, sortList.get(j));
                sortList.set(j, tempList);
            }
        }
        return sortList;
    }

    public static List processResultRow(ResultSet rs, int startColIndex, int rowCnt, boolean ignoreAllEmptySet) throws Exception {
        ArrayList<Object> rowData = new ArrayList<Object>();
        boolean allNull = true;
        for (int i = startColIndex; i < rowCnt; ++i) {
            Object fieldValue = rs.getObject(i + 1);
            if (null != fieldValue) {
                if (fieldValue instanceof Clob) {
                    fieldValue = SqlUtil.clobToString((Clob)fieldValue);
                } else if (fieldValue instanceof Blob) {
                    Blob blob = (Blob)fieldValue;
                    fieldValue = blob.getBytes(1L, (int)blob.length());
                }
                allNull = false;
            }
            rowData.add(fieldValue);
        }
        if (allNull && ignoreAllEmptySet) {
            return null;
        }
        return rowData;
    }

    public static List processResultRow(ResultSet rs, String[] labelNames, int size, DecryptHandler decryptHandler, boolean ignoreAllEmptySet) throws Exception {
        ArrayList<Object> rowData = new ArrayList<Object>();
        boolean allNull = true;
        for (int i = 0; i < size; ++i) {
            String label = labelNames[i];
            Object fieldValue = rs.getObject(label);
            if (null != fieldValue) {
                if (fieldValue instanceof Clob) {
                    fieldValue = SqlUtil.clobToString((Clob)fieldValue);
                } else if (fieldValue instanceof Blob) {
                    Blob blob = (Blob)fieldValue;
                    fieldValue = blob.getBytes(1L, (int)blob.length());
                }
                if (decryptHandler != null) {
                    fieldValue = decryptHandler.decrypt(label, fieldValue);
                }
                allNull = false;
            }
            rowData.add(fieldValue);
        }
        if (allNull && ignoreAllEmptySet) {
            return null;
        }
        return rowData;
    }

    private static List processResultRowWithTranslate(HashMap<String, Translate> translateMap, HashMap<String, HashMap<String, Object[]>> translateCaches, String[] labelNames, ResultSet rs, int size, DecryptHandler decryptHandler, boolean ignoreAllEmptySet) throws Exception {
        ArrayList<Object> rowData = new ArrayList<Object>();
        boolean allNull = true;
        for (int i = 0; i < size; ++i) {
            String label = labelNames[i];
            Object fieldValue = rs.getObject(label);
            label = label.toLowerCase();
            String keyIndex = Integer.toString(i);
            if (null != fieldValue) {
                allNull = false;
                if (fieldValue instanceof Clob) {
                    fieldValue = SqlUtil.clobToString((Clob)fieldValue);
                } else if (fieldValue instanceof Blob) {
                    Blob blob = (Blob)fieldValue;
                    fieldValue = blob.getBytes(1L, (int)blob.length());
                }
                if (decryptHandler != null) {
                    fieldValue = decryptHandler.decrypt(label, fieldValue);
                }
                if (translateMap.containsKey(label) || translateMap.containsKey(keyIndex)) {
                    TranslateExtend extend = translateMap.get(label).getExtend();
                    if (extend == null) {
                        extend = translateMap.get(keyIndex).getExtend();
                    }
                    fieldValue = ResultUtils.translateKey(extend, translateCaches.get(extend.column), fieldValue);
                }
            }
            rowData.add(fieldValue);
        }
        if (allNull && ignoreAllEmptySet) {
            return null;
        }
        return rowData;
    }

    private static Object translateKey(TranslateExtend extend, HashMap<String, Object[]> translateKeyMap, Object fieldValue) {
        String fieldStr = fieldValue.toString();
        if (extend.splitRegex == null) {
            Object[] cacheValues;
            if (extend.keyTemplate != null) {
                fieldStr = extend.keyTemplate.replace("{}", fieldStr);
            }
            if ((cacheValues = translateKeyMap.get(fieldStr)) == null || cacheValues.length == 0) {
                if (extend.uncached != null) {
                    fieldValue = extend.uncached.replace("${value}", fieldStr);
                } else {
                    fieldValue = fieldValue.toString();
                    logger.warn("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{}\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{extend.cache, extend.cacheType, fieldValue});
                }
            } else {
                fieldValue = cacheValues[extend.index];
            }
            return fieldValue;
        }
        String[] keys = null;
        String splitReg = extend.splitRegex.trim();
        keys = ",".equals(splitReg) ? fieldStr.split("\\,") : (";".equals(splitReg) ? fieldStr.split("\\;") : (":".equals(splitReg) ? fieldStr.split("\\:") : ("".equals(splitReg) ? fieldStr.split("\\s+") : fieldStr.split(extend.splitRegex))));
        String linkSign = extend.linkSign;
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String key : keys) {
            Object[] cacheValues;
            if (index > 0) {
                result.append(linkSign);
            }
            if ((cacheValues = translateKeyMap.get(key.trim())) == null || cacheValues.length == 0) {
                if (extend.uncached != null) {
                    result.append(extend.uncached.replace("${value}", key));
                } else {
                    result.append(key);
                    logger.warn("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{}\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{extend.cache, extend.cacheType, key});
                }
            } else {
                result.append(cacheValues[extend.index]);
            }
            ++index;
        }
        return result.toString();
    }

    public static List getPivotCategory(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, Connection conn, Integer dbType, String dialect) throws Exception {
        ArrayList resultProcessors = new ArrayList();
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (!sqlToyConfig.getResultProcessor().isEmpty()) {
            resultProcessors.addAll(sqlToyConfig.getResultProcessor());
        }
        if (extend != null && !extend.calculators.isEmpty()) {
            resultProcessors.addAll(extend.calculators);
        }
        for (int i = 0; i < resultProcessors.size(); ++i) {
            PivotModel pivotModel;
            Object processor = resultProcessors.get(i);
            if (!(processor instanceof PivotModel) || (pivotModel = (PivotModel)processor).getCategorySql() == null) continue;
            SqlToyConfig pivotSqlConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyContext.getSqlToyConfig(pivotModel.getCategorySql(), SqlType.search, "", null), queryExecutor, dialect, false);
            SqlToyResult pivotSqlToyResult = SqlConfigParseUtils.processSql(pivotSqlConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, pivotSqlConfig), dialect);
            pivotSqlToyResult = DialectUtils.doInterceptors(sqlToyContext, pivotSqlConfig, OperateType.search, pivotSqlToyResult, null, dbType);
            List pivotCategory = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), pivotSqlToyResult.getSql(), pivotSqlToyResult.getParamsValue(), null, null, null, conn, dbType, sqlToyConfig.isIgnoreEmpty(), null, SqlToyConstants.FETCH_SIZE, -1);
            return CollectionUtil.convertColToRow(pivotCategory, null);
        }
        return null;
    }

    public static boolean calculate(DesensitizeProvider desensitizeProvider, SqlToyConfig sqlToyConfig, DataSetResult dataSetResult, List pivotCategorySet, QueryExecutorExtend extend) {
        List items = dataSetResult.getRows();
        if (items == null || items.isEmpty()) {
            return false;
        }
        boolean changedCols = false;
        List<SecureMask> secureMasks = sqlToyConfig.getSecureMasks();
        List<FormatModel> formatModels = sqlToyConfig.getFormatModels();
        ArrayList resultProcessors = new ArrayList();
        if (!sqlToyConfig.getResultProcessor().isEmpty()) {
            resultProcessors.addAll(sqlToyConfig.getResultProcessor());
        }
        if (extend != null && !extend.calculators.isEmpty()) {
            resultProcessors.addAll(extend.calculators);
        }
        LabelIndexModel labelIndexMap = null;
        if (!(secureMasks.isEmpty() && formatModels.isEmpty() && (extend == null || extend.secureMask.isEmpty() && extend.colsFormat.isEmpty()) && resultProcessors.isEmpty())) {
            labelIndexMap = ResultUtils.wrapLabelIndexMap(dataSetResult.getLabelNames());
        }
        if (!secureMasks.isEmpty()) {
            ResultUtils.secureMask(desensitizeProvider, items, secureMasks.iterator(), labelIndexMap);
        }
        if (!formatModels.isEmpty()) {
            ResultUtils.formatColumn(items, formatModels.iterator(), labelIndexMap);
        }
        if (extend != null) {
            if (!extend.secureMask.isEmpty()) {
                ResultUtils.secureMask(desensitizeProvider, items, extend.secureMask.values().iterator(), labelIndexMap);
            }
            if (!extend.colsFormat.isEmpty()) {
                ResultUtils.formatColumn(items, extend.colsFormat.values().iterator(), labelIndexMap);
            }
        }
        if (!resultProcessors.isEmpty()) {
            for (int i = 0; i < resultProcessors.size(); ++i) {
                Object processor = resultProcessors.get(i);
                if (processor instanceof PivotModel) {
                    items = ResultUtils.pivotResult((PivotModel)processor, labelIndexMap, items, pivotCategorySet);
                    changedCols = true;
                    continue;
                }
                if (processor instanceof UnpivotModel) {
                    items = UnpivotList.process((UnpivotModel)processor, dataSetResult, labelIndexMap, items);
                    continue;
                }
                if (processor instanceof SummaryModel) {
                    GroupSummary.process((SummaryModel)processor, labelIndexMap, items);
                    continue;
                }
                if (processor instanceof ColsChainRelativeModel) {
                    ColsChainRelative.process((ColsChainRelativeModel)processor, labelIndexMap, items);
                    changedCols = true;
                    continue;
                }
                if (processor instanceof RowsChainRelativeModel) {
                    RowsChainRelative.process((RowsChainRelativeModel)processor, labelIndexMap, items);
                    continue;
                }
                if (processor instanceof ReverseModel) {
                    ReverseList.process((ReverseModel)processor, labelIndexMap, items);
                    continue;
                }
                if (!(processor instanceof TreeSortModel)) continue;
                TreeDataSort.process((TreeSortModel)processor, labelIndexMap, items);
            }
            dataSetResult.setRows(items);
        }
        return changedCols;
    }

    private static LabelIndexModel wrapLabelIndexMap(String[] fields) {
        LabelIndexModel result = new LabelIndexModel();
        if (fields != null && fields.length > 0) {
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                String realLabelName = fields[i].toLowerCase();
                int index = realLabelName.indexOf(":");
                if (index != -1) {
                    realLabelName = realLabelName.substring(index + 1).trim();
                }
                result.put(realLabelName, i);
            }
        }
        return result;
    }

    public static List wrapQueryResult(SqlToyContext sqlToyContext, List queryResultRows, String[] labelNames, Class resultType, boolean changedCols, Boolean humpMapLabel, boolean hiberarchy, Class[] hiberarchyClasses, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        if (queryResultRows == null || queryResultRows.isEmpty() || resultType == null || resultType.equals(List.class) || resultType.equals(ArrayList.class) || resultType.equals(Collection.class) || BeanUtil.isBaseDataType(resultType)) {
            if (resultType != null && labelNames.length == 1 && BeanUtil.isBaseDataType(resultType)) {
                return ResultUtils.getFirstColumn(queryResultRows, resultType);
            }
            return queryResultRows;
        }
        if (Array.class.equals((Object)resultType)) {
            return CollectionUtil.innerListToArray(queryResultRows);
        }
        if (changedCols) {
            logger.warn("\u67e5\u8be2\u4e2d\u5b58\u5728\u7c7b\u4f3cpivot\u3001\u5217\u540c\u6bd4\u73af\u6bd4\u8ba1\u7b97\u5bfc\u81f4\u7ed3\u679c'\u5217'\u6570\u4e0d\u56fa\u5b9a\uff0c\u56e0\u6b64\u4e0d\u652f\u6301\u8f6cmap\u6216VO\u5bf9\u8c61!");
            SqlExecuteStat.debug("\u6620\u5c04\u7ed3\u679c\u7c7b\u578b\u9519\u8bef", "\u67e5\u8be2\u4e2d\u5b58\u5728\u7c7b\u4f3cpivot\u3001\u5217\u540c\u6bd4\u73af\u6bd4\u8ba1\u7b97\u5bfc\u81f4\u7ed3\u679c'\u5217'\u6570\u4e0d\u56fa\u5b9a\uff0c\u56e0\u6b64\u4e0d\u652f\u6301\u8f6cmap\u6216VO\u5bf9\u8c61!", new Object[0]);
        }
        if (Map.class.isAssignableFrom(resultType)) {
            boolean isHumpLabel;
            int width = labelNames.length;
            String[] realLabel = labelNames;
            boolean bl = isHumpLabel = humpMapLabel == null ? sqlToyContext.isHumpMapResultTypeLabel() : humpMapLabel.booleanValue();
            if (isHumpLabel) {
                realLabel = ResultUtils.humpFieldNames(labelNames, null);
            }
            ArrayList result = new ArrayList();
            boolean isMap = resultType.equals(Map.class);
            boolean isConMap = resultType.equals(ConcurrentMap.class);
            int n = queryResultRows.size();
            for (int i = 0; i < n; ++i) {
                List rowList = (List)queryResultRows.get(i);
                Map rowMap = isMap ? new HashMap() : (isConMap ? new ConcurrentHashMap() : (Map)resultType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                for (int j = 0; j < width; ++j) {
                    rowMap.put(realLabel[j], rowList.get(j));
                }
                result.add(rowMap);
            }
            return result;
        }
        HashMap<String, String> columnFieldMap = null;
        EntityMeta entityMeta = null;
        if (sqlToyContext.isEntity(resultType)) {
            entityMeta = sqlToyContext.getEntityMeta(resultType);
            columnFieldMap = entityMeta.getColumnFieldMap();
        }
        boolean hasCascade = false;
        List<TableCascadeModel> cascadeModel = null;
        if (hiberarchy && (cascadeModel = entityMeta != null ? entityMeta.getCascadeModels() : BeanUtil.getCascadeModels(resultType)) != null && !cascadeModel.isEmpty()) {
            hasCascade = true;
        }
        List result = null;
        if (!hasCascade) {
            result = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), queryResultRows, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap), resultType);
            ResultUtils.wrapResultTranslate(sqlToyContext, result, resultType);
        } else {
            result = ResultUtils.hiberarchySet(sqlToyContext, entityMeta, columnFieldMap, queryResultRows, labelNames, resultType, cascadeModel, hiberarchyClasses, fieldsMap);
        }
        return result;
    }

    public static <T> List<T> getFirstColumn(List rows, Class<T> classType) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (rows == null || rows.isEmpty()) {
            return result;
        }
        String typeName = classType.getTypeName();
        int typeValue = DataType.getType(classType);
        try {
            for (Object row : rows) {
                Object cell = ((List)row).get(0);
                result.add(BeanUtil.convertType(cell, typeValue, typeName));
            }
            return result;
        }
        catch (Exception e) {
            throw new DataAccessException("\u5207\u53d6\u5355\u5217\u67e5\u8be2\u7ed3\u679c\u8fdb\u884c\u7c7b\u578b\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38!" + e.getMessage());
        }
    }

    private static String[] convertRealProps(String[] labelNames, HashMap<String, String> colFieldMap) {
        String[] result = (String[])labelNames.clone();
        if (colFieldMap != null && !colFieldMap.isEmpty()) {
            for (int i = 0; i < result.length; ++i) {
                String key = result[i].toLowerCase();
                if (!colFieldMap.containsKey(key)) continue;
                result[i] = colFieldMap.get(key);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static List hiberarchySet(SqlToyContext sqlToyContext, EntityMeta entityMeta, HashMap<String, String> columnFieldMap, List queryResultRows, String[] labelNames, Class resultType, List<TableCascadeModel> cascadeModel, Class[] hiberarchyClasses, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        Object masterBean;
        ArrayList masterData;
        Iterator<List> groupListIter;
        String[] groupFields = cascadeModel.get(0).getFields();
        int groupSize = groupFields.length;
        int[] colIndexs = new int[groupSize];
        IgnoreKeyCaseMap<String, Integer> labelIndexs = new IgnoreKeyCaseMap<String, Integer>();
        int index = 0;
        for (String label : labelNames) {
            labelIndexs.put(label.replace("_", ""), index);
            ++index;
        }
        for (int i = 0; i < groupSize; ++i) {
            if (!labelIndexs.containsKey(groupFields[i])) {
                throw new DataAccessException("\u5c42\u6b21\u7ed3\u6784\u5c01\u88c5\u64cd\u4f5c,\u67e5\u8be2\u7ed3\u679c\u4e2d\u672a\u5305\u542bOneToOne\u6216OneToMany\u7684\u5206\u7ec4\u5c5e\u6027(\u5bf9\u8c61\u5c5e\u6027\u540d\u79f0,\u6b63\u5e38\u4e0d\u5305\u542b\u4e0b\u5212\u7ebf):" + groupFields[i] + " \u5bf9\u5e94\u7684\u503c!");
            }
            colIndexs[i] = (Integer)labelIndexs.get(groupFields[i]);
        }
        boolean hasOneToMany = false;
        for (TableCascadeModel cascade : cascadeModel) {
            if (cascade.getCascadeType() != 1) continue;
            hasOneToMany = true;
            break;
        }
        LinkedHashMap<String, List> groupListMap = null;
        if (hasOneToMany) {
            groupListMap = ResultUtils.hashGroupList(queryResultRows, colIndexs);
            groupListIter = groupListMap.values().iterator();
            masterData = new ArrayList();
            while (groupListIter.hasNext()) {
                masterData.add(groupListIter.next().get(0));
            }
        } else {
            masterData = queryResultRows;
        }
        List result = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), masterData, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap), resultType);
        ArrayList<List> oneToOnes = new ArrayList<List>();
        ArrayList<String> oneToOneProps = new ArrayList<String>();
        ArrayList<String> oneToOneNotNullField = new ArrayList<String>();
        TableCascadeModel oneToMany = null;
        int oneToManySize = 0;
        block4: for (TableCascadeModel cascade : cascadeModel) {
            if (cascade.getCascadeType() == 2) {
                boolean hasCascade = false;
                if (hiberarchyClasses != null) {
                    for (Class hiberarchyClass : hiberarchyClasses) {
                        if (!hiberarchyClass.equals(cascade.getMappedType())) continue;
                        hasCascade = true;
                        break;
                    }
                } else {
                    hasCascade = true;
                }
                if (!hasCascade) continue;
                if (cascade.getMappedFields() != null && cascade.getMappedFields().length > 0) {
                    void var27_37;
                    boolean bl = false;
                    while (var27_37 < groupSize) {
                        labelNames[colIndexs[var27_37]] = cascade.getMappedFields()[var27_37];
                        ++var27_37;
                    }
                }
                columnFieldMap = null;
                if (entityMeta != null && sqlToyContext.isEntity(cascade.getMappedType())) {
                    columnFieldMap = sqlToyContext.getEntityMeta(cascade.getMappedType()).getColumnFieldMap();
                }
                List list = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), masterData, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, cascade.getMappedType()), columnFieldMap), cascade.getMappedType());
                ResultUtils.wrapResultTranslate(sqlToyContext, list, cascade.getMappedType());
                oneToOnes.add(list);
                oneToOneProps.add(cascade.getProperty());
                oneToOneNotNullField.add(cascade.getNotNullField());
                continue;
            }
            if (hiberarchyClasses != null) {
                for (Class hiberarchyClass : hiberarchyClasses) {
                    if (!hiberarchyClass.equals(cascade.getMappedType())) continue;
                    oneToMany = cascade;
                    continue block4;
                }
                continue;
            }
            if (oneToMany == null) {
                oneToMany = cascade;
            }
            ++oneToManySize;
        }
        if (oneToManySize > 1 && hiberarchyClasses == null) {
            throw new IllegalArgumentException("\u8fd4\u56de\u4f9d\u7167\u5c42\u6b21\u7ed3\u6784\u7ed3\u679c\u65f6\uff0c\u5b58\u5728\u591a\u4e2aoneToMany\u6620\u5c04\u5173\u7cfb\uff0c\u5fc5\u987b\u8981\u6307\u660ehiberarchyClasses!");
        }
        if (!oneToOneProps.isEmpty()) {
            int oneToOneSize = oneToOneProps.size();
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                masterBean = result.get(i);
                for (int j = 0; j < oneToOneSize; ++j) {
                    String property = (String)oneToOneProps.get(j);
                    String string = (String)oneToOneNotNullField.get(j);
                    Object oneToOneBean = ((List)oneToOnes.get(j)).get(i);
                    if (string != null) {
                        if (null == BeanUtil.getProperty(oneToOneBean, string)) continue;
                        BeanUtil.setProperty(masterBean, property, oneToOneBean);
                        continue;
                    }
                    BeanUtil.setProperty(masterBean, property, oneToOneBean);
                }
            }
        }
        if (oneToMany != null) {
            if (oneToMany.getMappedFields() != null && oneToMany.getMappedFields().length > 0) {
                for (int i = 0; i < groupSize; ++i) {
                    labelNames[colIndexs[i]] = oneToMany.getMappedFields()[i];
                }
            }
            Class oneToManyClass = oneToMany.getMappedType();
            columnFieldMap = null;
            if (entityMeta != null && sqlToyContext.isEntity(oneToManyClass)) {
                columnFieldMap = sqlToyContext.getEntityMeta(oneToManyClass).getColumnFieldMap();
            }
            String property = oneToMany.getProperty();
            String notNullField = oneToMany.getNotNullField();
            groupListIter = groupListMap.values().iterator();
            index = 0;
            while (groupListIter.hasNext()) {
                masterBean = result.get(index);
                List list = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), groupListIter.next(), ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, oneToManyClass), columnFieldMap), oneToManyClass);
                if (notNullField != null) {
                    for (int k = 0; k < list.size(); ++k) {
                        if (BeanUtil.getProperty(list.get(k), notNullField) != null) continue;
                        list.remove(k);
                        --k;
                    }
                }
                if (!list.isEmpty()) {
                    ResultUtils.wrapResultTranslate(sqlToyContext, list, oneToManyClass);
                    BeanUtil.setProperty(masterBean, property, list);
                }
                ++index;
            }
        }
        return result;
    }

    private static String[] wrapMapFields(String[] labelNames, Map<Class, IgnoreKeyCaseMap<String, String>> resultTypeFieldsMap, Class resultType) {
        if (resultTypeFieldsMap == null || resultTypeFieldsMap.isEmpty()) {
            return (String[])labelNames.clone();
        }
        IgnoreKeyCaseMap<String, String> fieldsMap = resultTypeFieldsMap.get(resultType);
        if (fieldsMap == null || fieldsMap.isEmpty()) {
            return (String[])labelNames.clone();
        }
        String[] result = (String[])labelNames.clone();
        int size = result.length;
        for (int i = 0; i < size; ++i) {
            String fieldName = fieldsMap.get(result[i]);
            if (fieldName == null) continue;
            for (int j = 0; j < size; ++j) {
                if (!result[j].replace("_", "").equalsIgnoreCase(fieldName)) continue;
                result[j] = result[j] + "SqlToyIgnoreField";
            }
            result[i] = fieldName;
        }
        return result;
    }

    private static LinkedHashMap<String, List> hashGroupList(List queryResultRows, int[] groupIndexes) {
        LinkedHashMap<String, List> groupListMap = new LinkedHashMap<String, List>();
        Object key = "";
        for (int i = 0; i < queryResultRows.size(); ++i) {
            List row = (List)queryResultRows.get(i);
            key = "";
            for (int j = 0; j < groupIndexes.length; ++j) {
                key = (String)key + "," + row.get(groupIndexes[j]);
            }
            ArrayList<List> groupList = groupListMap.get(key);
            if (groupList == null) {
                groupList = new ArrayList<List>();
            }
            groupList.add(row);
            groupListMap.put((String)key, groupList);
        }
        return groupListMap;
    }

    public static String[] humpFieldNames(String[] labelNames, HashMap<String, String> colFieldMap) {
        if (labelNames == null) {
            return null;
        }
        String[] result = new String[labelNames.length];
        if (colFieldMap == null) {
            int n = labelNames.length;
            for (int i = 0; i < n; ++i) {
                result[i] = StringUtil.toHumpStr(labelNames[i], false);
            }
        } else {
            int n = labelNames.length;
            for (int i = 0; i < n; ++i) {
                result[i] = colFieldMap.get(labelNames[i].toLowerCase());
                if (result[i] != null) continue;
                result[i] = StringUtil.toHumpStr(labelNames[i], false);
            }
        }
        return result;
    }

    private static void warnLog(SqlToyConfig sqlToyConfig, int totalCount) {
        logger.warn("Large Result:totalCount={},sqlId={},sql={}", new Object[]{totalCount, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
    }

    private static Set<String> getStringColumns(SqlToyConfig sqlToyConfig) {
        HashSet<String> strSet = new HashSet<String>();
        if (sqlToyConfig.getTranslateMap() != null && !sqlToyConfig.getTranslateMap().isEmpty()) {
            strSet.addAll(sqlToyConfig.getTranslateMap().keySet());
        }
        if (sqlToyConfig.getLinkModel() != null) {
            for (String col : sqlToyConfig.getLinkModel().getColumns()) {
                strSet.add(col.toLowerCase());
            }
        }
        if (sqlToyConfig.getFormatModels() != null && !sqlToyConfig.getFormatModels().isEmpty()) {
            for (FormatModel fmt : sqlToyConfig.getFormatModels()) {
                strSet.add(fmt.getColumn());
            }
        }
        return strSet;
    }

    public static void wrapResultTranslate(SqlToyContext sqlToyContext, Object result, Class resultType) {
        ArrayList<Object> voList;
        HashMap<String, Translate> translateConfig = TranslateConfigParse.getClassTranslates(resultType);
        if (result == null || translateConfig == null || translateConfig.isEmpty()) {
            return;
        }
        HashMap<String, HashMap<String, Object[]>> cacheDatas = sqlToyContext.getTranslateManager().getTranslates(translateConfig);
        if (result instanceof List) {
            voList = (ArrayList<Object>)result;
        } else {
            voList = new ArrayList<Object>();
            voList.add(result);
        }
        if (voList.isEmpty()) {
            return;
        }
        translateConfig = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateConfig);
        String field = null;
        try {
            for (int i = 0; i < voList.size(); ++i) {
                Object item = voList.get(i);
                for (Map.Entry<String, Translate> entry : translateConfig.entrySet()) {
                    field = entry.getKey();
                    TranslateExtend trans = entry.getValue().getExtend();
                    HashMap<String, Object[]> cacheData = cacheDatas.get(trans.column);
                    Object srcFieldValue = BeanUtil.getProperty(item, trans.keyColumn);
                    Object fieldValue = BeanUtil.getProperty(item, field);
                    if (srcFieldValue == null || "".equals(srcFieldValue.toString()) || fieldValue != null) continue;
                    BeanUtil.setProperty(item, field, ResultUtils.translateKey(trans, cacheData, srcFieldValue));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u9488\u5bf9\u7c7b:{} \u7684\u5c5e\u6027:{} \u8fdb\u884c\u7f13\u5b58\u7ffb\u8bd1\u53d1\u751f\u5f02\u5e38!{}", new Object[]{resultType.getName(), field, e.getMessage()});
        }
    }

    public static HashMap<String, Translate> wrapI18nIndex(TranslateManager translateManager, HashMap<String, Translate> translateConfig) {
        String locale = I18nThreadHolder.getLocale();
        if (locale == null || translateConfig == null || translateConfig.isEmpty()) {
            return translateConfig;
        }
        HashMap<String, Translate> result = new HashMap<String, Translate>();
        for (Map.Entry<String, Translate> entry : translateConfig.entrySet()) {
            Integer realIndex;
            String key = entry.getKey();
            TranslateExtend transExt = entry.getValue().getExtend();
            result.put(key, entry.getValue());
            TranslateConfigModel translateConfigModel = translateManager.getCacheConfig(transExt.cache);
            if (!translateConfigModel.hasI18n(transExt.index) || (realIndex = translateConfigModel.getI18nIndex(locale)) == null || realIndex == transExt.index) continue;
            Translate translate = entry.getValue().clone();
            translate.setIndex(realIndex);
            result.put(key, translate);
        }
        return result;
    }

    private static void wrapBeanTranslate(SqlToyContext sqlToyContext, HashMap<String, HashMap<String, Object[]>> cacheDatas, HashMap<String, Translate> translateConfig, Object item) {
        String field = null;
        try {
            for (Map.Entry<String, Translate> entry : translateConfig.entrySet()) {
                field = entry.getKey();
                TranslateExtend trans = entry.getValue().getExtend();
                HashMap<String, Object[]> cacheData = cacheDatas.get(trans.column);
                Object srcFieldValue = BeanUtil.getProperty(item, trans.keyColumn);
                Object fieldValue = BeanUtil.getProperty(item, field);
                if (srcFieldValue == null || "".equals(srcFieldValue.toString()) || fieldValue != null) continue;
                BeanUtil.setProperty(item, field, ResultUtils.translateKey(trans, cacheData, srcFieldValue));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u9488\u5bf9\u7c7b:{} \u7684\u5c5e\u6027:{} \u8fdb\u884c\u7f13\u5b58\u7ffb\u8bd1\u53d1\u751f\u5f02\u5e38!{}", new Object[]{item.getClass().getName(), field, e.getMessage()});
        }
    }
}

