/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.CallableStatementResultHandler;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.InsertRowCallbackHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.RowCallbackHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.TreeTableModel;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtil.class);
    public static final Pattern maskPattern = Pattern.compile("\\/\\*[^+!]");
    public static final Pattern ORDER_BY_PATTERN = Pattern.compile("(?i)\\Worder\\s+by\\W");
    public static final Pattern UPCASE_ORDER_PATTERN = Pattern.compile("\\WORder\\s+");
    public static final String SELECT_REGEX = "select\\s+";
    public static final String FROM_REGEX = "\\s+from[\\(\\s+]";
    public static final Pattern UNION_PATTERN = Pattern.compile("(?i)\\W+union\\W+");
    private static ConcurrentHashMap<String, String> convertSqlMap = new ConcurrentHashMap();
    private static HashMap sqlCommentfilters = new HashMap();

    private SqlUtil() {
    }

    @Deprecated
    public static String combineQueryInStr(Object conditions, Integer colIndex, String property, boolean isChar) {
        StringBuilder conditons = new StringBuilder(64);
        String flag = "";
        if (isChar) {
            flag = "'";
        }
        int dimen = CollectionUtil.judgeObjectDimen(conditions);
        switch (dimen) {
            case 0: {
                conditons.append(flag).append(conditions.toString()).append(flag);
                break;
            }
            case 1: {
                Object[] array = conditions instanceof Collection ? ((Collection)conditions).toArray() : (conditions.getClass().isArray() ? CollectionUtil.convertArray(conditions) : ((Map)conditions).values().toArray());
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        conditons.append(",");
                    }
                    conditons.append(flag);
                    if (null == property) {
                        conditons.append(array[i]);
                    } else {
                        conditons.append(BeanUtil.getProperty(array[i], property));
                    }
                    conditons.append(flag);
                }
                break;
            }
            case 2: {
                Object[][] array = conditions instanceof Collection ? CollectionUtil.twoDimenlistToArray((Collection)conditions) : (conditions instanceof Object[][] ? (Object[][])conditions : CollectionUtil.twoDimenlistToArray(((Map)conditions).values()));
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        conditons.append(",");
                    }
                    conditons.append(flag);
                    if (null == property) {
                        conditons.append(array[i][colIndex]);
                    } else {
                        conditons.append(BeanUtil.getProperty(array[i][colIndex], property));
                    }
                    conditons.append(flag);
                }
                break;
            }
        }
        return conditons.toString();
    }

    public static void setParamsValue(TypeHandler typeHandler, Connection conn, Integer dbType, PreparedStatement pst, Object[] params, Integer[] paramsType, int fromIndex) throws SQLException, IOException {
        block4: {
            if (null == params || params.length <= 0) break block4;
            int n = params.length;
            int startIndex = fromIndex + 1;
            if (null == paramsType || paramsType.length == 0) {
                for (int i = 0; i < n; ++i) {
                    SqlUtil.setParamValue(typeHandler, conn, dbType, pst, params[i], -1, startIndex + i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    SqlUtil.setParamValue(typeHandler, conn, dbType, pst, params[i], paramsType[i], startIndex + i);
                }
            }
        }
    }

    private static void setSqlServerParamsValue(TypeHandler typeHandler, Connection conn, Integer dbType, PreparedStatement pst, Object[] params, Integer[] paramsType, int fromIndex) throws SQLException, IOException {
        block4: {
            if (null == params || params.length <= 0) break block4;
            int n = params.length;
            int startIndex = fromIndex + 1;
            if (null == paramsType || paramsType.length == 0) {
                for (int i = 0; i < n; ++i) {
                    SqlUtil.setParamValue(typeHandler, conn, dbType, pst, params[i], -1, startIndex + i);
                }
            } else {
                int meter = 0;
                for (int i = 0; i < n; ++i) {
                    if (paramsType[i] == 93) continue;
                    SqlUtil.setParamValue(typeHandler, conn, dbType, pst, params[i], paramsType[i], startIndex + meter);
                    ++meter;
                }
            }
        }
    }

    public static void setParamValue(TypeHandler typeHandler, Connection conn, Integer dbType, PreparedStatement pst, Object paramValue, int jdbcType, int paramIndex) throws SQLException, IOException {
        if (null == paramValue) {
            if (jdbcType != 0) {
                if (typeHandler != null && typeHandler.setNull(dbType, pst, paramIndex, jdbcType)) {
                    return;
                }
                if (jdbcType == 2004) {
                    if (dbType == 50 || dbType == 51) {
                        pst.setNull(paramIndex, -2);
                    } else {
                        pst.setNull(paramIndex, jdbcType);
                    }
                } else if (jdbcType == 2005) {
                    if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType) {
                        pst.setNull(paramIndex, jdbcType);
                    } else {
                        pst.setNull(paramIndex, 12);
                    }
                } else if (jdbcType == 2011) {
                    if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType) {
                        pst.setNull(paramIndex, jdbcType);
                    } else {
                        pst.setNull(paramIndex, -9);
                    }
                } else {
                    pst.setNull(paramIndex, jdbcType);
                }
            } else {
                pst.setNull(paramIndex, 0);
            }
            return;
        }
        if (typeHandler != null && typeHandler.setValue(dbType, pst, paramIndex, jdbcType, paramValue)) {
            return;
        }
        if (paramValue instanceof String) {
            String tmpStr = (String)paramValue;
            if (jdbcType == 2005) {
                if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType || 120 == dbType) {
                    Clob clob = conn.createClob();
                    clob.setString(1L, tmpStr);
                    pst.setClob(paramIndex, clob);
                } else {
                    pst.setString(paramIndex, tmpStr);
                }
            } else if (jdbcType == 2011) {
                if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType || 120 == dbType) {
                    NClob nclob = conn.createNClob();
                    nclob.setString(1L, tmpStr);
                    pst.setNClob(paramIndex, nclob);
                } else {
                    pst.setString(paramIndex, tmpStr);
                }
            } else {
                pst.setString(paramIndex, tmpStr);
            }
        } else if (paramValue instanceof Integer) {
            Integer paramInt = (Integer)paramValue;
            if (jdbcType == 16) {
                if (paramInt == 1) {
                    pst.setBoolean(paramIndex, true);
                } else {
                    pst.setBoolean(paramIndex, false);
                }
            } else {
                pst.setInt(paramIndex, paramInt);
            }
        } else if (paramValue instanceof LocalDateTime) {
            pst.setTimestamp(paramIndex, Timestamp.valueOf((LocalDateTime)paramValue));
        } else if (paramValue instanceof BigDecimal) {
            pst.setBigDecimal(paramIndex, (BigDecimal)paramValue);
        } else if (paramValue instanceof LocalDate) {
            pst.setDate(paramIndex, Date.valueOf((LocalDate)paramValue));
        } else if (paramValue instanceof Timestamp) {
            pst.setTimestamp(paramIndex, (Timestamp)paramValue);
        } else if (paramValue instanceof java.util.Date) {
            if (dbType == 60) {
                pst.setDate(paramIndex, new Date(((java.util.Date)paramValue).getTime()));
            } else {
                pst.setTimestamp(paramIndex, new Timestamp(((java.util.Date)paramValue).getTime()));
            }
        } else if (paramValue instanceof BigInteger) {
            pst.setBigDecimal(paramIndex, new BigDecimal((BigInteger)paramValue));
        } else if (paramValue instanceof Double) {
            pst.setDouble(paramIndex, (Double)paramValue);
        } else if (paramValue instanceof Long) {
            pst.setLong(paramIndex, (Long)paramValue);
        } else if (paramValue instanceof Clob) {
            String tmpStr = SqlUtil.clobToString((Clob)paramValue);
            pst.setString(paramIndex, tmpStr);
        } else if (paramValue instanceof byte[]) {
            if (jdbcType == 2004) {
                Blob blob = null;
                try {
                    blob = conn.createBlob();
                    OutputStream out = blob.setBinaryStream(1L);
                    out.write((byte[])paramValue);
                    out.flush();
                    out.close();
                    pst.setBlob(paramIndex, blob);
                }
                catch (Exception e) {
                    pst.setBytes(paramIndex, (byte[])paramValue);
                }
            } else {
                pst.setBytes(paramIndex, (byte[])paramValue);
            }
        } else if (paramValue instanceof Float) {
            pst.setFloat(paramIndex, ((Float)paramValue).floatValue());
        } else if (paramValue instanceof Blob) {
            Blob tmp = (Blob)paramValue;
            pst.setBytes(paramIndex, tmp.getBytes(0L, Long.valueOf(tmp.length()).intValue()));
        } else if (paramValue instanceof Date) {
            pst.setDate(paramIndex, (Date)paramValue);
        } else if (paramValue instanceof Boolean) {
            pst.setBoolean(paramIndex, (Boolean)paramValue);
        } else if (paramValue instanceof LocalTime) {
            pst.setTime(paramIndex, Time.valueOf((LocalTime)paramValue));
        } else if (paramValue instanceof Time) {
            pst.setTime(paramIndex, (Time)paramValue);
        } else if (paramValue instanceof Character) {
            String tmpStr = ((Character)paramValue).toString();
            pst.setString(paramIndex, tmpStr);
        } else if (paramValue instanceof Short) {
            pst.setShort(paramIndex, (Short)paramValue);
        } else if (paramValue instanceof Byte) {
            pst.setByte(paramIndex, (Byte)paramValue);
        } else if (paramValue instanceof Object[]) {
            SqlUtil.setArray(dbType, conn, pst, paramIndex, paramValue);
        } else if (paramValue instanceof Collection) {
            Object[] values = ((Collection)paramValue).toArray();
            if (values.length == 0) {
                pst.setNull(paramIndex, 2003);
            } else {
                String type = null;
                for (Object val : values) {
                    if (val == null) continue;
                    type = val.getClass().getName().concat("[]");
                    break;
                }
                if (type != null) {
                    SqlUtil.setArray(dbType, conn, pst, paramIndex, BeanUtil.convertArray(values, type));
                } else {
                    pst.setNull(paramIndex, 2003);
                }
            }
        } else if (jdbcType != 0) {
            pst.setObject(paramIndex, paramValue, jdbcType);
        } else {
            pst.setObject(paramIndex, paramValue);
        }
    }

    private static void setArray(Integer dbType, Connection conn, PreparedStatement pst, int paramIndex, Object paramValue) throws SQLException {
        if (dbType == 70) {
            if (paramValue instanceof Integer[]) {
                Array array = conn.createArrayOf("INTEGER", (Integer[])paramValue);
                pst.setArray(paramIndex, array);
            } else if (paramValue instanceof String[]) {
                Array array = conn.createArrayOf("VARCHAR", (String[])paramValue);
                pst.setArray(paramIndex, array);
            } else if (paramValue instanceof BigDecimal[]) {
                Array array = conn.createArrayOf("NUMBER", (BigDecimal[])paramValue);
                pst.setArray(paramIndex, array);
            } else if (paramValue instanceof BigInteger[]) {
                Array array = conn.createArrayOf("BIGINT", (BigInteger[])paramValue);
                pst.setArray(paramIndex, array);
            } else if (paramValue instanceof Float[]) {
                Array array = conn.createArrayOf("FLOAT", (Float[])paramValue);
                pst.setArray(paramIndex, array);
            } else if (paramValue instanceof Long[]) {
                Array array = conn.createArrayOf("INTEGER", (Long[])paramValue);
                pst.setArray(paramIndex, array);
            } else {
                pst.setObject(paramIndex, paramValue, 2003);
            }
        } else {
            pst.setObject(paramIndex, paramValue, 2003);
        }
    }

    private static List reflectResultToVO(TypeHandler typeHandler, DecryptHandler decryptHandler, ResultSet rs, Class voClass, boolean ignoreAllEmptySet, HashMap<String, String> columnFieldMap) throws Exception {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int warnThresholds = SqlToyConstants.getWarnThresholds();
        boolean warnLimit = false;
        long maxThresholds = SqlToyConstants.getMaxThresholds();
        boolean maxLimit = false;
        if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
            maxThresholds = warnThresholds;
        }
        String[] columnNames = SqlUtil.getColumnLabels(rs.getMetaData());
        String[] fields = new String[columnNames.length];
        boolean hasMap = columnFieldMap != null && !columnFieldMap.isEmpty();
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = columnNames[i].toLowerCase();
            if (hasMap) {
                if (columnFieldMap.containsKey(fields[i])) {
                    fields[i] = columnFieldMap.get(fields[i]);
                    continue;
                }
                fields[i] = fields[i].replace("_", "");
                continue;
            }
            fields[i] = fields[i].replace("_", "");
        }
        Method[] setMethods = BeanUtil.matchSetMethods(voClass, fields);
        String[] propTypes = new String[setMethods.length];
        int[] propTypeValues = new int[setMethods.length];
        Class[] genericTypes = new Class[setMethods.length];
        for (int i = 0; i < propTypes.length; ++i) {
            if (setMethods[i] == null) continue;
            propTypes[i] = setMethods[i].getParameterTypes()[0].getTypeName();
            propTypeValues[i] = DataType.getType(propTypes[i]);
            Type[] types = setMethods[i].getGenericParameterTypes();
            if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
            genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
        }
        int index = 0;
        while (rs.next()) {
            Object rowData = SqlUtil.reflectResultRowToVOClass(typeHandler, decryptHandler, rs, columnNames, setMethods, propTypeValues, propTypes, genericTypes, voClass, ignoreAllEmptySet);
            if (rowData != null) {
                resultList.add(rowData);
            }
            if (++index == warnThresholds) {
                warnLimit = true;
            }
            if ((long)index != maxThresholds) continue;
            maxLimit = true;
            break;
        }
        if (warnLimit) {
            logger.warn("Large Result:class={},total:{}>={}" + index, new Object[]{voClass.getName(), index, warnThresholds});
        }
        if (maxLimit) {
            logger.warn("Large Result:class={},total:{}>={}" + index, new Object[]{voClass.getName(), index, maxThresholds});
        }
        return resultList;
    }

    private static Object reflectResultRowToVOClass(TypeHandler typeHandler, DecryptHandler decryptHandler, ResultSet rs, String[] columnLabels, Method[] setMethods, int[] propTypeValues, String[] propTypes, Class[] genericTypes, Class voClass, boolean ignoreAllEmptySet) throws Exception {
        Object bean = voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        boolean allNull = true;
        int n = columnLabels.length;
        for (int i = 0; i < n; ++i) {
            Object fieldValue;
            String label = columnLabels[i];
            Method method = setMethods[i];
            String typeName = propTypes[i];
            int typeValue = propTypeValues[i];
            if (method == null || null == (fieldValue = rs.getObject(label))) continue;
            if (decryptHandler != null) {
                fieldValue = decryptHandler.decrypt(label, fieldValue);
            }
            allNull = false;
            method.invoke(bean, BeanUtil.convertType(typeHandler, fieldValue, typeValue, typeName, genericTypes[i]));
        }
        if (allNull && ignoreAllEmptySet) {
            return null;
        }
        return bean;
    }

    private static String[] getColumnLabels(ResultSetMetaData rsmd) throws SQLException {
        int fieldCnt = rsmd.getColumnCount();
        String[] columnNames = new String[fieldCnt];
        for (int i = 1; i < fieldCnt + 1; ++i) {
            columnNames[i - 1] = rsmd.getColumnLabel(i);
        }
        return columnNames;
    }

    public static Object preparedStatementProcess(Object userData, PreparedStatement pst, ResultSet rs, PreparedStatementResultHandler preparedStatementResultHandler) throws Exception {
        try {
            preparedStatementResultHandler.execute(userData, pst, rs);
        }
        catch (Exception se) {
            logger.error(se.getMessage(), (Throwable)se);
            throw se;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return preparedStatementResultHandler.getResult();
    }

    public static Object callableStatementProcess(Object userData, CallableStatement pst, ResultSet rs, CallableStatementResultHandler callableStatementResultHandler) throws Exception {
        try {
            callableStatementResultHandler.execute(userData, pst, rs);
        }
        catch (Exception se) {
            logger.error(se.getMessage(), (Throwable)se);
            throw se;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return callableStatementResultHandler.getResult();
    }

    public static String clearMark(String sql) {
        int endMarkIndex;
        if (StringUtil.isBlank(sql)) {
            return sql;
        }
        int markIndex = sql.indexOf("<!--");
        while (markIndex != -1) {
            endMarkIndex = sql.indexOf("-->", markIndex);
            if (endMarkIndex == -1 || endMarkIndex == sql.length() - 3) {
                sql = sql.substring(0, markIndex);
                break;
            }
            sql = sql.substring(0, markIndex).concat(" ").concat(sql.substring(endMarkIndex + 3));
            markIndex = sql.indexOf("<!--");
        }
        markIndex = StringUtil.matchIndex(sql, maskPattern);
        while (markIndex != -1) {
            endMarkIndex = sql.indexOf("*/", markIndex);
            if (endMarkIndex == -1 || endMarkIndex == sql.length() - 2) {
                sql = sql.substring(0, markIndex);
                break;
            }
            sql = sql.substring(0, markIndex).concat(" ").concat(sql.substring(endMarkIndex + 2));
            markIndex = StringUtil.matchIndex(sql, maskPattern);
        }
        if (sql.contains("--")) {
            String[] sqlAry = sql.split("\n");
            StringBuilder sqlBuffer = new StringBuilder();
            int meter = 0;
            for (String line : sqlAry) {
                String lineStr = line.trim();
                if ("".equals(lineStr) || lineStr.startsWith("--")) continue;
                int lineMaskIndex = line.indexOf("--");
                if (meter > 0) {
                    sqlBuffer.append("\n");
                }
                sqlBuffer.append(" ");
                if (lineMaskIndex == -1) {
                    sqlBuffer.append(line);
                } else {
                    int startMask = SqlUtil.findStartLineMask(line, lineMaskIndex);
                    if (startMask > 0) {
                        sqlBuffer.append(line.substring(0, startMask));
                    } else {
                        sqlBuffer.append(line);
                    }
                }
                ++meter;
            }
            sql = sqlBuffer.toString();
        }
        if (sql.endsWith(";") || sql.endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        sql = sql.replaceAll("\\\uff1a", ":").replaceAll("\\\uff1d", "=").replaceAll("\\\uff0e", ".");
        return sql;
    }

    private static int findStartLineMask(String sql, int lineMaskIndex) {
        int symMarkEnd;
        int lastIndex = StringUtil.matchLastIndex(sql, "'|\"|\\*\\/");
        if (lineMaskIndex > lastIndex) {
            return lineMaskIndex;
        }
        int start = StringUtil.matchIndex(sql, "'");
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkIndex("'", "'", sql, start)) != -1) {
            sql = sql.substring(0, start).concat(SqlUtil.loopBlank(symMarkEnd - start + 1)).concat(sql.substring(symMarkEnd + 1));
            start = StringUtil.matchIndex(sql, "'");
        }
        start = StringUtil.matchIndex(sql, "\"");
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkIndex("\"", "\"", sql, start)) != -1) {
            sql = sql.substring(0, start).concat(SqlUtil.loopBlank(symMarkEnd - start + 1)).concat(sql.substring(symMarkEnd + 1));
            start = StringUtil.matchIndex(sql, "\"");
        }
        start = sql.indexOf("/*");
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkIndex("/*", "*/", sql, start)) != -1) {
            sql = sql.substring(0, start).concat(SqlUtil.loopBlank(symMarkEnd - start + 2)).concat(sql.substring(symMarkEnd + 2));
            start = sql.indexOf("/*");
        }
        return sql.indexOf("--");
    }

    private static String loopBlank(int size) {
        if (size == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    public static Object loadByJdbcQuery(TypeHandler typeHandler, String queryStr, Object[] params, Class voClass, RowCallbackHandler rowCallbackHandler, Connection conn, Integer dbType, boolean ignoreAllEmptySet, HashMap<String, String> colFieldMap) throws Exception {
        List result = SqlUtil.findByJdbcQuery(typeHandler, queryStr, params, voClass, rowCallbackHandler, null, conn, dbType, ignoreAllEmptySet, colFieldMap, -1, -1);
        if (result != null && !result.isEmpty()) {
            if (result.size() > 1) {
                throw new IllegalAccessException("\u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00,loadByJdbcQuery \u65b9\u6cd5\u53ea\u9488\u5bf9\u5355\u6761\u7ed3\u679c\u7684\u6570\u636e\u67e5\u8be2!");
            }
            return result.get(0);
        }
        return null;
    }

    public static Object getSequenceValue(Connection conn, String sequence, Integer dbType) throws DataAccessException {
        String sql = "";
        sql = dbType == 50 || dbType == 51 || dbType == 120 || dbType == 170 ? "select nextval('" + sequence + "')" : (dbType == 30 ? "select NEXT VALUE FOR " + sequence : (dbType == 70 || dbType == 100 || dbType == 10 || dbType == 11 || dbType == 110 ? "select " + sequence + ".nextval" : "select NEXTVAL FOR " + sequence));
        PreparedStatement pst = null;
        ResultSet rs = null;
        Object id = null;
        try {
            SqlExecuteStat.showSql("\u83b7\u53d6sequence\u4e0b\u4e00\u4e2a\u503c", sql, null);
            pst = conn.prepareStatement(sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                id = rs.getObject(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException("\u83b7\u53d6sequence={} \u503c\u5931\u8d25!\u9519\u8bef\u4fe1\u606f:{}", sequence, e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                rs = null;
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (Exception exception) {}
                pst = null;
            }
        }
        return id;
    }

    public static List findByJdbcQuery(final TypeHandler typeHandler, String queryStr, final Object[] params, final Class voClass, final RowCallbackHandler rowCallbackHandler, final DecryptHandler decryptHandler, final Connection conn, final Integer dbType, final boolean ignoreAllEmptySet, final HashMap<String, String> colFieldMap, int fetchSize, int maxRows) throws Exception {
        ArrayList result;
        ResultSet rs = null;
        PreparedStatement pst = conn.prepareStatement(queryStr, 1003, 1007);
        if (fetchSize > 0) {
            pst.setFetchSize(fetchSize);
        }
        if (maxRows > 0) {
            pst.setMaxRows(maxRows);
        }
        if ((result = (ArrayList)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws Exception {
                SqlUtil.setParamsValue(typeHandler, conn, dbType, pst, params, null, 0);
                rs = pst.executeQuery();
                this.setResult(SqlUtil.processResultSet(typeHandler, rs, voClass, rowCallbackHandler, decryptHandler, 0, ignoreAllEmptySet, colFieldMap));
            }
        })) == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static List processResultSet(TypeHandler typeHandler, ResultSet rs, Class voClass, RowCallbackHandler rowCallbackHandler, DecryptHandler decryptHandler, int startColIndex, boolean ignoreAllEmptySet, HashMap<String, String> colFieldMap) throws Exception {
        ArrayList result;
        int index = 0;
        int warnThresholds = SqlToyConstants.getWarnThresholds();
        boolean warnLimit = false;
        long maxThresholds = SqlToyConstants.getMaxThresholds();
        boolean maxLimit = false;
        if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
            maxThresholds = warnThresholds;
        }
        if (voClass != null) {
            result = SqlUtil.reflectResultToVO(typeHandler, decryptHandler, rs, voClass, ignoreAllEmptySet, colFieldMap);
        } else if (rowCallbackHandler != null) {
            while (rs.next()) {
                rowCallbackHandler.processRow(rs, index);
                if (++index == warnThresholds) {
                    warnLimit = true;
                }
                if ((long)index != maxThresholds) continue;
                maxLimit = true;
                break;
            }
            result = rowCallbackHandler.getResult();
        } else {
            int rowCnt = rs.getMetaData().getColumnCount();
            ArrayList items = new ArrayList();
            Object fieldValue = null;
            boolean allNull = true;
            while (rs.next()) {
                allNull = true;
                ArrayList<Object> rowData = new ArrayList<Object>();
                for (int i = startColIndex; i < rowCnt; ++i) {
                    fieldValue = rs.getObject(i + 1);
                    if (fieldValue != null) {
                        allNull = false;
                        if (fieldValue instanceof Clob) {
                            fieldValue = SqlUtil.clobToString((Clob)fieldValue);
                        }
                    }
                    rowData.add(fieldValue);
                }
                if (!allNull || !ignoreAllEmptySet) {
                    items.add(rowData);
                }
                if (++index == warnThresholds) {
                    warnLimit = true;
                }
                if ((long)index != maxThresholds) continue;
                maxLimit = true;
                break;
            }
            result = items;
        }
        if (warnLimit) {
            logger.warn("Large Result:total={}>={}", (Object)index, (Object)warnThresholds);
        }
        if (maxLimit) {
            logger.error("Max Large Result:total={}>={}", (Object)index, (Object)maxThresholds);
        }
        return result;
    }

    public static Long batchUpdateByJdbc(TypeHandler typeHandler, String updateSql, Collection rowDatas, int batchSize, InsertRowCallbackHandler insertCallhandler, Integer[] updateTypes, Boolean autoCommit, Connection conn, Integer dbType) throws Exception {
        if (rowDatas == null || rowDatas.isEmpty()) {
            logger.error("\u6267\u884cbatchUpdateByJdbc \u6570\u636e\u4e3a\u7a7a\uff0csql={}", (Object)updateSql);
            return 0L;
        }
        int argsCnt = StringUtil.matchCnt(SqlConfigParseUtils.clearDblQuestMark(updateSql), "\\?");
        Statement pst = null;
        long updateCount = 0L;
        try {
            boolean hasSetAutoCommit = false;
            boolean useCallHandler = true;
            if (insertCallhandler == null) {
                useCallHandler = false;
            }
            if (autoCommit != null && autoCommit.booleanValue() != conn.getAutoCommit()) {
                conn.setAutoCommit(autoCommit);
                hasSetAutoCommit = true;
            }
            pst = conn.prepareStatement(updateSql);
            int totalRows = rowDatas.size();
            boolean useBatch = totalRows > 1;
            int index = 0;
            int meter = 0;
            for (Object rowData : rowDatas) {
                int paramCnt;
                Object tmp;
                ++index;
                if (rowData == null) continue;
                if (useCallHandler) {
                    insertCallhandler.process((PreparedStatement)pst, index, rowData);
                } else if (rowData.getClass().isArray()) {
                    tmp = CollectionUtil.convertArray(rowData);
                    paramCnt = ((Object[])tmp).length;
                    if (meter == 0 && argsCnt != paramCnt) {
                        throw new IllegalArgumentException("batchUpdate sql\u4e2d\u7684?\u53c2\u6570\u6570\u91cf:" + argsCnt + " \u8ddf\u5b9e\u9645\u4f20\u53c2\u6570\u91cf:" + paramCnt + " \u4e0d\u7b49,\u8bf7\u68c0\u67e5!");
                    }
                    for (int i = 0; i < paramCnt; ++i) {
                        SqlUtil.setParamValue(typeHandler, conn, dbType, (PreparedStatement)pst, tmp[i], updateTypes == null ? -1 : updateTypes[i], i + 1);
                    }
                } else if (rowData instanceof Collection) {
                    tmp = (Collection)rowData;
                    paramCnt = tmp.size();
                    if (meter == 0 && argsCnt != paramCnt) {
                        throw new IllegalArgumentException("batchUpdate sql\u4e2d\u7684?\u53c2\u6570\u6570\u91cf:" + argsCnt + " \u8ddf\u5b9e\u9645\u4f20\u53c2\u6570\u91cf:" + paramCnt + " \u4e0d\u7b49,\u8bf7\u68c0\u67e5!");
                    }
                    int tmpIndex = 0;
                    Iterator tmpIter = tmp.iterator();
                    while (tmpIter.hasNext()) {
                        SqlUtil.setParamValue(typeHandler, conn, dbType, (PreparedStatement)pst, tmpIter.next(), updateTypes == null ? -1 : updateTypes[tmpIndex], tmpIndex + 1);
                        ++tmpIndex;
                    }
                }
                ++meter;
                if (useBatch) {
                    int[] updateRows;
                    pst.addBatch();
                    if (meter % batchSize != 0 && index != totalRows) continue;
                    for (int t : updateRows = pst.executeBatch()) {
                        updateCount += (long)(t > 0 ? t : 0);
                    }
                    pst.clearBatch();
                    continue;
                }
                updateCount = pst.executeUpdate();
            }
            if (hasSetAutoCommit) {
                conn.setAutoCommit(autoCommit == false);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            catch (SQLException se) {
                logger.error(se.getMessage(), (Throwable)se);
            }
        }
        return updateCount;
    }

    public static boolean wrapTreeTableRoute(TypeHandler typeHandler, TreeTableModel treeTableModel, Connection conn, Integer dbType) throws Exception {
        if (StringUtil.isBlank(treeTableModel.getTableName()) || StringUtil.isBlank(treeTableModel.getIdField()) || StringUtil.isBlank(treeTableModel.getPidField())) {
            logger.error("\u8bf7\u8bbe\u7f6e\u6811\u5f62\u8868\u7684table\u540d\u79f0\u3001id\u5b57\u6bb5\u540d\u79f0\u3001pid\u5b57\u6bb5\u540d\u79f0!");
            throw new IllegalArgumentException("\u6ca1\u6709\u5bf9\u5e94\u7684table\u540d\u79f0\u3001id\u5b57\u6bb5\u540d\u79f0\u3001pid\u5b57\u6bb5\u540d\u79f0");
        }
        String flag = "";
        if (treeTableModel.isChar().booleanValue()) {
            flag = "'";
        }
        String nodeRouteField = ReservedWordsUtil.convertWord(treeTableModel.getNodeRouteField(), dbType);
        String nodeLevelField = ReservedWordsUtil.convertWord(treeTableModel.getNodeLevelField(), dbType);
        String idField = ReservedWordsUtil.convertWord(treeTableModel.getIdField(), dbType);
        String pidField = ReservedWordsUtil.convertWord(treeTableModel.getPidField(), dbType);
        String tableName = ReservedWordsUtil.convertSimpleSql(treeTableModel.getTableName(), dbType);
        String conditions = ReservedWordsUtil.convertWord(treeTableModel.getConditions(), dbType);
        String leafField = ReservedWordsUtil.convertWord(treeTableModel.getLeafField(), dbType);
        if (StringUtil.isNotBlank(nodeRouteField) && StringUtil.isNotBlank(nodeLevelField)) {
            List ids;
            StringBuilder nextNodeQueryStr = new StringBuilder("select ").append(idField).append(",").append(nodeRouteField).append(",").append(pidField).append(" from ").append(tableName).append(" where ").append(pidField).append(" in (${inStr})");
            String idInfoSql = "select ".concat(nodeLevelField).concat(",").concat(nodeRouteField).concat(" from ").concat(tableName).concat(" where ").concat(idField).concat("=").concat(flag).concat(treeTableModel.getRootId().toString()).concat(flag);
            if (StringUtil.isNotBlank(conditions)) {
                idInfoSql = idInfoSql.concat(" and ").concat(conditions);
            }
            List idInfo = SqlUtil.findByJdbcQuery(typeHandler, idInfoSql, null, null, null, null, conn, dbType, false, null, SqlToyConstants.FETCH_SIZE, -1);
            int nodeLevel = 0;
            String nodeRoute = "";
            if (idInfo != null && !idInfo.isEmpty()) {
                nodeLevel = Integer.parseInt(((List)idInfo.get(0)).get(0).toString());
                nodeRoute = ((List)idInfo.get(0)).get(1).toString();
            }
            StringBuilder updateLevelAndRoute = new StringBuilder("update ").append(tableName).append(" set ").append(nodeLevelField).append("=?,").append(nodeRouteField).append("=? ").append(" where ").append(idField).append("=?");
            if (StringUtil.isNotBlank(conditions)) {
                nextNodeQueryStr.append(" and ").append(conditions);
                updateLevelAndRoute.append(" and ").append(conditions);
            }
            HashMap<String, String> pidsMap = new HashMap<String, String>();
            pidsMap.put(treeTableModel.getRootId().toString(), nodeRoute);
            if (treeTableModel.getIdValue() != null) {
                StringBuilder firstNextNodeQuery = new StringBuilder("select ").append(idField).append(",").append(nodeRouteField).append(",").append(pidField).append(" from ").append(tableName).append(" where ").append(idField).append("=?");
                if (StringUtil.isNotBlank(conditions)) {
                    firstNextNodeQuery.append(" and ").append(conditions);
                }
                ids = SqlUtil.findByJdbcQuery(typeHandler, firstNextNodeQuery.toString(), new Object[]{treeTableModel.getIdValue()}, null, null, null, conn, dbType, false, null, SqlToyConstants.FETCH_SIZE, -1);
            } else {
                ids = SqlUtil.findByJdbcQuery(typeHandler, nextNodeQueryStr.toString().replaceFirst("\\$\\{inStr\\}", flag + treeTableModel.getRootId() + flag), null, null, null, null, conn, dbType, false, null, SqlToyConstants.FETCH_SIZE, -1);
            }
            if (ids != null && !ids.isEmpty()) {
                SqlUtil.processNextLevel(typeHandler, updateLevelAndRoute.toString(), nextNodeQueryStr.toString(), treeTableModel, pidsMap, ids, nodeLevel + 1, conn, dbType);
            }
        }
        if (StringUtil.isNotBlank(leafField)) {
            StringBuilder updateLeafSql = new StringBuilder();
            updateLeafSql.append("update ").append(tableName);
            updateLeafSql.append(" set ").append(leafField).append("=1");
            if (StringUtil.isNotBlank(conditions)) {
                updateLeafSql.append(" where ").append(conditions);
            }
            SqlUtil.executeSql(typeHandler, updateLeafSql.toString(), null, null, conn, dbType, null, true);
            StringBuilder updateTrunkLeafSql = new StringBuilder();
            updateTrunkLeafSql.append("update ").append(tableName);
            if (dbType == 40 || dbType == 42) {
                updateTrunkLeafSql.append(" inner join (select ");
                updateTrunkLeafSql.append(pidField);
                updateTrunkLeafSql.append(" from ").append(tableName);
                if (StringUtil.isNotBlank(conditions)) {
                    updateTrunkLeafSql.append(" where ").append(conditions);
                }
                updateTrunkLeafSql.append(") as t_wrapLeaf ");
                updateTrunkLeafSql.append(" on ");
                updateTrunkLeafSql.append(idField).append("=t_wrapLeaf.").append(pidField);
                updateTrunkLeafSql.append(" set ");
                updateTrunkLeafSql.append(leafField).append("=0");
                if (StringUtil.isNotBlank(conditions)) {
                    updateTrunkLeafSql.append(" where ").append(conditions);
                }
            } else {
                updateTrunkLeafSql.append(" set ");
                updateTrunkLeafSql.append(leafField).append("=0");
                updateTrunkLeafSql.append(" where ").append(idField);
                updateTrunkLeafSql.append(" in (select ").append(pidField);
                updateTrunkLeafSql.append(" from ").append(tableName);
                if (StringUtil.isNotBlank(conditions)) {
                    updateTrunkLeafSql.append(" where ").append(conditions);
                }
                updateTrunkLeafSql.append(") ");
                if (StringUtil.isNotBlank(conditions)) {
                    updateTrunkLeafSql.append(" and ").append(conditions);
                }
            }
            SqlUtil.executeSql(typeHandler, updateTrunkLeafSql.toString(), null, null, conn, dbType, null, false);
        }
        return true;
    }

    private static void processNextLevel(TypeHandler typeHandler, String updateLevelAndRoute, String nextNodeQueryStr, final TreeTableModel treeTableModel, final HashMap pidsMap, List ids, final int nodeLevel, Connection conn, int dbType) throws Exception {
        SqlUtil.batchUpdateByJdbc(typeHandler, updateLevelAndRoute, ids, 500, new InsertRowCallbackHandler(){

            @Override
            public void process(PreparedStatement pst, int index, Object rowData) throws SQLException {
                String id = ((List)rowData).get(0).toString();
                String pid = ((List)rowData).get(2).toString();
                String nodeRoute = (String)pidsMap.get(pid);
                int size = treeTableModel.getIdLength();
                if (nodeRoute == null || "".equals(nodeRoute.trim())) {
                    nodeRoute = "";
                    nodeRoute = !treeTableModel.isChar().booleanValue() || treeTableModel.isAppendZero() ? (NumberUtil.isInteger(pid) && pid.indexOf("-") == 0 ? nodeRoute.concat("-").concat(StringUtil.addLeftZero2Len(pid.substring(1), size - 1)) : nodeRoute.concat(StringUtil.addLeftZero2Len(pid, size))) : nodeRoute.concat(StringUtil.addRightBlank2Len(pid, size));
                } else {
                    nodeRoute = nodeRoute.trim();
                }
                if (!nodeRoute.endsWith(treeTableModel.getSplitSign())) {
                    nodeRoute = nodeRoute.concat(treeTableModel.getSplitSign());
                }
                nodeRoute = treeTableModel.isChar() == false || treeTableModel.isAppendZero() ? nodeRoute.concat(StringUtil.addLeftZero2Len(id, size)) : nodeRoute.concat(StringUtil.addRightBlank2Len(id, size));
                ((List)rowData).set(1, nodeRoute);
                pst.setInt(1, nodeLevel);
                pst.setString(2, nodeRoute + (size < 2 ? treeTableModel.getSplitSign() : ""));
                if (treeTableModel.isChar().booleanValue()) {
                    pst.setString(3, id);
                } else {
                    pst.setLong(3, Long.parseLong(id));
                }
            }
        }, null, null, conn, dbType);
        int size = ids.size();
        int fromIndex = 0;
        int toIndex = -1;
        List subIds = null;
        List nextIds = null;
        boolean exist = false;
        while (toIndex < size) {
            fromIndex = toIndex + 1;
            if ((toIndex += 500) >= size - 1) {
                toIndex = size - 1;
                exist = true;
            }
            if (fromIndex >= toIndex) {
                subIds = new ArrayList();
                subIds.add(ids.get(toIndex));
            } else {
                subIds = ids.subList(fromIndex, toIndex + 1);
            }
            String inStrs = SqlUtil.combineQueryInStr(subIds, 0, null, treeTableModel.isChar());
            nextIds = SqlUtil.findByJdbcQuery(typeHandler, nextNodeQueryStr.replaceFirst("\\$\\{inStr\\}", inStrs), null, null, null, null, conn, dbType, false, null, SqlToyConstants.FETCH_SIZE, -1);
            if (nextIds != null && !nextIds.isEmpty()) {
                SqlUtil.processNextLevel(typeHandler, updateLevelAndRoute, nextNodeQueryStr, treeTableModel, CollectionUtil.hashList(subIds, 0, 1, true), nextIds, nodeLevel + 1, conn, dbType);
            }
            if (!exist) continue;
            break;
        }
    }

    public static void executeBatchSql(Connection conn, String sqlContent, Integer batchSize, Boolean autoCommit) throws Exception {
        String splitSign = DataSourceUtils.getDatabaseSqlSplitSign(conn);
        sqlContent = SqlUtil.clearMark(sqlContent);
        if (splitSign.indexOf("go") != -1) {
            sqlContent = SqlUtil.clearMistyChars(sqlContent, " ");
        }
        String[] statments = StringUtil.splitExcludeSymMark(sqlContent, splitSign, sqlCommentfilters);
        boolean hasSetAutoCommit = false;
        if (autoCommit != null && autoCommit.booleanValue() != conn.getAutoCommit()) {
            conn.setAutoCommit(autoCommit);
            hasSetAutoCommit = true;
        }
        Statement stat = null;
        try {
            stat = conn.createStatement();
            int meter = 0;
            int realBatch = batchSize == null || batchSize > 1 ? batchSize : 100;
            int totalRows = statments.length;
            int i = 0;
            for (String sql : statments) {
                if (StringUtil.isNotBlank(sql)) {
                    ++meter;
                    logger.debug("\u6b63\u5728\u6279\u91cf\u6267\u884c\u7684sql:{}", (Object)sql);
                    stat.addBatch(sql);
                }
                if (meter % realBatch == 0 || i + 1 == totalRows) {
                    stat.executeBatch();
                    stat.clearBatch();
                }
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (stat != null) {
                stat.close();
                stat = null;
            }
        }
        if (hasSetAutoCommit) {
            conn.setAutoCommit(autoCommit == false);
        }
    }

    public static boolean hasOrderBy(String sql, boolean judgeUpcase) {
        int upcaseOrderBy;
        int lastBracketIndex = sql.lastIndexOf(")");
        boolean result = false;
        int orderByIndex = StringUtil.matchLastIndex(sql, ORDER_BY_PATTERN);
        if (orderByIndex > lastBracketIndex) {
            result = true;
        }
        if (judgeUpcase && (upcaseOrderBy = StringUtil.matchLastIndex(sql, UPCASE_ORDER_PATTERN)) > lastBracketIndex) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(8192);
        Reader clobStream = null;
        try {
            clobStream = clob.getCharacterStream();
            char[] b = new char[1024];
            int i = 0;
            while ((i = clobStream.read(b)) != -1) {
                sb.append(b, 0, i);
            }
        }
        catch (Exception ex) {
            try {
                sb = null;
            }
            catch (Throwable throwable) {
                SqlUtil.closeQuietly(clobStream);
                throw throwable;
            }
            SqlUtil.closeQuietly(clobStream);
        }
        SqlUtil.closeQuietly(clobStream);
        if (sb == null) {
            return null;
        }
        return sb.toString();
    }

    public static Long executeSql(final TypeHandler typeHandler, String executeSql, final Object[] params, final Integer[] paramsType, final Connection conn, final Integer dbType, Boolean autoCommit, boolean processWord) throws Exception {
        PreparedStatement pst;
        Object result;
        String realSql = processWord ? ReservedWordsUtil.convertSql(executeSql, dbType) : executeSql;
        SqlExecuteStat.showSql("execute sql=", realSql, params);
        boolean hasSetAutoCommit = false;
        Long updateCounts = null;
        if (autoCommit != null && autoCommit == false == conn.getAutoCommit()) {
            conn.setAutoCommit(autoCommit);
            hasSetAutoCommit = true;
        }
        if ((result = SqlUtil.preparedStatementProcess(null, pst = conn.prepareStatement(realSql), null, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException, IOException {
                if (dbType == 30 && paramsType != null) {
                    SqlUtil.setSqlServerParamsValue(typeHandler, conn, dbType, pst, params, paramsType, 0);
                } else {
                    SqlUtil.setParamsValue(typeHandler, conn, dbType, pst, params, paramsType, 0);
                }
                pst.executeUpdate();
                this.setResult(pst.getUpdateCount());
            }
        })) != null) {
            updateCounts = (Long)result;
        }
        if (hasSetAutoCommit && autoCommit != null) {
            conn.setAutoCommit(autoCommit == false);
        }
        return updateCounts;
    }

    public static Object convertIdValueType(Object idValue, String idType) {
        if (idValue == null) {
            return null;
        }
        if (StringUtil.isBlank(idType)) {
            return idValue;
        }
        if ("java.lang.string".equals(idType)) {
            return idValue.toString();
        }
        if ("java.lang.integer".equals(idType)) {
            return Integer.valueOf(idValue.toString());
        }
        if ("java.lang.long".equals(idType)) {
            return Long.valueOf(idValue.toString());
        }
        if ("java.math.biginteger".equals(idType)) {
            return new BigInteger(idValue.toString());
        }
        if ("java.math.bigdecimal".equals(idType)) {
            return new BigDecimal(idValue.toString());
        }
        if ("long".equals(idType)) {
            return (long)Long.valueOf(idValue.toString());
        }
        if ("int".equals(idType)) {
            return (int)Integer.valueOf(idValue.toString());
        }
        if ("java.lang.short".equals(idType)) {
            return Short.valueOf(idValue.toString());
        }
        if ("short".equals(idType)) {
            return (short)Short.valueOf(idValue.toString());
        }
        return idValue;
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            SqlUtil.close(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean hasUnion(String sql, boolean clearMistyChar) {
        int symMarkEnd;
        StringBuilder lastSql = new StringBuilder(clearMistyChar ? SqlUtil.clearMistyChars(sql, " ") : sql);
        int fromIndex = StringUtil.getSymMarkMatchIndex(SELECT_REGEX, FROM_REGEX, sql.toLowerCase(), 0);
        if (fromIndex != -1) {
            lastSql.delete(0, fromIndex);
        }
        int start = lastSql.indexOf("(");
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkIndex("(", ")", lastSql.toString(), start)) != -1) {
            lastSql.delete(start, symMarkEnd + 1);
            start = lastSql.indexOf("(");
        }
        return StringUtil.matches(lastSql.toString(), UNION_PATTERN);
    }

    public static String convertFieldsToColumns(EntityMeta entityMeta, String sql) {
        if (StringUtil.isBlank(sql)) {
            return sql;
        }
        String key = entityMeta.getTableName() + "_" + sql;
        if (convertSqlMap.containsKey(key)) {
            return convertSqlMap.get(key);
        }
        String[] fields = entityMeta.getFieldsArray();
        StringBuilder sqlBuff = new StringBuilder();
        String realSql = sql.concat(" ");
        int start = 0;
        for (String field : fields) {
            String columnName = entityMeta.getColumnName(field);
            if (columnName == null || columnName.equalsIgnoreCase(field) && !ReservedWordsUtil.isKeyWord(columnName)) continue;
            start = 0;
            int index = StringUtil.indexOfIgnoreCase(realSql, field, start);
            while (index != -1) {
                String varSql;
                String preSql = realSql.substring(start, index);
                boolean isBlank = false;
                if (StringUtil.matches(preSql, "\\s$")) {
                    isBlank = true;
                }
                int preChar = !"".equals(varSql = preSql.trim()) ? (int)varSql.charAt(varSql.length() - 1) : 32;
                char tailChar = realSql.charAt(index + field.length());
                if ((isBlank && preChar != 58 || preChar > 58 && preChar < 65 || preChar > 90 && preChar < 97 && preChar != 95 || preChar < 48 || preChar > 122) && (tailChar > ':' && tailChar < 'A' || tailChar > 'Z' && tailChar < 'a' && tailChar != '_' || tailChar < '0' && tailChar != '(' || tailChar > 'z')) {
                    if (preSql.endsWith("[") || preSql.endsWith("`") || preSql.endsWith("\"")) {
                        sqlBuff.append(preSql).append(columnName);
                    } else {
                        sqlBuff.append(preSql).append(ReservedWordsUtil.convertWord(columnName, null));
                    }
                    start = index + field.length();
                }
                index = StringUtil.indexOfIgnoreCase(realSql, field, index + field.length());
            }
            if (start <= 0) continue;
            sqlBuff.append(realSql.substring(start));
            realSql = sqlBuff.toString();
            sqlBuff.delete(0, sqlBuff.length());
        }
        convertSqlMap.put(key, realSql);
        return realSql;
    }

    public static String wrapWhere(EntityMeta entityMeta) {
        String[] fields = entityMeta.getFieldsArray();
        StringBuilder sqlBuff = new StringBuilder(" 1=1 ");
        for (String field : fields) {
            String columnName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), null);
            sqlBuff.append("#[and ").append(columnName).append("=:").append(field).append("]");
        }
        return sqlBuff.toString();
    }

    public static String completionSql(SqlToyContext sqlToyContext, Class entityClass, String sql) {
        if (null == entityClass || SqlConfigParseUtils.isNamedQuery(sql)) {
            return sql;
        }
        String sqlLow = sql.toLowerCase().trim();
        if (StringUtil.matches(sqlLow, "^(select|with|show|desc)\\W")) {
            return sql;
        }
        if (StringUtil.matches(sqlLow, "^\\{?\\W*call\\W+")) {
            return sql;
        }
        if (!sqlToyContext.isEntity(entityClass)) {
            if (StringUtil.matches(sqlLow, "^from\\W")) {
                return "select * ".concat(sql);
            }
            return sql;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entityClass);
        if (StringUtil.matches(sqlLow, "^from\\W")) {
            return "select ".concat(entityMeta.getAllColumnNames()).concat(" ").concat(sql);
        }
        if (!StringUtil.matches(" ".concat(sqlLow), "\\W(from|where)\\W")) {
            if (StringUtil.matches(sqlLow, "^(and|or)\\W")) {
                return "select ".concat(entityMeta.getAllColumnNames()).concat(" from ").concat(entityMeta.getSchemaTable(null, null)).concat(" where 1=1 ").concat(sql);
            }
            return "select ".concat(entityMeta.getAllColumnNames()).concat(" from ").concat(entityMeta.getSchemaTable(null, null)).concat(" where ").concat(sql);
        }
        if (StringUtil.matches(sqlLow, "^where\\W")) {
            return "select ".concat(entityMeta.getAllColumnNames()).concat(" from ").concat(entityMeta.getSchemaTable(null, null)).concat(" ").concat(sql);
        }
        return sql;
    }

    public static boolean hasLock(String sql, Integer dbType) {
        if (sql == null) {
            return false;
        }
        if (StringUtil.matches(sql, "(?i)\\s+for\\s+update")) {
            return true;
        }
        return dbType != null && dbType == 30 && StringUtil.matches(sql, "(?i)with\\s*\\(\\s*(rowlock|xlock|updlock|holdlock|nolock|readpast)?\\,?\\s*(rowlock|xlock|updlock|holdlock|nolock|readpast)\\s*\\)");
    }

    public static String clearDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if ("".equals(defaultValue.trim())) {
            return defaultValue;
        }
        String result = defaultValue;
        if (result.indexOf("(") != -1 && result.indexOf(")") != -1 && result.indexOf("::") != -1) {
            result = result.substring(result.indexOf("(") + 1, result.indexOf("::"));
        }
        if (result.indexOf("'") != -1 && result.indexOf("::") != -1) {
            result = result.substring(0, result.indexOf("::"));
        }
        if (result.startsWith("((") && result.endsWith("))")) {
            result = result.substring(2, result.length() - 2);
        }
        if (result.startsWith("(") && result.endsWith(")")) {
            result = result.substring(1, result.length() - 1);
        }
        if (result.startsWith("'") && result.endsWith("'")) {
            result = result.substring(1, result.length() - 1);
        }
        if (result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result.trim();
    }

    public static String clearMistyChars(String source, String target) {
        if (source == null) {
            return null;
        }
        return source.replaceAll("\\s*(\r|\n)\\s*", target).replaceAll("\t", target);
    }

    public static String getDBTime(Integer dbType, FieldMeta fieldMeta, IgnoreCaseSet createSqlTimeFields) {
        int fieldType = fieldMeta.getType();
        if (createSqlTimeFields.contains(fieldMeta.getFieldName()) && (fieldType == 91 || fieldType == 92 || fieldType == 2013 || fieldType == 93 || fieldType == 2014)) {
            if (dbType == 60) {
                return "now()";
            }
            if (fieldType == 92 || fieldType == 2013 || "java.time.localtime".equals(fieldMeta.getFieldType()) || "java.sql.time".equals(fieldMeta.getFieldType())) {
                if (dbType == 40 || dbType == 42 || dbType == 90 || dbType == 80 || dbType == 170 || dbType == 50 || dbType == 51 || dbType == 120 || dbType == 20 || dbType == 100) {
                    return "current_time";
                }
                if (dbType == 70) {
                    return "now()";
                }
                if (dbType == 30) {
                    return "getdate()";
                }
                return "current_timestamp";
            }
            if ("java.time.localdate".equals(fieldMeta.getFieldType())) {
                if (dbType == 30) {
                    return "getdate()";
                }
                return "current_date";
            }
            return "current_timestamp";
        }
        return null;
    }

    static {
        sqlCommentfilters.put("'", "'");
        sqlCommentfilters.put("(", ")");
        sqlCommentfilters.put("{", "}");
    }
}

