/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.config.model.CurrentTimeMaxValue;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdUtil {
    protected static final Logger logger = LoggerFactory.getLogger(IdUtil.class);
    private static final int NANOTIME_IP_SUBSIZE = 3;
    private static String secureServerId = IdUtil.getLastIp(3);
    private static final String SQLTOY_ID = "SQLTOY_IDENTITY_8";
    private static final String SQLTOY_ID_SHORT = "SQLTOY_IDENTITY_6";
    private static ConcurrentHashMap<String, CurrentTimeMaxValue> tablesCurrentTimeId = new ConcurrentHashMap();

    private IdUtil() {
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static BigDecimal getShortNanoTimeId(String workerId) {
        return IdUtil.getShortNanoTimeId(SQLTOY_ID_SHORT, workerId);
    }

    public static BigDecimal getShortNanoTimeId(String identityName, String workerId) {
        String realIdentityName = StringUtil.isBlank(identityName) ? SQLTOY_ID_SHORT : identityName;
        long[] currentValue = IdUtil.getCurrentValue(realIdentityName, 999999);
        String nowTimeStr = StringUtil.addRightZero2Len("" + currentValue[0], 13);
        String currentId = StringUtil.addLeftZero2Len("" + currentValue[1] % 1000000L, 6);
        String serverId = StringUtil.addLeftZero2Len(workerId == null ? secureServerId : workerId, 3);
        return new BigDecimal(nowTimeStr.concat(currentId).concat(serverId));
    }

    public static BigDecimal getNanoTimeId(String workerId) {
        return IdUtil.getNanoTimeId(SQLTOY_ID, workerId);
    }

    public static BigDecimal getNanoTimeId(String identityName, String workerId) {
        String realIdentityName = StringUtil.isBlank(identityName) ? SQLTOY_ID : identityName;
        long[] currentValue = IdUtil.getCurrentValue(realIdentityName, 99999999);
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmssSSS");
        String nowTimeStr = df.format(new Date(currentValue[0]));
        String currentId = StringUtil.addLeftZero2Len("" + currentValue[1] % 100000000L, 8);
        String serverId = StringUtil.addLeftZero2Len(workerId == null ? secureServerId : workerId, 3);
        return new BigDecimal(nowTimeStr.concat(currentId).concat(serverId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getCurrentValue(String identityName, int maxValue) {
        String string = identityName.intern();
        synchronized (string) {
            long currentTime = System.currentTimeMillis();
            CurrentTimeMaxValue currentValue = tablesCurrentTimeId.get(identityName);
            if (null == currentValue) {
                currentValue = new CurrentTimeMaxValue(currentTime, 1L);
                tablesCurrentTimeId.put(identityName, currentValue);
            } else if (currentTime > currentValue.getCurrentTime()) {
                currentValue.setCurrentTime(currentTime);
                currentValue.setValue(1L);
            } else if (currentValue.getValue() >= (long)maxValue) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                currentValue.setCurrentTime(System.currentTimeMillis());
                currentValue.setValue(1L);
            } else {
                currentValue.setValue(currentValue.getValue() + 1L);
            }
            return new long[]{currentValue.getCurrentTime(), currentValue.getValue()};
        }
    }

    public static String getDebugId() {
        String nowTime = DateUtil.formatDate(new Date(), "HH:mm:ss");
        String nanoTime = "" + System.nanoTime();
        int length = nanoTime.length();
        nanoTime = nanoTime.endsWith("00") ? nanoTime.substring(length - 9, length - 2) : nanoTime.substring(length - 7);
        return nowTime.concat(".").concat(nanoTime);
    }

    public static List<String> getLocalAddress(boolean hasHostName, boolean hasIPV6) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterface = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netInterface.hasMoreElements()) {
                NetworkInterface ni = netInterface.nextElement();
                Enumeration<InetAddress> netCards = ni.getInetAddresses();
                while (netCards.hasMoreElements()) {
                    ip = netCards.nextElement();
                    if (ip.isLoopbackAddress() || !hasIPV6 && ip.getHostAddress().indexOf(":") != -1) continue;
                    if (hasHostName && !result.contains(ip.getHostName())) {
                        result.add(ip.getHostName());
                    }
                    result.add(ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636eip\u4ea7\u751fid\u6240\u4f9d\u8d56\u7684serverId\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u5f97ip\u4fe1\u606f:" + e.getMessage());
        }
        return result;
    }

    public static String getLastIp(int size) {
        List<String> ipaddress = IdUtil.getLocalAddress(false, false);
        boolean ipv6 = false;
        if (ipaddress == null || ipaddress.isEmpty()) {
            ipaddress = IdUtil.getLocalAddress(false, true);
            ipv6 = true;
        }
        String serverIdentity = null;
        if (ipaddress != null && !ipaddress.isEmpty()) {
            String ipLastNumStr = ipaddress.get(ipaddress.size() - 1);
            if (ipLastNumStr.indexOf("%") != -1) {
                ipLastNumStr = ipLastNumStr.substring(0, ipLastNumStr.indexOf("%"));
            }
            if ((ipLastNumStr = ipLastNumStr.replace(".", "").replace(":", "")).length() > size) {
                ipLastNumStr = ipLastNumStr.substring(ipLastNumStr.length() - size);
            }
            if ((serverIdentity = ipv6 ? Integer.toString(Integer.parseInt(ipLastNumStr, 16)) : ipLastNumStr).length() > size) {
                serverIdentity = serverIdentity.substring(serverIdentity.length() - size);
            }
            serverIdentity = StringUtil.addLeftZero2Len(ipLastNumStr, size);
        }
        if (serverIdentity == null) {
            return StringUtil.addLeftZero2Len("1", size);
        }
        return serverIdentity;
    }
}

