/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.fetch;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectLazySet;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.fetch.OObjectFetchContext;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OObjectFetchListener
implements OFetchListener {
    public void processStandardField(ODocument iRecord, Object iFieldValue, String iFieldName, OFetchContext iContext, Object iUserObject, String iFormat) throws OFetchException {
        if (iFieldValue instanceof ORecordLazyList) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OObjectLazyList(iRecord, (List<OIdentifiable>)((ORecordLazyList)iFieldValue), OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), iFieldName)));
        } else if (iFieldValue instanceof ORecordLazySet) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OObjectLazySet(iRecord, (Set<OIdentifiable>)((ORecordLazySet)iFieldValue), OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), iFieldName)));
        } else if (iFieldValue instanceof ORecordLazyMap) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OObjectLazyMap(iRecord, (Map<Object, OIdentifiable>)((ORecordLazyMap)iFieldValue), OObjectEntitySerializer.isCascadeDeleteField(iUserObject.getClass(), iFieldName)));
        } else {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, iFieldValue);
        }
    }

    public void processStandardCollectionValue(Object iFieldValue, OFetchContext iContext) throws OFetchException {
    }

    public void parseLinkedCollectionValue(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
    }

    public void parseLinked(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
        Class<?> type = OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
        if (type != null && !Map.class.isAssignableFrom(type)) {
            if (Set.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray()) {
                if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                    Object value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((OIdentifiable)((ODocument)iLinked), ((OObjectFetchContext)iContext).getFetchPlan());
                    if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                        Collection target = (Collection)OObjectSerializerHelper.getFieldValue(iUserObject, iFieldName);
                        target.add(value);
                        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
                    }
                }
                return;
            }
            if (iLinked instanceof ODocument && !((OObjectFetchContext)iContext).getObj2RecHandler().existsUserObjectByRID(iLinked.getIdentity())) {
                this.fetchLinked(iRootRecord, iUserObject, iFieldName, (ODocument)iLinked, iContext);
            }
        }
    }

    public Object fetchLinkedMapEntry(ODocument iRoot, Object iUserObject, String iFieldName, String iKey, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        Object value = null;
        Class<?> type = OObjectSerializerHelper.getFieldType(iLinked, ((OObjectFetchContext)iContext).getEntityManager());
        Class fieldClass = ((OObjectFetchContext)iContext).getEntityManager().getEntityClass(type.getSimpleName());
        if (fieldClass != null) {
            value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((OIdentifiable)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
        }
        return value;
    }

    public Object fetchLinkedCollectionValue(ODocument iRoot, Object iUserObject, String iFieldName, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        Object value = null;
        Class<?> fieldClass = OObjectSerializerHelper.getFieldType(iLinked, ((OObjectFetchContext)iContext).getEntityManager());
        if (fieldClass != null) {
            value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((OIdentifiable)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
            if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                Collection target = (Collection)OObjectSerializerHelper.getFieldValue(iUserObject, iFieldName);
                target.add(value);
                OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
            }
        }
        return value;
    }

    public Object fetchLinked(ODocument iRoot, Object iUserObject, String iFieldName, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        if (iUserObject == null) {
            return null;
        }
        Class<?> type = iLinked != null && iLinked instanceof ODocument ? OObjectSerializerHelper.getFieldType(iLinked, ((OObjectFetchContext)iContext).getEntityManager()) : OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
        if (type == null) {
            throw new OSerializationException("Linked type of field '" + iRoot.getClassName() + "." + iFieldName + "' is unknown. Probably needs to be registered with <db>.getEntityManager().registerEntityClasses(<package>) or <db>.getEntityManager().registerEntityClass(<class>) or the package cannot be loaded correctly due to a classpath problem. In this case register the single classes one by one.");
        }
        Object fieldValue = null;
        if (type.isEnum()) {
            String enumName = (String)iLinked.field(iFieldName);
            Class<?> enumClass = type;
            fieldValue = Enum.valueOf(enumClass, enumName);
        } else {
            Class fieldClass = ((OObjectFetchContext)iContext).getEntityManager().getEntityClass(type.getSimpleName());
            if (fieldClass != null && !((OObjectFetchContext)iContext).isLazyLoading()) {
                fieldValue = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((OIdentifiable)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
                OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, OObjectSerializerHelper.unserializeFieldValue(OObjectSerializerHelper.getFieldType(iUserObject, iFieldName), fieldValue));
            }
        }
        return fieldValue;
    }

    public void skipStandardField(ODocument iRecord, String iFieldName, OFetchContext iContext, Object iUserObject, String iFormat) throws OFetchException {
    }
}

