/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.object.OLazyObjectSetInterface;
import com.orientechnologies.orient.core.db.object.OObjectLazyMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OLazyCollectionUtil;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.db.OObjectLazyIterator;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.ProxyObject;

public class OObjectLazySet<TYPE>
extends HashSet<TYPE>
implements OLazyObjectSetInterface<TYPE>,
OObjectLazyMultivalueElement<Set<TYPE>>,
Serializable {
    private static final long serialVersionUID = 1793910544017627989L;
    private final ProxyObject sourceRecord;
    private final Set<OIdentifiable> underlying;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;
    private final boolean orphanRemoval;

    public OObjectLazySet(Object iSourceRecord, Set<OIdentifiable> iRecordSource, boolean orphanRemoval) {
        this.sourceRecord = iSourceRecord instanceof ProxyObject ? (ProxyObject)iSourceRecord : null;
        this.underlying = iRecordSource;
        this.orphanRemoval = orphanRemoval;
    }

    public OObjectLazySet(Object iSourceRecord, Set<OIdentifiable> iRecordSource, Set<? extends TYPE> iSourceCollection, boolean orphanRemoval) {
        this.sourceRecord = iSourceRecord instanceof ProxyObject ? (ProxyObject)iSourceRecord : null;
        this.underlying = iRecordSource;
        this.orphanRemoval = orphanRemoval;
        this.addAll((Collection<? extends TYPE>)iSourceCollection);
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectLazyIterator<TYPE>(this.getDatabase(), this.sourceRecord, !this.converted ? this.underlying.iterator() : super.iterator(), this.convertToRecord, this.orphanRemoval);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o) || this.underlying.contains(this.getDatabase().getRecordByUserObject(o, false));
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return super.toArray(a);
    }

    @Override
    public boolean add(TYPE e) {
        if (this.underlying != null && this.underlying.size() > 0 && !this.converted) {
            this.convertAllInternal();
        }
        if (this.converted && e instanceof ORID) {
            this.converted = false;
        }
        this.setDirty();
        boolean thisModified = super.add(e);
        if (thisModified) {
            ODocument record = this.getDatabase().getRecordByUserObject(e, false);
            if (this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
            }
            this.underlying.add((OIdentifiable)record);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        ODocument record = this.getDatabase().getRecordByUserObject(o, false);
        if (this.orphanRemoval && record != null && this.sourceRecord != null) {
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
        }
        boolean thisModified = super.remove(o);
        boolean underlyingModified = this.underlying.remove(record);
        return thisModified || underlyingModified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.convertAll();
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean modified = false;
        for (TYPE o : c) {
            modified |= this.add(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.setDirty();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        boolean modified = super.retainAll(c);
        HashSet<ODocument> toRetain = new HashSet<ODocument>();
        HashSet<OIdentifiable> toRemove = new HashSet<OIdentifiable>();
        for (Object o : c) {
            ODocument record = database.getRecordByUserObject(o, false);
            toRetain.add(record);
        }
        for (OIdentifiable underlyingRec : this.underlying) {
            if (toRetain.contains(underlyingRec) && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(underlyingRec.getIdentity());
                continue;
            }
            if (this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(underlyingRec.getIdentity());
            }
            toRemove.add(underlyingRec);
            modified = true;
        }
        this.underlying.removeAll(toRemove);
        toRemove.clear();
        toRetain.clear();
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
        if (this.orphanRemoval && this.sourceRecord != null) {
            for (OIdentifiable value : this.underlying) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(value.getIdentity());
            }
        }
        this.underlying.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setDirty();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        boolean modified = super.removeAll(c);
        for (Object o : c) {
            ODocument record = database.getRecordByUserObject(o, false);
            if (this.orphanRemoval && record != null && this.sourceRecord != null) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
            }
            if (this.underlying.remove(database.getRecordByUserObject(o, false))) continue;
            modified = true;
        }
        return modified;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public OObjectLazySet<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public String toString() {
        return super.size() == this.underlying.size() ? super.toString() : this.underlying.toString();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).setDirty();
        }
    }

    public void detach() {
        this.convertAll();
    }

    public void detach(boolean nonProxiedInstance) {
        this.convertAll();
    }

    public void detachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached) {
        this.convertAndDetachAll(nonProxiedInstance, alreadyDetached);
    }

    public Set<TYPE> getNonOrientInstance() {
        HashSet set = new HashSet();
        set.addAll(this);
        return set;
    }

    public Object getUnderlying() {
        return this.underlying;
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        HashSet<OIdentifiable> copy = new HashSet<OIdentifiable>(this.underlying);
        super.clear();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object e : copy) {
            if (e == null) continue;
            if (e instanceof ORID) {
                this.add(database.getUserObjectByRecord((OIdentifiable)((ODatabaseDocument)this.getDatabase().getUnderlying()).load((ORID)e, this.fetchPlan), this.fetchPlan));
                continue;
            }
            if (e instanceof ODocument) {
                this.add(database.getUserObjectByRecord((OIdentifiable)((ORecord)e), this.fetchPlan));
                continue;
            }
            this.add((TYPE)e);
        }
        this.converted = true;
    }

    protected void convertAllInternal() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        HashSet<OIdentifiable> copy = new HashSet<OIdentifiable>(this.underlying);
        super.clear();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object e : copy) {
            if (e == null) continue;
            if (e instanceof ORID) {
                super.add(database.getUserObjectByRecord((OIdentifiable)((ODatabaseDocument)this.getDatabase().getUnderlying()).load((ORID)e, this.fetchPlan), this.fetchPlan));
                continue;
            }
            if (e instanceof ODocument) {
                super.add(database.getUserObjectByRecord((OIdentifiable)((ORecord)e), this.fetchPlan));
                continue;
            }
            super.add(e);
        }
        this.converted = true;
    }

    protected void convertAndDetachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        HashSet<OIdentifiable> copy = new HashSet<OIdentifiable>(this.underlying);
        super.clear();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object e : copy) {
            if (e == null) continue;
            if (e instanceof ORID) {
                TYPE TYPE2 = database.getUserObjectByRecord((OIdentifiable)((ODatabaseDocument)this.getDatabase().getUnderlying()).load((ORID)e, this.fetchPlan), this.fetchPlan);
                super.add(((OObjectDatabaseTx)this.getDatabase()).detachAll(TYPE2, nonProxiedInstance, alreadyDetached));
                continue;
            }
            if (e instanceof ODocument) {
                TYPE TYPE3 = database.getUserObjectByRecord((OIdentifiable)((ORecord)e), this.fetchPlan);
                super.add(((OObjectDatabaseTx)this.getDatabase()).detachAll(TYPE3, nonProxiedInstance, alreadyDetached));
                continue;
            }
            this.add((TYPE)e);
        }
        this.converted = true;
    }

    protected ODatabasePojoAbstract<TYPE> getDatabase() {
        return OLazyCollectionUtil.getDatabase();
    }
}

