/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.manager;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.OLuceneIndexType;
import com.orientechnologies.lucene.collections.LuceneResultSet;
import com.orientechnologies.lucene.collections.OFullTextCompositeKey;
import com.orientechnologies.lucene.manager.OLuceneFacetManager;
import com.orientechnologies.lucene.manager.OLuceneIndexManagerAbstract;
import com.orientechnologies.lucene.query.QueryContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class OLuceneFullTextIndexManager
extends OLuceneIndexManagerAbstract {
    protected OLuceneFacetManager facetManager;

    @Override
    public IndexWriter createIndexWriter(Directory directory, ODocument metadata) throws IOException {
        Analyzer analyzer = this.getAnalyzer(metadata);
        Version version = this.getLuceneVersion(metadata);
        IndexWriterConfig iwc = new IndexWriterConfig(version, analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.facetManager = new OLuceneFacetManager(this, metadata);
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return new IndexWriter(directory, iwc);
    }

    @Override
    public IndexWriter openIndexWriter(Directory directory, ODocument metadata) throws IOException {
        Analyzer analyzer = this.getAnalyzer(metadata);
        Version version = this.getLuceneVersion(metadata);
        IndexWriterConfig iwc = new IndexWriterConfig(version, analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        OLogManager.instance().debug((Object)this, "Opening Lucene index in '%s'...", new Object[]{directory});
        return new IndexWriter(directory, iwc);
    }

    public void init() {
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        return false;
    }

    public Object get(Object key) {
        Query q = null;
        try {
            q = OLuceneIndexType.createFullQuery(this.index, key, this.mgrWriter.getIndexWriter().getAnalyzer(), this.getLuceneVersion(this.metadata));
            OCommandContext context = null;
            if (key instanceof OFullTextCompositeKey) {
                context = ((OFullTextCompositeKey)((Object)key)).getContext();
            }
            return this.getResults(q, context, key);
        }
        catch (ParseException e) {
            throw new OIndexEngineException("Error parsing lucene query ", (Throwable)e);
        }
    }

    public void put(Object key, Object value) {
        Set container = (Set)value;
        for (OIdentifiable oIdentifiable : container) {
            Document doc = new Document();
            doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            int i = 0;
            if (this.index.isAutomatic()) {
                for (String f : this.index.getFields()) {
                    Object val = null;
                    if (key instanceof OCompositeKey) {
                        val = ((OCompositeKey)key).getKeys().get(i);
                        ++i;
                    } else {
                        val = key;
                    }
                    if (val == null) continue;
                    if (this.facetManager.supportsFacets().booleanValue() && this.facetManager.isFacetField(f)) {
                        doc.add(this.facetManager.buildFacetField(f, val));
                        continue;
                    }
                    if (this.isToStore(f).equals((Object)Field.Store.YES)) {
                        doc.add((IndexableField)OLuceneIndexType.createField(f + "_STORED", val, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                    }
                    doc.add((IndexableField)OLuceneIndexType.createField(f, val, Field.Store.NO, Field.Index.ANALYZED));
                }
            } else {
                int k;
                Collection keys;
                Object val = null;
                if (key instanceof OCompositeKey) {
                    keys = ((OCompositeKey)key).getKeys();
                    k = 0;
                    for (Object o : keys) {
                        doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.NO, Field.Index.ANALYZED));
                        ++k;
                    }
                } else if (key instanceof Collection) {
                    keys = (Collection)key;
                    k = 0;
                    for (Object o : keys) {
                        doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.NO, Field.Index.ANALYZED));
                        ++k;
                    }
                } else {
                    val = key;
                    doc.add((IndexableField)OLuceneIndexType.createField("k0", val, Field.Store.NO, Field.Index.ANALYZED));
                }
            }
            if (this.facetManager.supportsFacets().booleanValue()) {
                try {
                    this.addDocument(this.facetManager.buildDocument(doc));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.addDocument(doc);
            }
            this.facetManager.commit();
            if (this.index.isAutomatic()) continue;
            this.commit();
        }
    }

    private Set<OIdentifiable> getResults(Query query, OCommandContext context, Object key) {
        try {
            IndexSearcher searcher = this.getSearcher();
            QueryContext queryContext = new QueryContext(context, searcher, query);
            if (this.facetManager.supportsFacets().booleanValue()) {
                this.facetManager.addFacetContext(queryContext, key);
            }
            return new LuceneResultSet(this, queryContext);
        }
        catch (IOException e) {
            throw new OIndexException("Error reading from Lucene index", (Throwable)e);
        }
    }

    @Override
    public void onRecordAddedToResultSet(QueryContext queryContext, OContextualRecordId recordId, Document ret, final ScoreDoc score) {
        recordId.setContext((Map)new HashMap<String, Object>(){
            {
                this.put("score", Float.valueOf(score.score));
            }
        });
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new LuceneIndexCursor((LuceneResultSet)this.get(rangeFrom), rangeFrom);
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return null;
    }

    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){

            public Object next(int prefetchSize) {
                return null;
            }
        };
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        return this.build(this.index, key, value, this.metadata);
    }

    @Override
    public Query buildQuery(Object query) throws ParseException {
        return OLuceneIndexType.createFullQuery(this.index, query, this.mgrWriter.getIndexWriter().getAnalyzer(), this.getLuceneVersion(this.metadata));
    }

    @Override
    public Analyzer analyzer(String field) {
        return this.getAnalyzer(this.metadata);
    }

    protected Document build(OIndexDefinition definition, Object key, OIdentifiable value, ODocument metadata) {
        Document doc = new Document();
        int i = 0;
        if (value != null) {
            doc.add((IndexableField)OLuceneIndexType.createField("RID", value.getIdentity().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        List<Object> formattedKey = this.formatKeys(definition, key);
        for (String f : definition.getFields()) {
            Object val = formattedKey.get(i);
            ++i;
            if (val == null) continue;
            doc.add((IndexableField)OLuceneIndexType.createField(f, val, Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    private List<Object> formatKeys(OIndexDefinition definition, Object key) {
        ArrayList<Object> keys;
        if (key instanceof OCompositeKey) {
            keys = ((OCompositeKey)key).getKeys();
        } else if (key instanceof List) {
            keys = (List)key;
        } else {
            keys = new ArrayList<Object>();
            keys.add(key);
        }
        for (int i = keys.size(); i < definition.getFields().size(); ++i) {
            keys.add("");
        }
        return keys;
    }

    @Override
    public void delete() {
        super.delete();
        this.facetManager.delete();
    }

    public class LuceneIndexCursor
    implements OIndexCursor {
        private final Object key;
        private LuceneResultSet resultSet;
        private Iterator<OIdentifiable> iterator;

        public LuceneIndexCursor(LuceneResultSet resultSet, Object key) {
            this.resultSet = resultSet;
            this.iterator = resultSet.iterator();
            this.key = key;
        }

        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.iterator.hasNext()) {
                final OIdentifiable next = this.iterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return LuceneIndexCursor.this.key;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return next;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        return null;
                    }
                };
            }
            return null;
        }

        public Set<OIdentifiable> toValues() {
            return null;
        }

        public Set<Map.Entry<Object, OIdentifiable>> toEntries() {
            return null;
        }

        public Set<Object> toKeys() {
            return null;
        }

        public void setPrefetchSize(int prefetchSize) {
        }

        public boolean hasNext() {
            return false;
        }

        public OIdentifiable next() {
            return null;
        }

        public void remove() {
        }
    }
}

