/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.lucene.manager.OLuceneIndexManagerAbstract;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class OLuceneIndexEngine<V>
extends OSharedResourceAdaptiveExternal
implements OIndexEngine<V> {
    private final String indexType;
    protected OLuceneIndexManagerAbstract lucene;
    protected OIndex indexManaged;
    private ODocument indexMetadata;

    public OLuceneIndexEngine(OLuceneIndexManagerAbstract delegate, String indexType) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        this.lucene = delegate;
        this.indexType = indexType;
    }

    public void init() {
        this.lucene.init();
    }

    public void flush() {
        this.lucene.flush();
    }

    public void create(OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.lucene.createIndex(indexDefinition, clusterIndexName, valueSerializer, isAutomatic, this.indexMetadata);
    }

    public void delete() {
        this.lucene.delete();
    }

    public void deleteWithoutLoad(String indexName) {
        this.lucene.deleteWithoutLoad(indexName);
    }

    public void load(String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.lucene.load(indexName, indexDefinition, isAutomatic, this.indexMetadata);
    }

    public boolean contains(Object key) {
        return this.lucene.contains(key);
    }

    public boolean remove(Object key) {
        return this.lucene.remove(key);
    }

    public boolean remove(Object key, OIdentifiable value) {
        OIdentifiable rid = value;
        if (value instanceof ODocument) {
            rid = value.getIdentity();
        }
        return this.lucene.remove(key, rid);
    }

    public void clear() {
        this.lucene.clear();
    }

    public void close() {
        this.lucene.close();
    }

    public V get(Object key) {
        return (V)this.lucene.get(key);
    }

    public void put(Object key, V value) {
        this.lucene.put(key, value);
    }

    public Object getFirstKey() {
        return this.lucene.getFirstKey();
    }

    public Object getLastKey() {
        return this.lucene.getLastKey();
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        return this.lucene.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        return this.lucene.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    public void commit() {
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        return this.lucene.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        return this.lucene.cursor(valuesTransformer);
    }

    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        return null;
    }

    public OIndexKeyCursor keyCursor() {
        return this.lucene.keyCursor();
    }

    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        return this.lucene.size(transformer);
    }

    public boolean hasRangeQuerySupport() {
        return this.lucene.hasRangeQuerySupport();
    }

    public int getVersion() {
        return 1;
    }

    public void setManagedIndex(OIndex index) {
        this.indexManaged = index;
    }

    public void setIndexMetadata(ODocument indexMetadata) {
        this.indexMetadata = indexMetadata;
    }

    public ODocument getIndexMetadata() {
        return this.indexMetadata;
    }

    public void setRebuilding(boolean rebuilding) {
        this.lucene.setRebuilding(rebuilding);
    }

    public IndexSearcher searcher() throws IOException {
        return this.lucene.getSearcher();
    }

    public void setIndexName(String indexName) {
        this.lucene.setIndexName(indexName);
    }

    public Document buildDocument(Object key, OIdentifiable value) {
        return this.lucene.buildDocument(key, value);
    }

    public Query buildQuery(Object query) throws ParseException {
        return this.lucene.buildQuery(query);
    }

    public Analyzer analyzer(String field) {
        return this.lucene.analyzer(field);
    }
}

