/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OCharSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;

public class OStringSerializer
implements OBinarySerializer<String> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final OStringSerializer INSTANCE = new OStringSerializer();
    public static final byte ID = 13;

    @Override
    public int getObjectSize(String object) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int length = object.length();
        OIntegerSerializer.INSTANCE.serialize(length, stream, startPosition);
        for (int i = 0; i < length; ++i) {
            charSerializer.serialize(Character.valueOf(object.charAt(i)), stream, startPosition + 4 + i * 2);
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int len = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(charSerializer.deserialize(stream, startPosition + 4 + i * 2));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) * 2 + 4;
    }

    @Override
    public void serializeNative(String object, byte[] stream, int startPosition) {
        int length = object.length();
        CONVERTER.putInt(stream, startPosition, length);
        int pos = startPosition + 4;
        for (int i = 0; i < length; ++i) {
            char strChar = object.charAt(i);
            CONVERTER.putChar(stream, pos, strChar);
            pos += 2;
        }
    }

    @Override
    public String deserializeNative(byte[] stream, int startPosition) {
        int len = CONVERTER.getInt(stream, startPosition);
        char[] buffer = new char[len];
        int pos = startPosition + 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = CONVERTER.getChar(stream, pos);
            pos += 2;
        }
        return new String(buffer);
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }
}

