/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public abstract class AbstractEntryIterator<K, V, T>
implements OLazyIterator<T> {
    OMVRBTree<K, V> tree;
    OMVRBTreeEntry<K, V> next;
    OMVRBTreeEntry<K, V> lastReturned;
    int expectedModCount;
    int pageIndex;

    AbstractEntryIterator(OMVRBTreeEntry<K, V> start) {
        if (start == null) {
            return;
        }
        this.tree = start.getTree();
        this.next = start;
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
        this.pageIndex = start.getTree().getPageIndex() - 1;
    }

    @Override
    public boolean hasNext() {
        if (this.tree != null && this.expectedModCount != this.tree.modCount) {
            --this.pageIndex;
            this.expectedModCount = this.tree.modCount;
        }
        return this.next != null && (this.pageIndex < this.next.getSize() - 1 || OMVRBTree.successor(this.next) != null);
    }

    public final boolean hasPrevious() {
        if (this.tree != null && this.expectedModCount != this.tree.modCount) {
            this.pageIndex = -1;
            this.expectedModCount = this.tree.modCount;
        }
        return this.next != null && (this.pageIndex > 0 || OMVRBTree.predecessor(this.next) != null);
    }

    final K nextKey() {
        return this.nextEntry().getKey(this.pageIndex);
    }

    final V nextValue() {
        return this.nextEntry().getValue(this.pageIndex);
    }

    final V prevValue() {
        return this.prevEntry().getValue(this.pageIndex);
    }

    final OMVRBTreeEntry<K, V> nextEntry() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        if (this.pageIndex < this.next.getSize() - 1) {
            ++this.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.successor(this.next);
            this.pageIndex = 0;
        }
        this.lastReturned = this.next;
        this.tree.pageIndex = this.pageIndex;
        return this.next;
    }

    final OMVRBTreeEntry<K, V> prevEntry() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.predecessor(this.next);
            this.pageIndex = this.next != null ? this.next.getSize() - 1 : -1;
        }
        this.lastReturned = this.next;
        return this.next;
    }

    @Override
    public T update(T iValue) {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.tree.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        this.tree.pageIndex = this.pageIndex;
        return this.next.setValue(iValue);
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.tree.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastReturned.getLeft() != null && this.lastReturned.getRight() != null) {
            this.next = this.lastReturned;
        }
        this.tree.pageIndex = this.pageIndex--;
        this.next = this.tree.deleteEntry(this.lastReturned);
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
    }
}

