/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.pdfboxout.PdfBoxFastLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.MarkerData;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkedContentReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDObjectReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDMarkedContent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.w3c.dom.Document;

public class PdfBoxAccessibilityHelper {
    private final Map<PDPage, PageItems> _pageItemsMap = new LinkedHashMap<PDPage, PageItems>();
    private final PdfBoxFastOutputDevice _od;
    private final Box _rootBox;
    private final Document _doc;
    private final GenericStructualElement _root;
    private static final Map<String, Supplier<AbstractStructualElement>> _tagSuppliers = PdfBoxAccessibilityHelper.createTagSuppliers();
    private int _nextMcid;
    private PageItems _pageItems;
    private PdfContentStreamAdapter _cs;
    private RenderingContext _ctx;
    private PDPage _page;
    private float _pageHeight;
    private AffineTransform _transform;
    private int _runningLevel;
    private static final Token TRUE_TOKEN = new Token();
    private static final Token FALSE_TOKEN = new Token();
    private static final Token INSIDE_RUNNING = new Token();
    private static final Token STARTING_RUNNING = new Token();
    private static final Token NESTED_RUNNING = new Token();

    private static Map<String, Supplier<AbstractStructualElement>> createTagSuppliers() {
        HashMap<String, Supplier<AbstractStructualElement>> suppliers = new HashMap<String, Supplier<AbstractStructualElement>>();
        suppliers.put("ul", () -> new ListStructualElement());
        suppliers.put("ol", () -> new ListStructualElement());
        suppliers.put("li", ListItemStructualElement::new);
        suppliers.put("table", () -> new TableStructualElement());
        suppliers.put("tr", () -> new TableRowStructualElement());
        suppliers.put("td", () -> new TableCellStructualElement());
        suppliers.put("th", () -> new TableHeaderStructualElement());
        suppliers.put("a", () -> new AnchorStuctualElement());
        suppliers.put("abbr", () -> new AbbrStuctualElement());
        return suppliers;
    }

    public PdfBoxAccessibilityHelper(PdfBoxFastOutputDevice od, Box root, Document doc) {
        this._od = od;
        this._rootBox = root;
        this._doc = doc;
        this._root = new GenericStructualElement();
        this._root.box = root;
        root.setAccessiblityObject((Object)this._root);
    }

    private static void logIncompatibleChild(AbstractTreeItem parent, AbstractTreeItem child, Class<?> expected) {
        XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId3Param)LogMessageId.LogMessageId3Param.GENERAL_PDF_ACCESSIBILITY_INCOMPATIBLE_CHILD, (Object)child.getClass().getSimpleName(), (Object)parent.getClass().getSimpleName(), (Object)expected.getSimpleName());
    }

    public static PDStructureElement getStructualElementForBox(Box targetBox) {
        if (targetBox != null && targetBox.getAccessibilityObject() != null && targetBox.getAccessibilityObject() instanceof AbstractStructualElement) {
            return ((AbstractStructualElement)targetBox.getAccessibilityObject()).elem;
        }
        return null;
    }

    public void finishPdfUa() {
        PDStructureTreeRoot root = this._od.getWriter().getDocumentCatalog().getStructureTreeRoot();
        if (root == null) {
            root = new PDStructureTreeRoot();
            HashMap<String, String> roleMap = new HashMap<String, String>();
            roleMap.put("Annotation", "Span");
            roleMap.put("Artifact", "P");
            roleMap.put("Bibliography", "BibEntry");
            roleMap.put("Chart", "Figure");
            roleMap.put("Diagram", "Figure");
            roleMap.put("DropCap", "Figure");
            roleMap.put("EndNote", "Note");
            roleMap.put("FootNote", "Note");
            roleMap.put("InlineShape", "Figure");
            roleMap.put("Outline", "Span");
            roleMap.put("Strikeout", "Span");
            roleMap.put("Subscript", "Span");
            roleMap.put("Superscript", "Span");
            roleMap.put("Underline", "Span");
            root.setRoleMap(roleMap);
            PDStructureElement rootElem = new PDStructureElement("Document", null);
            String lang = this._doc.getDocumentElement().getAttribute("lang");
            rootElem.setLanguage(lang.isEmpty() ? "EN-US" : lang);
            root.appendKid(rootElem);
            this._root.elem = rootElem;
            PdfBoxAccessibilityHelper.finishTreeItems(this._root.children, this._root);
            this._od.getWriter().getDocumentCatalog().setStructureTreeRoot(root);
        }
    }

    public void finishNumberTree() {
        COSArray numTree = new COSArray();
        int i = 0;
        for (Map.Entry<PDPage, PageItems> entry : this._pageItemsMap.entrySet()) {
            List<GenericContentItem> pageItems = entry.getValue()._contentItems;
            List<AnnotationWithStructureParent> pageAnnotations = entry.getValue()._pageAnnotations;
            COSArray mcidParentReferences = new COSArray();
            for (GenericContentItem contentItem : pageItems) {
                mcidParentReferences.add((COSObjectable)contentItem.parentElem);
            }
            numTree.add((COSBase)COSInteger.get((long)i));
            numTree.add((COSBase)mcidParentReferences);
            entry.getKey().getCOSObject().setItem(COSName.STRUCT_PARENTS, (COSBase)COSInteger.get((long)i));
            entry.getKey().getCOSObject().setItem(COSName.getPDFName((String)"Tabs"), (COSBase)COSName.S);
            ++i;
            for (AnnotationWithStructureParent annot : pageAnnotations) {
                numTree.add((COSBase)COSInteger.get((long)i));
                numTree.add((COSObjectable)annot.structureParent);
                annot.annotation.setStructParent(i);
                ++i;
            }
        }
        COSDictionary dict = new COSDictionary();
        dict.setItem(COSName.NUMS, (COSBase)numTree);
        PDNumberTreeNode numberTreeNode = new PDNumberTreeNode(dict, dict.getClass());
        this._od.getWriter().getDocumentCatalog().getStructureTreeRoot().setParentTreeNextKey(i);
        this._od.getWriter().getDocumentCatalog().getStructureTreeRoot().setParentTree(numberTreeNode);
    }

    private static String guessBoxTag(Box box) {
        if (box instanceof BlockBox) {
            BlockBox block = (BlockBox)box;
            if (block.isInline()) {
                return "Span";
            }
            return "Div";
        }
        return "Span";
    }

    private static void finishTreeItems(List<? extends AbstractTreeItem> children, AbstractStructualElement parent) {
        for (AbstractTreeItem abstractTreeItem : children) {
            abstractTreeItem.finish(parent);
        }
    }

    private static void finishTreeItem(AbstractTreeItem item, AbstractStructualElement parent) {
        item.finish(parent);
    }

    private COSDictionary createMarkedContentDictionary() {
        COSDictionary dict = new COSDictionary();
        dict.setInt(COSName.MCID, this._nextMcid);
        ++this._nextMcid;
        return dict;
    }

    private void ensureAncestorTree(AbstractTreeItem child, Box parent) {
        while (parent != null && parent.getAccessibilityObject() == null) {
            AbstractStructualElement parentItem = this.createStructureItem(null, parent);
            parent.setAccessiblityObject((Object)parentItem);
            parentItem.addChild(child);
            child.parent = parentItem;
            child = parentItem;
            parent = parent.getParent();
        }
    }

    private AbstractStructualElement createStructureItem(StructureType type, Box box) {
        String htmlTag;
        Supplier<AbstractStructualElement> supplier;
        BlockBox bb;
        AbstractStructualElement child = null;
        if (box instanceof BlockBox && (bb = (BlockBox)box).isReplaced()) {
            Rectangle2D rect = PdfBoxFastLinkManager.createTargetArea(this._ctx, box, this._pageHeight, this._transform, this._rootBox, this._od);
            child = new FigureStructualElement();
            ((FigureStructualElement)child).boundingBox = new PDRectangle((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getWidth(), (float)rect.getHeight());
        }
        if (child == null && box.getElement() != null && !box.isAnonymous() && (supplier = _tagSuppliers.get(htmlTag = box.getElement().getTagName())) != null) {
            child = supplier.get();
        }
        if (child == null && box.getParent() != null && box.getParent().getAccessibilityObject() instanceof TableStructualElement) {
            TableStructualElement table = (TableStructualElement)box.getParent().getAccessibilityObject();
            table.setPdfVersion(this._od.getWriter().getVersion());
            if (box.getStyle().isIdent(CSSName.DISPLAY, IdentValue.TABLE_HEADER_GROUP)) {
                child = table.thead;
            } else if (box.getStyle().isIdent(CSSName.DISPLAY, IdentValue.TABLE_ROW_GROUP)) {
                child = new TableBodyStructualElement();
            } else if (box.getStyle().isIdent(CSSName.DISPLAY, IdentValue.TABLE_FOOTER_GROUP)) {
                child = table.tfoot;
            }
        }
        if (child == null) {
            child = new GenericStructualElement();
        }
        child.page = this._page;
        child.box = box;
        child.setPdfVersion(this._od.getWriter().getVersion());
        return child;
    }

    private void setupStructureElement(AbstractStructualElement child, Box box) {
        box.setAccessiblityObject((Object)child);
        this.ensureAncestorTree(child, box.getParent());
        this.ensureParent(box, child);
    }

    private void ensureParent(Box box, AbstractTreeItem child) {
        if (child.parent == null) {
            if (child instanceof TableHeadStructualElement || child instanceof TableFootStructualElement) {
                child.parent = (TableStructualElement)box.getParent().getAccessibilityObject();
            } else if (child instanceof TableBodyStructualElement) {
                child.parent = (TableStructualElement)box.getParent().getAccessibilityObject();
                ((TableStructualElement)child.parent).tbodies.add((TableBodyStructualElement)child);
            } else if (box.getParent() != null) {
                AbstractStructualElement parent = (AbstractStructualElement)box.getParent().getAccessibilityObject();
                parent.addChild(child);
                child.parent = parent;
            } else {
                this._root.children.add(child);
                child.parent = this._root;
            }
        }
    }

    private GenericContentItem createMarkedContentStructureItem(StructureType type, Box box) {
        GenericContentItem current = new GenericContentItem();
        this.ensureAncestorTree(current, box.getParent());
        AbstractStructualElement parent = (AbstractStructualElement)box.getAccessibilityObject();
        parent.addChild(current);
        current.parent = parent;
        current.mcid = this._nextMcid;
        current.dict = this.createMarkedContentDictionary();
        current.page = this._page;
        this._pageItems._contentItems.add(current);
        return current;
    }

    private GenericContentItem createListItemLabelMarkedContent(StructureType type, Box box) {
        GenericContentItem current = new GenericContentItem();
        current.mcid = this._nextMcid;
        current.dict = this.createMarkedContentDictionary();
        current.page = this._page;
        ListItemStructualElement li = (ListItemStructualElement)box.getAccessibilityObject();
        li.label.addChild(current);
        current.parent = li.label;
        this._pageItems._contentItems.add(current);
        return current;
    }

    private FigureContentItem createFigureContentStructureItem(StructureType type, Box box) {
        FigureStructualElement parent = (FigureStructualElement)box.getAccessibilityObject();
        if (parent == null || parent.content != null) {
            return null;
        }
        FigureContentItem current = new FigureContentItem();
        this.ensureAncestorTree(current, box.getParent());
        current.parent = parent;
        current.mcid = this._nextMcid;
        current.dict = this.createMarkedContentDictionary();
        current.page = this._page;
        parent.content = current;
        this._pageItems._contentItems.add(current);
        return current;
    }

    private COSDictionary createBackgroundArtifact(StructureType type, Box box) {
        Rectangle2D rect = PdfBoxFastLinkManager.createTargetArea(this._ctx, box, this._pageHeight, this._transform, this._rootBox, this._od);
        PDRectangle pdRect = new PDRectangle((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getWidth(), (float)rect.getHeight());
        COSDictionary dict = new COSDictionary();
        dict.setItem(COSName.TYPE, (COSBase)COSName.BACKGROUND);
        dict.setItem(COSName.BBOX, (COSObjectable)pdRect);
        return dict;
    }

    private COSDictionary createPaginationArtifact(StructureType type, Box box) {
        COSDictionary dict = new COSDictionary();
        dict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"Pagination"));
        return dict;
    }

    public Token startStructure(StructureType type, Box box) {
        if (type == StructureType.RUNNING) {
            if (this._runningLevel == 0) {
                ++this._runningLevel;
                COSDictionary run = this.createPaginationArtifact(type, box);
                this._cs.beginMarkedContent(COSName.ARTIFACT, run);
                return STARTING_RUNNING;
            }
            ++this._runningLevel;
            return NESTED_RUNNING;
        }
        if (this._runningLevel > 0) {
            return INSIDE_RUNNING;
        }
        switch (type) {
            case LAYER: 
            case FLOAT: 
            case BLOCK: 
            case INLINE: 
            case INLINE_CHILD_BOX: {
                AbstractStructualElement struct = (AbstractStructualElement)box.getAccessibilityObject();
                if (struct == null) {
                    struct = this.createStructureItem(type, box);
                    this.setupStructureElement(struct, box);
                }
                return FALSE_TOKEN;
            }
            case BACKGROUND: {
                if (box.hasNonTextContent((CssContext)this._ctx)) {
                    COSDictionary current = this.createBackgroundArtifact(type, box);
                    this._cs.beginMarkedContent(COSName.ARTIFACT, current);
                    return TRUE_TOKEN;
                }
                return FALSE_TOKEN;
            }
            case LIST_MARKER: {
                MarkerData markers;
                if (box instanceof BlockBox && ((markers = ((BlockBox)box).getMarkerData()) == null || markers.getGlyphMarker() == null && markers.getTextMarker() == null && markers.getImageMarker() == null)) {
                    return FALSE_TOKEN;
                }
                GenericContentItem current = this.createListItemLabelMarkedContent(type, box);
                this._cs.beginMarkedContent(COSName.getPDFName((String)"Span"), current.dict);
                return TRUE_TOKEN;
            }
            case TEXT: {
                GenericContentItem current = this.createMarkedContentStructureItem(type, box);
                this._cs.beginMarkedContent(COSName.getPDFName((String)"Span"), current.dict);
                return TRUE_TOKEN;
            }
            case REPLACED: {
                FigureContentItem current;
                AbstractStructualElement struct = (AbstractStructualElement)box.getAccessibilityObject();
                if (struct == null) {
                    struct = this.createStructureItem(type, box);
                    this.setupStructureElement(struct, box);
                }
                if ((current = this.createFigureContentStructureItem(type, box)) != null) {
                    this._cs.beginMarkedContent(COSName.getPDFName((String)"Figure"), current.dict);
                    return TRUE_TOKEN;
                }
                COSDictionary bg = this.createBackgroundArtifact(type, box);
                this._cs.beginMarkedContent(COSName.ARTIFACT, bg);
                return TRUE_TOKEN;
            }
        }
        return FALSE_TOKEN;
    }

    public void endStructure(Object token) {
        Token value = (Token)token;
        if (value == TRUE_TOKEN) {
            this._cs.endMarkedContent();
        } else if (value != FALSE_TOKEN && value != INSIDE_RUNNING) {
            if (value == NESTED_RUNNING) {
                --this._runningLevel;
            } else if (value == STARTING_RUNNING) {
                --this._runningLevel;
                this._cs.endMarkedContent();
            }
        }
    }

    public void startPage(PDPage page, PdfContentStreamAdapter cs, RenderingContext ctx, float pageHeight, AffineTransform transform) {
        this._cs = cs;
        this._ctx = ctx;
        this._nextMcid = 0;
        this._page = page;
        this._pageHeight = pageHeight;
        this._transform = transform;
        this._pageItems = new PageItems();
        this._pageItemsMap.put(page, this._pageItems);
    }

    public void endPage() {
    }

    public void addLink(Box anchor, Box target, PDAnnotationLink annotation, PDPage page) {
        PDStructureElement struct = PdfBoxAccessibilityHelper.getStructualElementForBox(anchor);
        if (struct != null) {
            PDObjectReference ref = new PDObjectReference();
            ref.setReferencedObject((PDAnnotation)annotation);
            struct.appendKid(ref);
            AnnotationWithStructureParent annotStructParentPair = new AnnotationWithStructureParent();
            annotStructParentPair.annotation = annotation;
            annotStructParentPair.structureParent = struct;
            this._pageItems._pageAnnotations.add(annotStructParentPair);
        }
    }

    private static abstract class AbstractTreeItem {
        AbstractStructualElement parent;

        private AbstractTreeItem() {
        }

        abstract void finish(AbstractStructualElement var1);
    }

    private static abstract class AbstractStructualElement
    extends AbstractTreeItem {
        Box box;
        PDStructureElement elem;
        PDStructureElement parentElem;
        PDPage page;

        private AbstractStructualElement() {
        }

        abstract void addChild(AbstractTreeItem var1);

        abstract String getPdfTag();

        void createPdfStrucureElement(AbstractStructualElement parent, AbstractStructualElement child) {
            child.parentElem = parent.elem;
            child.elem = new PDStructureElement(child.getPdfTag(), (PDStructureNode)child.parentElem);
            child.elem.setParent((PDStructureNode)child.parentElem);
            child.elem.setPage(child.page);
            child.parentElem.appendKid(child.elem);
        }

        void handleGlobalAttributes() {
            this.handleLangAttribute();
            this.handleTitleAttribute();
        }

        void handleLangAttribute() {
            String lang;
            if (this.box != null && this.box.getElement() != null && !(lang = this.box.getElement().getAttribute("lang")).isEmpty()) {
                this.elem.setLanguage(lang);
            }
        }

        void handleTitleAttribute() {
            String alternate;
            if (this.box != null && this.box.getElement() != null && !(alternate = this.box.getElement().getAttribute("title")).isEmpty()) {
                this.elem.setAlternateDescription(alternate);
            }
        }

        void setPdfVersion(float version) {
        }

        void setAttributeDictionary(COSDictionary attrDict) {
            this.elem.getCOSObject().setItem(COSName.A, (COSBase)attrDict);
        }

        public String toString() {
            return String.format("[Structual Element-%s:%s]", super.toString(), this.box);
        }
    }

    private static class GenericStructualElement
    extends AbstractStructualElement {
        final List<AbstractTreeItem> children = new ArrayList<AbstractTreeItem>();

        private GenericStructualElement() {
        }

        @Override
        String getPdfTag() {
            return this.chooseTag(this.box);
        }

        @Override
        void addChild(AbstractTreeItem child) {
            this.children.add(child);
        }

        private String chooseTag(Box box) {
            if (box != null) {
                if (box.getLayer() != null) {
                    return "Sect";
                }
                if (box.isAnonymous()) {
                    return PdfBoxAccessibilityHelper.guessBoxTag(box);
                }
                if (box.getElement() != null) {
                    String htmlTag = box.getElement().getTagName();
                    if (htmlTag.equals("p")) {
                        return "P";
                    }
                    if (htmlTag.equals("h1")) {
                        return "H1";
                    }
                    if (htmlTag.equals("h2")) {
                        return "H2";
                    }
                    if (htmlTag.equals("h3")) {
                        return "H3";
                    }
                    if (htmlTag.equals("h4")) {
                        return "H4";
                    }
                    if (htmlTag.equals("h5")) {
                        return "H5";
                    }
                    if (htmlTag.equals("h6")) {
                        return "H6";
                    }
                    if (htmlTag.equals("article")) {
                        return "Art";
                    }
                }
                return PdfBoxAccessibilityHelper.guessBoxTag(box);
            }
            return "Span";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            GenericStructualElement child = this;
            if (child.children.isEmpty() && (child.box.getElement() == null || !child.box.getElement().hasAttribute("id"))) {
                return;
            }
            if (child.box instanceof LineBox || child.box instanceof InlineLayoutBox && child.children.size() == 1 && child.box.getParent() instanceof LineBox) {
                PdfBoxAccessibilityHelper.finishTreeItems(child.children, parent);
            } else {
                this.createPdfStrucureElement(parent, child);
                this.handleGlobalAttributes();
                PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
            }
        }
    }

    private static class PageItems {
        final List<GenericContentItem> _contentItems = new ArrayList<GenericContentItem>();
        final List<AnnotationWithStructureParent> _pageAnnotations = new ArrayList<AnnotationWithStructureParent>();

        private PageItems() {
        }
    }

    private static class GenericContentItem
    extends AbstractTreeItem {
        PDStructureElement parentElem;
        int mcid;
        COSDictionary dict;
        PDPage page;

        private GenericContentItem() {
        }

        public String toString() {
            return String.format("[Content Item-%s:%d]", super.toString(), this.mcid);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            GenericContentItem child = this;
            boolean isReplaced = child instanceof FigureContentItem;
            if (child.page == parent.page) {
                child.parentElem = parent.elem;
                child.parentElem.appendKid(new PDMarkedContent(isReplaced ? COSName.getPDFName((String)"Figure") : COSName.getPDFName((String)"Span"), child.dict));
            } else {
                child.parentElem = parent.elem;
                child.dict = new COSDictionary();
                child.dict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"MCR"));
                child.dict.setItem(COSName.PG, (COSObjectable)child.page);
                child.dict.setInt(COSName.MCID, child.mcid);
                PDMarkedContentReference ref = new PDMarkedContentReference(child.dict);
                child.parentElem.appendKid(ref);
            }
        }
    }

    private static class AnnotationWithStructureParent {
        PDStructureElement structureParent;
        PDAnnotation annotation;

        private AnnotationWithStructureParent() {
        }
    }

    private static class FigureStructualElement
    extends AbstractStructualElement {
        PDRectangle boundingBox;
        FigureContentItem content;

        private FigureStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "Figure";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (child instanceof FigureContentItem) {
                this.content = (FigureContentItem)child;
            } else {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this.parent, child, FigureContentItem.class);
            }
        }

        @Override
        void finish(AbstractStructualElement parent) {
            String alternateText;
            FigureStructualElement child = this;
            child.parentElem = parent.elem;
            child.elem = new PDStructureElement(child.getPdfTag(), (PDStructureNode)child.parentElem);
            child.elem.setParent((PDStructureNode)child.parentElem);
            child.elem.setPage(child.page);
            String string = alternateText = child.box.getElement() == null ? "" : this.box.getElement().getAttribute("alt");
            if (alternateText.isEmpty()) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.GENERAL_PDF_ACCESSIBILITY_NO_ALT_ATTRIBUTE_PROVIDED_FOR_IMAGE);
            }
            child.elem.setAlternateDescription(alternateText);
            this.handleLangAttribute();
            COSDictionary attributeDict = new COSDictionary();
            attributeDict.setItem(COSName.BBOX, (COSObjectable)child.boundingBox);
            attributeDict.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Layout"));
            this.setAttributeDictionary(attributeDict);
            child.parentElem.appendKid(child.elem);
            PdfBoxAccessibilityHelper.finishTreeItem(child.content, child);
        }
    }

    private static class TableStructualElement
    extends AbstractStructualElement {
        final TableHeadStructualElement thead = new TableHeadStructualElement();
        final List<TableBodyStructualElement> tbodies = new ArrayList<TableBodyStructualElement>(1);
        final TableFootStructualElement tfoot = new TableFootStructualElement();
        float pdfVersion = 1.5f;

        private TableStructualElement() {
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (child instanceof TableBodyStructualElement) {
                this.tbodies.add((TableBodyStructualElement)child);
            } else {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this.parent, child, TableBodyStructualElement.class);
            }
        }

        @Override
        void setPdfVersion(float version) {
            this.pdfVersion = version;
        }

        @Override
        String getPdfTag() {
            return "Table";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            if (this.pdfVersion < 1.5f) {
                PdfBoxAccessibilityHelper.finishTreeItems(child.thead.children, child);
                child.tbodies.forEach(tbody -> PdfBoxAccessibilityHelper.finishTreeItems(tbody.children, child));
                PdfBoxAccessibilityHelper.finishTreeItems(child.tfoot.children, child);
            } else {
                PdfBoxAccessibilityHelper.finishTreeItem(child.thead, child);
                PdfBoxAccessibilityHelper.finishTreeItems(child.tbodies, child);
                PdfBoxAccessibilityHelper.finishTreeItem(child.tfoot, child);
            }
        }
    }

    private static class TableHeadStructualElement
    extends GenericStructualElement {
        private TableHeadStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "THead";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (!(child instanceof TableRowStructualElement)) {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this, child, TableRowStructualElement.class);
            }
            super.addChild(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableHeadStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class TableBodyStructualElement
    extends GenericStructualElement {
        private TableBodyStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "TBody";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (!(child instanceof TableRowStructualElement)) {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this, child, TableRowStructualElement.class);
            }
            super.addChild(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableBodyStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class TableFootStructualElement
    extends GenericStructualElement {
        private TableFootStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "TFoot";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (!(child instanceof TableRowStructualElement)) {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this, child, TableRowStructualElement.class);
            }
            super.addChild(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableFootStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class ListItemStructualElement
    extends AbstractStructualElement {
        final ListLabelStructualElement label;
        final ListBodyStructualElement body = new ListBodyStructualElement();

        ListItemStructualElement() {
            this.body.parent = this;
            this.label = new ListLabelStructualElement();
            this.label.parent = this;
        }

        @Override
        String getPdfTag() {
            return "LI";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            this.body.addChild(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            ListItemStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItem(child.label, child);
            PdfBoxAccessibilityHelper.finishTreeItem(child.body, child);
        }
    }

    private static class ListLabelStructualElement
    extends AbstractStructualElement {
        final List<AbstractTreeItem> children = new ArrayList<AbstractTreeItem>(1);

        private ListLabelStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "Lbl";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            this.children.add(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            ListLabelStructualElement child = this;
            if (child.children.isEmpty()) {
                return;
            }
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class FigureContentItem
    extends GenericContentItem {
        private FigureContentItem() {
        }
    }

    private static class Token {
        private Token() {
        }
    }

    private static class AbbrStuctualElement
    extends GenericStructualElement {
        float pdfVersion = 1.5f;

        private AbbrStuctualElement() {
        }

        @Override
        String getPdfTag() {
            return "Span";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            AbbrStuctualElement child = this;
            this.createPdfStrucureElement(parent, child);
            if (this.box.getElement() != null) {
                String expanded = this.box.getElement().getAttribute("title");
                if (!expanded.isEmpty()) {
                    if (this.pdfVersion < 1.5f) {
                        child.elem.setAlternateDescription(expanded);
                    } else {
                        child.elem.setExpandedForm(expanded);
                    }
                } else {
                    XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_PDF_ACCESSIBILITY_NO_TITLE_TEXT_PROVIDED_FOR, (Object)"abbr tag");
                }
                this.handleLangAttribute();
            }
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }

        @Override
        void setPdfVersion(float version) {
            this.pdfVersion = version;
        }
    }

    private static class AnchorStuctualElement
    extends GenericStructualElement {
        private AnchorStuctualElement() {
        }

        @Override
        String getPdfTag() {
            return "Link";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            String alternate;
            AnchorStuctualElement child = this;
            this.createPdfStrucureElement(parent, child);
            String string = alternate = this.box.getElement() != null ? this.box.getElement().getAttribute("title") : "";
            if (alternate.isEmpty()) {
                XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_PDF_ACCESSIBILITY_NO_TITLE_TEXT_PROVIDED_FOR, (Object)"link");
            }
            child.elem.setAlternateDescription(alternate);
            this.handleLangAttribute();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class TableHeaderStructualElement
    extends TableHeaderOrCellStructualElement {
        private TableHeaderStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "TH";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableHeaderStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            String scope = this.box.getElement() != null ? this.box.getElement().getAttribute("scope") : "";
            COSDictionary attrDict = new COSDictionary();
            attrDict.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Table"));
            if ("row".equals(scope)) {
                attrDict.setItem(COSName.getPDFName((String)"Scope"), (COSBase)COSName.getPDFName((String)"Row"));
            } else {
                attrDict.setItem(COSName.getPDFName((String)"Scope"), (COSBase)COSName.getPDFName((String)"Column"));
            }
            this.addCellAttributes(attrDict);
            this.setAttributeDictionary(attrDict);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class TableCellStructualElement
    extends TableHeaderOrCellStructualElement {
        private TableCellStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "TD";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableCellStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            COSDictionary attrDict = new COSDictionary();
            attrDict.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Table"));
            if (this.addCellAttributes(attrDict)) {
                this.setAttributeDictionary(attrDict);
            }
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class TableRowStructualElement
    extends GenericStructualElement {
        private TableRowStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "TR";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (!(child instanceof TableHeaderOrCellStructualElement)) {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this, child, TableHeaderOrCellStructualElement.class);
            }
            super.addChild(child);
        }

        @Override
        void finish(AbstractStructualElement parent) {
            TableRowStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }

    private static class ListStructualElement
    extends AbstractStructualElement {
        final List<ListItemStructualElement> listItems = new ArrayList<ListItemStructualElement>();

        private ListStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "L";
        }

        @Override
        void addChild(AbstractTreeItem child) {
            if (child instanceof ListItemStructualElement) {
                this.listItems.add((ListItemStructualElement)child);
            } else {
                PdfBoxAccessibilityHelper.logIncompatibleChild(this, child, ListItemStructualElement.class);
            }
        }

        @Override
        void finish(AbstractStructualElement parent) {
            ListStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            IdentValue listStyleType = child.box.getStyle().getIdent(CSSName.LIST_STYLE_TYPE);
            String listType = listStyleType == IdentValue.NONE ? "None" : (listStyleType == IdentValue.DISC ? "Disc" : (listStyleType == IdentValue.SQUARE ? "Square" : (listStyleType == IdentValue.CIRCLE ? "Circle" : (listStyleType == IdentValue.DECIMAL || listStyleType == IdentValue.DECIMAL_LEADING_ZERO ? "Decimal" : (listStyleType == IdentValue.UPPER_ROMAN ? "UpperRoman" : (listStyleType == IdentValue.LOWER_ROMAN ? "LowerRoman" : (listStyleType == IdentValue.UPPER_ALPHA ? "UpperAlpha" : (listStyleType == IdentValue.LOWER_ALPHA ? "LowerAlpha" : "Decimal"))))))));
            COSDictionary listNumbering = new COSDictionary();
            listNumbering.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"List"));
            listNumbering.setItem(COSName.getPDFName((String)"ListNumbering"), (COSBase)COSName.getPDFName((String)listType));
            this.setAttributeDictionary(listNumbering);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.listItems, child);
        }
    }

    private static abstract class TableHeaderOrCellStructualElement
    extends GenericStructualElement {
        private TableHeaderOrCellStructualElement() {
        }

        boolean addCellAttributes(COSDictionary attrDict) {
            TableHeaderOrCellStructualElement child = this;
            boolean added = false;
            int rowSpanAttr = 1;
            int colSpanAttr = 1;
            if (child.box instanceof TableCellBox) {
                TableCellBox cell = (TableCellBox)this.box;
                colSpanAttr = cell.getStyle().getColSpan();
                rowSpanAttr = cell.getStyle().getRowSpan();
            }
            if (colSpanAttr != 1) {
                added = true;
                attrDict.setInt(COSName.getPDFName((String)"ColSpan"), colSpanAttr);
            }
            if (rowSpanAttr != 1) {
                added = true;
                attrDict.setInt(COSName.getPDFName((String)"RowSpan"), rowSpanAttr);
            }
            return added;
        }
    }

    private static class ListBodyStructualElement
    extends GenericStructualElement {
        private ListBodyStructualElement() {
        }

        @Override
        String getPdfTag() {
            return "LBody";
        }

        @Override
        void finish(AbstractStructualElement parent) {
            ListBodyStructualElement child = this;
            this.createPdfStrucureElement(parent, child);
            this.handleGlobalAttributes();
            PdfBoxAccessibilityHelper.finishTreeItems(child.children, child);
        }
    }
}

