/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.swing.ImageLoadItem;
import com.openhtmltopdf.swing.ImageResourceLoader;
import com.openhtmltopdf.swing.MutableFSImage;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.LinkedList;
import java.util.logging.Level;

class ImageLoadQueue {
    private static final ImageLoadItem KILL_SWITCH = new ImageLoadItem(null, null, null, -1, -1);
    private final LinkedList<ImageLoadItem> _loadQueue = new LinkedList();

    public synchronized void addToQueue(ImageResourceLoader imageResourceLoader, String uri, MutableFSImage mfsi, int width, int height) {
        XRLog.log(Level.FINE, LogMessageId.LogMessageId1Param.GENERAL_QUEUEING_LOAD_FOR_IMAGE_URI, uri);
        this._loadQueue.addLast(new ImageLoadItem(imageResourceLoader, uri, mfsi, width, height));
        this.notifyAll();
    }

    public synchronized ImageLoadItem getTask() throws InterruptedException {
        while (this._loadQueue.isEmpty()) {
            this.wait();
        }
        if (this._loadQueue.getLast() == KILL_SWITCH) {
            XRLog.log(Level.FINE, LogMessageId.LogMessageId1Param.GENERAL_THREAD_REQUESTED_ITEM_BUT_QUEUE_IS_SHUTTING_DOWN, Thread.currentThread().getName());
            return KILL_SWITCH;
        }
        ImageLoadItem item = this._loadQueue.removeLast();
        XRLog.log(Level.FINE, LogMessageId.LogMessageId3Param.GENERAL_THREAD_PULLED_ITEM_FROM_QUEUE, (Object)Thread.currentThread().getName(), (Object)item._uri, (Object)(this._loadQueue.size() - 1));
        return item;
    }

    public synchronized void reset() {
        this._loadQueue.clear();
    }

    public synchronized void kill() {
        this._loadQueue.addLast(KILL_SWITCH);
        this.notifyAll();
    }

    public static boolean isKillSwitch(Object queueItem) {
        return queueItem == KILL_SWITCH;
    }

    public int size() {
        return this._loadQueue.size();
    }
}

