/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.regex;

import com.networknt.schema.regex.RegularExpression;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.CodeRange;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeCodeRange;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;

class JoniRegularExpression
implements RegularExpression {
    private final Regex pattern;
    private final Pattern INVALID_ESCAPE_PATTERN = Pattern.compile(".*\\\\([aeg-jl-moqyzACE-OQ-RT-VX-Z1-9]|k([^<]|$)|c$|[pP]([^{]|$)|u([^{0-9]|$)|x([0-9a-fA-F][^0-9a-fA-F]|[^0-9a-fA-F][0-9a-fA-F]|[^0-9a-fA-F][^0-9a-fA-F]|.?$)).*");
    private static final Syntax SYNTAX = new Syntax(Syntax.ECMAScript.name, Syntax.ECMAScript.op, Syntax.ECMAScript.op2 | 0x80 | 0x100, Syntax.ECMAScript.op3, Syntax.ECMAScript.behavior, Syntax.ECMAScript.options, Syntax.ECMAScript.metaCharTable);

    JoniRegularExpression(String regex) {
        this(regex, SYNTAX);
    }

    JoniRegularExpression(String regex, Syntax syntax) {
        this.validate(regex);
        byte[] bytes = regex.getBytes(StandardCharsets.UTF_8);
        this.pattern = new Regex(bytes, 0, bytes.length, 8, (Encoding)ECMAScriptUTF8Encoding.INSTANCE, syntax);
    }

    protected void validate(String regex) {
        if (this.INVALID_ESCAPE_PATTERN.matcher(regex).matches()) {
            throw new SyntaxException("Invalid escape");
        }
    }

    @Override
    public boolean matches(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return this.pattern.matcher(bytes).search(0, bytes.length, 0) >= 0;
    }

    public static class ECMAScriptUTF8Encoding
    extends DelegatingEncoding {
        private static final int[] CR_DIGIT = new int[]{1, 48, 57};
        private static final int[] CR_WORD = new int[]{4, 48, 57, 65, 90, 95, 95, 97, 122};
        private static final int[] CR_SPACE = new int[]{10, 9, 13, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8232, 8233, 8239, 8239, 8287, 8287, 12288, 12288, 65279, 65279};
        private static final byte[] PROPERTY_NAME_DIGIT = new byte[]{100, 105, 103, 105, 116};
        public static final ECMAScriptUTF8Encoding INSTANCE = new ECMAScriptUTF8Encoding();

        protected ECMAScriptUTF8Encoding() {
            super((Encoding)UTF8Encoding.INSTANCE);
        }

        @Override
        public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
            switch (ctype) {
                case 4: {
                    sbOut.value = 128;
                    return CR_DIGIT;
                }
                case 12: {
                    sbOut.value = 128;
                    return CR_WORD;
                }
                case 9: {
                    sbOut.value = 128;
                    return CR_SPACE;
                }
            }
            return this.delegate.ctypeCodeRange(ctype, sbOut);
        }

        @Override
        public boolean isCodeCType(int code, int ctype) {
            switch (ctype) {
                case 4: {
                    return CodeRange.isInCodeRange((int[])CR_DIGIT, (int)code);
                }
                case 12: {
                    return CodeRange.isInCodeRange((int[])CR_WORD, (int)code);
                }
                case 9: {
                    return CodeRange.isInCodeRange((int[])CR_SPACE, (int)code);
                }
            }
            return this.delegate.isCodeCType(code, ctype);
        }

        @Override
        public int propertyNameToCType(byte[] name, int p, int end) {
            if (Arrays.equals(PROPERTY_NAME_DIGIT, name, p, end)) {
                return UnicodeCodeRange.ND.ordinal();
            }
            return this.delegate.propertyNameToCType(name, p, end);
        }
    }

    public static class DelegatingEncoding
    extends Encoding {
        protected final Encoding delegate;

        protected DelegatingEncoding(Encoding delegate) {
            super(new String(delegate.getName()), delegate.minLength(), delegate.maxLength());
            this.delegate = delegate;
        }

        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        public String getCharsetName() {
            return this.delegate.getCharsetName();
        }

        public int length(byte c) {
            return this.delegate.length(c);
        }

        public int length(byte[] bytes, int p, int end) {
            return this.delegate.length(bytes, p, end);
        }

        public boolean isNewLine(byte[] bytes, int p, int end) {
            return this.delegate.isNewLine(bytes, p, end);
        }

        public int mbcToCode(byte[] bytes, int p, int end) {
            return this.delegate.mbcToCode(bytes, p, end);
        }

        public int codeToMbcLength(int code) {
            return this.delegate.codeToMbcLength(code);
        }

        public int codeToMbc(int code, byte[] bytes, int p) {
            return this.delegate.codeToMbc(code, bytes, p);
        }

        public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] to) {
            return this.delegate.mbcCaseFold(flag, bytes, pp, end, to);
        }

        public byte[] toLowerCaseTable() {
            return this.delegate.toLowerCaseTable();
        }

        public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg) {
            this.delegate.applyAllCaseFold(flag, fun, arg);
        }

        public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes, int p, int end) {
            return this.delegate.caseFoldCodesByString(flag, bytes, p, end);
        }

        public int propertyNameToCType(byte[] bytes, int p, int end) {
            return this.delegate.propertyNameToCType(bytes, p, end);
        }

        public boolean isCodeCType(int code, int ctype) {
            return this.delegate.isCodeCType(code, ctype);
        }

        public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
            return this.delegate.ctypeCodeRange(ctype, sbOut);
        }

        public int leftAdjustCharHead(byte[] bytes, int p, int s, int end) {
            return this.delegate.leftAdjustCharHead(bytes, p, s, end);
        }

        public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
            return this.delegate.isReverseMatchAllowed(bytes, p, end);
        }

        public int caseMap(IntHolder flagP, byte[] bytes, IntHolder pp, int end, byte[] to, int toP, int toEnd) {
            return this.delegate.caseMap(flagP, bytes, pp, end, to, toP, toEnd);
        }

        public int strLength(byte[] bytes, int p, int end) {
            return this.delegate.strLength(bytes, p, end);
        }

        public int strCodeAt(byte[] bytes, int p, int end, int index) {
            return this.delegate.strCodeAt(bytes, p, end, index);
        }

        public boolean isMbcCrnl(byte[] bytes, int p, int end) {
            return this.delegate.isMbcCrnl(bytes, p, end);
        }
    }

    static class Arrays {
        Arrays() {
        }

        public static boolean equals(byte[] a, byte[] a2, int p, int end) {
            if (a == a2) {
                return true;
            }
            if (a == null || a2 == null) {
                return false;
            }
            int length = a.length;
            if (end - p != length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (a[i] == a2[i + p]) continue;
                return false;
            }
            return true;
        }
    }
}

