/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.impl.AckingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationBatchExecutorWithQueue {
    private static final Logger LOG = LoggerFactory.getLogger(MutationBatchExecutorWithQueue.class);
    private ExecutorService executor;
    private Predicate<Exception> retryablePredicate = Predicates.alwaysFalse();
    private long waitOnNoHosts = 1000L;
    private int nThreads;
    private long timeout;
    private AckingQueue queue;
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failureCount = new AtomicLong(0L);

    public MutationBatchExecutorWithQueue(AckingQueue queue, int nThreads) {
        this.executor = Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setDaemon(true).build());
        this.queue = queue;
        this.nThreads = nThreads;
    }

    public MutationBatchExecutorWithQueue usingRetryablePredicate(Predicate<Exception> predicate) {
        this.retryablePredicate = predicate;
        return this;
    }

    public MutationBatchExecutorWithQueue startConsumers() {
        for (int i = 0; i < this.nThreads; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    MutationBatch m = null;
                    while (true) {
                        try {
                            m = MutationBatchExecutorWithQueue.this.queue.getNextMutation(MutationBatchExecutorWithQueue.this.timeout, TimeUnit.MILLISECONDS);
                            if (m != null) {
                                m.execute();
                                MutationBatchExecutorWithQueue.this.successCount.incrementAndGet();
                                MutationBatchExecutorWithQueue.this.queue.ackMutation(m);
                                m = null;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (Exception e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                            MutationBatchExecutorWithQueue.this.failureCount.incrementAndGet();
                            if (e instanceof NoAvailableHostsException) {
                                try {
                                    Thread.sleep(MutationBatchExecutorWithQueue.this.waitOnNoHosts);
                                }
                                catch (InterruptedException e1) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!MutationBatchExecutorWithQueue.this.retryablePredicate.apply((Object)e)) {
                                try {
                                    MutationBatchExecutorWithQueue.this.queue.ackMutation(m);
                                }
                                catch (Exception e1) {}
                            } else {
                                try {
                                    MutationBatchExecutorWithQueue.this.queue.repushMutation(m);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            m = null;
                        }
                        if (m != null) continue;
                    }
                }
            });
        }
        return this;
    }

    public void execute(MutationBatch m) throws Exception {
        this.queue.pushMutation(m);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public long getFailureCount() {
        return this.failureCount.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }
}

