/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ColumnPath<C>
implements Iterable<ByteBuffer> {
    private List<ByteBuffer> path = new ArrayList<ByteBuffer>();
    private Serializer<C> columnSerializer;

    public ColumnPath(Serializer<C> columnSerializer) {
        this.columnSerializer = columnSerializer;
    }

    public ColumnPath() {
    }

    public <C2> ColumnPath<C> append(C2 name, Serializer<C2> ser) {
        this.path.add(ByteBuffer.wrap(ser.toBytes(name)));
        return this;
    }

    public <C2> ColumnPath<C> append(String name) {
        this.append(name, StringSerializer.get());
        return this;
    }

    public <C2> ColumnPath<C> append(int name) {
        this.append(name, IntegerSerializer.get());
        return this;
    }

    public <C2> ColumnPath<C> append(double name) {
        this.append(name, DoubleSerializer.get());
        return this;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.path.iterator();
    }

    public int length() {
        return this.path.size();
    }

    public ByteBuffer get(int index) {
        return this.path.get(index);
    }

    public ByteBuffer getLast() {
        return this.path.get(this.path.size() - 1);
    }

    public Serializer<C> getSerializer() {
        return this.columnSerializer;
    }
}

