/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingDescribeHostSupplier
implements Supplier<List<Host>> {
    private static final Logger LOG = LoggerFactory.getLogger(RingDescribeHostSupplier.class);
    private final Keyspace keyspace;
    private final int defaultPort;
    private final String dc;
    private final String rack;
    private volatile List<Host> previousHosts;

    public RingDescribeHostSupplier(Keyspace keyspace, int defaultPort, String dc, String rack) {
        this.keyspace = keyspace;
        this.defaultPort = defaultPort;
        this.dc = dc;
        this.rack = rack;
    }

    public RingDescribeHostSupplier(Keyspace keyspace, int defaultPort, String dc) {
        this(keyspace, defaultPort, dc, null);
    }

    public RingDescribeHostSupplier(Keyspace keyspace, int defaultPort) {
        this(keyspace, defaultPort, null, null);
    }

    public synchronized List<Host> get() {
        try {
            HashMap ipToHost = Maps.newHashMap();
            for (TokenRange range : this.keyspace.describeRing(this.dc, this.rack)) {
                for (String endpoint : range.getEndpoints()) {
                    Host host = (Host)ipToHost.get(endpoint);
                    if (host == null) {
                        host = new Host(endpoint, this.defaultPort);
                        ipToHost.put(endpoint, host);
                    }
                    host.getTokenRanges().add(range);
                }
            }
            this.previousHosts = Lists.newArrayList(ipToHost.values());
            return this.previousHosts;
        }
        catch (ConnectionException e) {
            if (this.previousHosts == null) {
                throw new RuntimeException(e);
            }
            LOG.warn("Failed to get hosts from " + this.keyspace.getKeyspaceName() + " via ring describe.  Will use previously known ring instead");
            return this.previousHosts;
        }
    }
}

