/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.NodeDiscovery;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.impl.BagOfConnectionsConnectionPoolImpl;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolType;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.impl.NodeDiscoveryImpl;
import com.netflix.astyanax.connectionpool.impl.RoundRobinConnectionPoolImpl;
import com.netflix.astyanax.connectionpool.impl.TokenAwareConnectionPoolImpl;
import com.netflix.astyanax.impl.FilteringHostSupplier;
import com.netflix.astyanax.impl.RingDescribeHostSupplier;
import com.netflix.astyanax.shallows.EmptyKeyspaceTracerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AstyanaxContext<T> {
    private final ConnectionPool<?> cp;
    private final NodeDiscovery discovery;
    private final ConnectionPoolConfiguration cpConfig;
    private final AstyanaxConfiguration asConfig;
    private final String clusterName;
    private final String keyspaceName;
    private final T client;
    private final ConnectionPoolMonitor monitor;

    private AstyanaxContext(Builder builder, T client) {
        this.cpConfig = builder.cpConfig;
        this.asConfig = builder.asConfig;
        this.cp = builder.cp;
        this.clusterName = builder.clusterName;
        this.keyspaceName = builder.keyspaceName;
        this.client = client;
        this.discovery = builder.discovery;
        this.monitor = builder.monitor;
    }

    public T getEntity() {
        return this.getClient();
    }

    public T getClient() {
        return this.client;
    }

    public ConnectionPool<?> getConnectionPool() {
        return this.cp;
    }

    public ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.cpConfig;
    }

    public AstyanaxConfiguration getAstyanaxConfiguration() {
        return this.asConfig;
    }

    public NodeDiscovery getNodeDiscovery() {
        return this.discovery;
    }

    public ConnectionPoolMonitor getConnectionPoolMonitor() {
        return this.monitor;
    }

    public void start() {
        this.cp.start();
        if (this.discovery != null) {
            this.discovery.start();
        }
    }

    public void shutdown() {
        if (this.discovery != null) {
            this.discovery.shutdown();
        }
        this.cp.shutdown();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public static class Builder {
        protected ConnectionPool<?> cp;
        protected NodeDiscovery discovery;
        protected ConnectionPoolConfiguration cpConfig;
        protected AstyanaxConfiguration asConfig;
        protected String clusterName;
        protected String keyspaceName;
        protected KeyspaceTracerFactory tracerFactory = EmptyKeyspaceTracerFactory.getInstance();
        protected Supplier<List<Host>> hostSupplier;
        protected ConnectionPoolMonitor monitor = new CountingConnectionPoolMonitor();

        public Builder forCluster(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder forKeyspace(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public Builder withConnectionPoolConfiguration(ConnectionPoolConfiguration cpConfig) {
            this.cpConfig = cpConfig;
            return this;
        }

        public Builder withAstyanaxConfiguration(AstyanaxConfiguration asConfig) {
            this.asConfig = asConfig;
            return this;
        }

        public Builder withHostSupplier(Supplier<List<Host>> supplier) {
            this.hostSupplier = supplier;
            return this;
        }

        public Builder withTracerFactory(KeyspaceTracerFactory tracerFactory) {
            this.tracerFactory = tracerFactory;
            return this;
        }

        public Builder withConnectionPoolMonitor(ConnectionPoolMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public NodeDiscoveryType getNodeDiscoveryType() {
            if (this.cpConfig.getSeeds() != null) {
                if (this.asConfig.getConnectionPoolType() == ConnectionPoolType.TOKEN_AWARE) {
                    return NodeDiscoveryType.RING_DESCRIBE;
                }
            } else {
                if (this.asConfig.getConnectionPoolType() == ConnectionPoolType.TOKEN_AWARE) {
                    return NodeDiscoveryType.TOKEN_AWARE;
                }
                return NodeDiscoveryType.DISCOVERY_SERVICE;
            }
            return this.asConfig.getDiscoveryType();
        }

        protected <T> ConnectionPool<T> createConnectionPool(ConnectionFactory<T> connectionFactory) {
            TokenAwareConnectionPoolImpl connectionPool = null;
            switch (this.asConfig.getConnectionPoolType()) {
                case TOKEN_AWARE: {
                    connectionPool = new TokenAwareConnectionPoolImpl(this.cpConfig, connectionFactory, this.monitor);
                    break;
                }
                case BAG: {
                    connectionPool = new BagOfConnectionsConnectionPoolImpl(this.cpConfig, connectionFactory, this.monitor);
                    break;
                }
                default: {
                    connectionPool = new RoundRobinConnectionPoolImpl(this.cpConfig, connectionFactory, this.monitor);
                }
            }
            if (this.hostSupplier != null) {
                connectionPool.setHosts((Collection)this.hostSupplier.get());
            }
            return connectionPool;
        }

        public <T> AstyanaxContext<Keyspace> buildKeyspace(AstyanaxTypeFactory<T> factory) {
            this.cpConfig.initialize();
            ConnectionPool<T> cp = this.createConnectionPool(factory.createConnectionFactory(this.asConfig, this.cpConfig, this.tracerFactory, this.monitor));
            this.cp = cp;
            Keyspace keyspace = factory.createKeyspace(this.keyspaceName, cp, this.asConfig, this.tracerFactory);
            RingDescribeHostSupplier supplier = null;
            switch (this.getNodeDiscoveryType()) {
                case DISCOVERY_SERVICE: {
                    Preconditions.checkNotNull(this.hostSupplier, (Object)"Missing host name supplier");
                    supplier = this.hostSupplier;
                    break;
                }
                case RING_DESCRIBE: {
                    supplier = new RingDescribeHostSupplier(keyspace, this.cpConfig.getPort(), this.cpConfig.getLocalDatacenter());
                    break;
                }
                case TOKEN_AWARE: {
                    if (this.hostSupplier == null) {
                        supplier = new RingDescribeHostSupplier(keyspace, this.cpConfig.getPort(), this.cpConfig.getLocalDatacenter());
                        break;
                    }
                    supplier = new FilteringHostSupplier((Supplier)new RingDescribeHostSupplier(keyspace, this.cpConfig.getPort(), this.cpConfig.getLocalDatacenter()), this.hostSupplier);
                    break;
                }
                case NONE: {
                    supplier = null;
                }
            }
            if (supplier != null) {
                this.discovery = new NodeDiscoveryImpl(StringUtils.join(Arrays.asList(this.clusterName, this.keyspaceName), (String)"_"), this.asConfig.getDiscoveryDelayInSeconds() * 1000, (Supplier)supplier, cp);
            }
            return new AstyanaxContext<Keyspace>(this, keyspace);
        }

        public <T> AstyanaxContext<Cluster> buildCluster(AstyanaxTypeFactory<T> factory) {
            this.cpConfig.initialize();
            ConnectionPool<T> cp = this.createConnectionPool(factory.createConnectionFactory(this.asConfig, this.cpConfig, this.tracerFactory, this.monitor));
            this.cp = cp;
            if (this.hostSupplier != null) {
                this.discovery = new NodeDiscoveryImpl(this.clusterName, this.asConfig.getDiscoveryDelayInSeconds() * 1000, this.hostSupplier, cp);
            }
            return new AstyanaxContext<Cluster>(this, factory.createCluster(cp, this.asConfig, this.tracerFactory));
        }
    }
}

