/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.readers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDCConfigReader
implements Callable<Map<String, Object>> {
    private static Logger log = LoggerFactory.getLogger(JDCConfigReader.class);
    private DataSource datasource;
    private String query;
    private String keyColumnName = "property_key";
    private String valueColumnName = "property_value";

    public JDCConfigReader(DataSource datasource, String query, String keyColumnName, String valueColumnName) {
        this.datasource = datasource;
        this.query = query;
        this.keyColumnName = keyColumnName;
        this.valueColumnName = valueColumnName;
    }

    @Override
    public Map<String, Object> call() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(this.query.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String key = (String)rs.getObject(this.keyColumnName);
                Object value = rs.getObject(this.valueColumnName);
                map.put(key, value);
            }
            this.close(conn, pstmt, rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, rs);
                throw throwable;
            }
        }
        return map;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    protected Connection getConnection() throws SQLException {
        return this.getDatasource().getConnection();
    }

    private void close(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error("An error occured on closing the ResultSet", (Throwable)e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.error("An error occured on closing the statement", (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("An error occured on closing the connection", (Throwable)e);
        }
    }
}

