/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.loaders;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.readers.URLConfigReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

public class PropertiesConfigReader
implements ConfigReader {
    @Override
    public Config load(ClassLoader loader, String name, String resourceName) throws ConfigException {
        URL url = PropertiesConfigReader.getResource(loader, resourceName + ".properties");
        if (url == null) {
            throw new ConfigException("Unable to resolve URL for resource " + resourceName);
        }
        return this.load(loader, name, url);
    }

    @Override
    public Config load(ClassLoader loader, String name, URL url) throws ConfigException {
        try {
            return new MapConfig(name, new URLConfigReader(url).call().getToAdd());
        }
        catch (IOException e) {
            throw new ConfigException("Unable to load URL " + url.toString(), e);
        }
    }

    @Override
    public boolean canLoad(ClassLoader loader, String name) {
        return PropertiesConfigReader.getResource(loader, name + ".properties") != null;
    }

    @Override
    public boolean canLoad(ClassLoader loader, URL uri) {
        return uri.getPath().endsWith(".properties");
    }

    private static URL getResource(ClassLoader loader, String resourceName) {
        URL url = null;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            try {
                resourceName = URLDecoder.decode(resourceName, "UTF-8");
                url = new File(resourceName).toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }
}

