/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.InterpolatingConfig;
import com.netflix.archaius.config.SettableConfig;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SimpleDynamicConfig
extends InterpolatingConfig
implements SettableConfig {
    private ConcurrentMap<String, String> props = new ConcurrentHashMap<String, String>();

    public SimpleDynamicConfig(String name) {
        super(name);
    }

    @Override
    public <T> void setProperty(String propName, T propValue) {
        this.props.put(propName, propValue.toString());
        this.notifyConfigUpdated();
    }

    @Override
    public void clearProperty(String propName) {
        this.props.remove(propName);
        this.notifyConfigUpdated();
    }

    @Override
    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public String getRawString(String key) {
        return (String)this.props.get(key);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    @Override
    public void setProperties(Properties properties) {
        if (null != properties) {
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                this.setProperty(prop.getKey().toString(), prop.getValue());
            }
        }
    }
}

