/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.InterpolatingConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MapConfig
extends InterpolatingConfig {
    private Map<String, String> props = new HashMap<String, String>();

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public MapConfig(String name, Map<String, String> props) {
        super(name);
        this.props.putAll(props);
        this.props = Collections.unmodifiableMap(this.props);
    }

    public MapConfig(String name, Properties props) {
        super(name);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.props = Collections.unmodifiableMap(this.props);
    }

    @Override
    public String getRawString(String key) {
        return this.props.get(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    public static class Builder {
        final String name;
        Map<String, String> map = new HashMap<String, String>();

        public Builder(String name) {
            this.name = name;
        }

        public <T> Builder put(String key, T value) {
            this.map.put(key, value.toString());
            return this;
        }

        public MapConfig build() {
            return new MapConfig(this.name, this.map);
        }
    }
}

