/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.exceptions.ParseException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class InterpolatingConfig
extends AbstractConfig {
    public InterpolatingConfig(String name) {
        super(name);
    }

    @Override
    public String interpolate(String key) {
        String value = this.getRawString(key);
        if (value == null) {
            return null;
        }
        return this.getStrInterpolator().resolve(value);
    }

    @Override
    public Long getLong(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Long)this.notFound(key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return (Long)this.parseError(key, value, e);
        }
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return (Long)this.parseError(key, value, e);
        }
    }

    @Override
    public String getString(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (String)this.notFound(key);
        }
        return value.toString();
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        return value;
    }

    @Override
    public Double getDouble(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Double)this.notFound(key);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return (Double)this.parseError(key, value, e);
        }
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return (Double)this.parseError(key, value, e);
        }
    }

    @Override
    public Integer getInteger(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Integer)this.notFound(key);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return (Integer)this.parseError(key, value, e);
        }
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return (Integer)this.parseError(key, value, e);
        }
    }

    @Override
    public Boolean getBoolean(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Boolean)this.notFound(key);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        return (Boolean)this.parseError(key, value, new Exception("Expected one of [true, yes, on, false, no, off]"));
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        return (Boolean)this.parseError(key, value, new Exception("Expected one of [true, yes, on, false, no, off]"));
    }

    @Override
    public Short getShort(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Short)this.notFound(key);
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return (Short)this.parseError(key, value, e);
        }
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return (Short)this.parseError(key, value, e);
        }
    }

    @Override
    public BigInteger getBigInteger(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (BigInteger)this.notFound(key);
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return (BigInteger)this.parseError(key, value, e);
        }
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return (BigInteger)this.parseError(key, value, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (BigDecimal)this.notFound(key);
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return (BigDecimal)this.parseError(key, value, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return (BigDecimal)this.parseError(key, value, e);
        }
    }

    @Override
    public Float getFloat(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Float)this.notFound(key);
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return (Float)this.parseError(key, value, e);
        }
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return (Float)this.parseError(key, value, e);
        }
    }

    @Override
    public Byte getByte(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (Byte)this.notFound(key);
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return (Byte)this.parseError(key, value, e);
        }
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return (Byte)this.parseError(key, value, e);
        }
    }

    public List getList(String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return (List)this.notFound(key);
        }
        String[] parts = value.split(",");
        return Arrays.asList(parts);
    }

    public List getList(String key, List defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        String[] parts = value.split(",");
        return Arrays.asList(parts);
    }

    @Override
    public <T> T get(Class<T> type, String key) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key);
        }
        return this.getDecoder().decode(type, value);
    }

    @Override
    public <T> T get(Class<T> type, String key, T defaultValue) {
        String value = this.interpolate(key);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        return this.getDecoder().decode(type, value);
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result.iterator();
    }

    private <T> T notFound(String key, T defaultValue) {
        return defaultValue;
    }

    private <T> T notFound(String key) {
        throw new NoSuchElementException("'" + key + "' not found in configuration " + this.getName());
    }

    private <T> T parseError(String key, String value, Exception e) {
        throw new ParseException("Error parsing value '" + value + "' for property '" + key + "'", e);
    }
}

