/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.StrInterpolator;
import com.netflix.archaius.config.PrefixedViewConfig;
import com.netflix.archaius.interpolate.CommonsStrInterpolatorFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractConfig
implements Config {
    private final String name;
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private Decoder decoder;
    private StrInterpolator interpolator;

    public AbstractConfig(String name) {
        this.name = name;
        this.decoder = new DefaultDecoder();
        this.interpolator = CommonsStrInterpolatorFactory.INSTANCE.create(this);
    }

    protected CopyOnWriteArrayList<ConfigListener> getListeners() {
        return this.listeners;
    }

    @Override
    public final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public final StrInterpolator getStrInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setStrInterpolator(StrInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyConfigUpdated() {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated(this);
        }
    }

    protected void notifyError(Throwable t) {
        for (ConfigListener listener : this.listeners) {
            listener.onError(t, this);
        }
    }

    public void notifyConfigAdded(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigAdded(child);
        }
    }

    public void notifyConfigRemoved(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigRemoved(child);
        }
    }

    @Override
    public String interpolate(String key) {
        String value = this.getRawString(key);
        if (value == null) {
            return null;
        }
        return this.interpolator.resolve(value);
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result.iterator();
    }

    @Override
    public Config getPrefixedView(String prefix) {
        return new PrefixedViewConfig(prefix, this);
    }

    @Override
    public void accept(Config.Visitor visitor) {
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            visitor.visit(this, iter.next());
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

