/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PathInits
implements Serializable {
    private static final long serialVersionUID = -2173980858324141095L;
    public static final PathInits DEFAULT = new PathInits(new String[0]);
    public static final PathInits DIRECT = new PathInits("*");
    private boolean initAllProps = false;
    private final Map<String, PathInits> propertyToInits = new HashMap<String, PathInits>();

    public PathInits(String ... inits) {
        for (String init : inits) {
            this.addInit(init);
        }
    }

    private void addInit(String initStr) {
        if (initStr.equals("*")) {
            this.initAllProps = true;
        } else {
            String[] inits;
            String key;
            if (initStr.contains(".")) {
                key = initStr.substring(0, initStr.indexOf(46));
                inits = new String[]{initStr.substring(key.length() + 1)};
            } else {
                key = initStr;
                inits = new String[]{};
            }
            PathInits init = this.propertyToInits.get(key);
            if (init == null) {
                this.propertyToInits.put(key, new PathInits(inits));
            } else if (inits.length > 0) {
                init.addInit(inits[0]);
            }
        }
    }

    public PathInits get(String property) {
        if (this.propertyToInits.containsKey(property)) {
            return this.propertyToInits.get(property);
        }
        if (this.initAllProps) {
            return DEFAULT;
        }
        throw new IllegalArgumentException(property + " is not initialized");
    }

    public boolean isInitialized(String property) {
        return this.initAllProps || this.propertyToInits.containsKey(property);
    }
}

