/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpression;
import javax.annotation.Nullable;

public abstract class BooleanExpression
extends ComparableExpression<Boolean>
implements Predicate {
    private static final long serialVersionUID = 3797956062512074164L;
    @Nullable
    private volatile BooleanExpression eqTrue;
    @Nullable
    private volatile BooleanExpression eqFalse;
    @Nullable
    private volatile BooleanExpression not;

    @Nullable
    public static BooleanExpression allOf(BooleanExpression ... exprs) {
        BooleanExpression rv = null;
        for (BooleanExpression b : exprs) {
            rv = rv == null ? b : rv.and(b);
        }
        return rv;
    }

    @Nullable
    public static BooleanExpression anyOf(BooleanExpression ... exprs) {
        BooleanExpression rv = null;
        for (BooleanExpression b : exprs) {
            rv = rv == null ? b : rv.or(b);
        }
        return rv;
    }

    public BooleanExpression() {
        super(Boolean.class);
    }

    public BooleanExpression as(Path<Boolean> alias) {
        return BooleanOperation.create(Ops.ALIAS, this, alias);
    }

    @Override
    public BooleanExpression as(String alias) {
        return this.as((Path)new PathImpl<Boolean>(Boolean.class, alias));
    }

    public BooleanExpression and(@Nullable Predicate right) {
        if (right != null) {
            return BooleanOperation.create(Ops.AND, this, right);
        }
        return this;
    }

    public BooleanExpression andAnyOf(Predicate ... predicates) {
        return this.and(ExpressionUtils.anyOf(predicates));
    }

    @Override
    public BooleanExpression not() {
        if (this.not == null) {
            this.not = BooleanOperation.create(Ops.NOT, this);
        }
        return this.not;
    }

    public BooleanExpression or(@Nullable Predicate right) {
        if (right != null) {
            return BooleanOperation.create(Ops.OR, this, right);
        }
        return this;
    }

    public BooleanExpression orAllOf(Predicate ... predicates) {
        return this.or(ExpressionUtils.allOf(predicates));
    }

    public BooleanExpression isTrue() {
        return this.eq(true);
    }

    public BooleanExpression isFalse() {
        return this.eq(false);
    }

    @Override
    public BooleanExpression eq(Boolean right) {
        if (right.booleanValue()) {
            if (this.eqTrue == null) {
                this.eqTrue = super.eq(true);
            }
            return this.eqTrue;
        }
        if (this.eqFalse == null) {
            this.eqFalse = super.eq(false);
        }
        return this.eqFalse;
    }
}

