/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.junit;

import com.mycila.log.Logger;
import com.mycila.log.Loggers;
import com.mycila.testing.core.Mycila;
import com.mycila.testing.core.MycilaTesting;
import com.mycila.testing.core.api.TestExecution;
import com.mycila.testing.core.api.TestNotifier;
import com.mycila.testing.core.util.Closeable;
import com.mycila.testing.core.util.ShutdownHook;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MycilaJunitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = Loggers.get(MycilaJunitRunner.class);
    private TestNotifier testNotifier;

    public MycilaJunitRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected final Object createTest() throws Exception {
        Object test = super.createTest();
        this.testNotifier = MycilaTesting.from(test.getClass()).configure(test).createNotifier(test);
        ShutdownHook.get().add(new Closeable(){

            public void close() throws Exception {
                MycilaJunitRunner.this.testNotifier.shutdown();
            }
        });
        this.testNotifier.prepare();
        return test;
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement statement = super.classBlock(notifier);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    MycilaJunitRunner.this.testNotifier.fireAfterClass();
                }
            }
        };
    }

    protected final Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MycilaJunitRunner.this.testNotifier.fireBeforeTest(method.getMethod());
                TestExecution testExecution = (TestExecution)Mycila.currentExecution();
                if (!testExecution.mustSkip()) {
                    try {
                        LOGGER.debug((Object)"Calling test method %s.%s", new Object[]{testExecution.method().getDeclaringClass().getName(), testExecution.method().getName()});
                        MycilaJunitRunner.super.methodInvoker(method, test).evaluate();
                    }
                    catch (Throwable t) {
                        testExecution.setThrowable(t);
                    }
                }
                MycilaJunitRunner.this.testNotifier.fireAfterTest();
                if (testExecution.throwable() != null) {
                    throw testExecution.throwable();
                }
            }
        };
    }
}

