/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core.introspect;

import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.introspect.Filter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filters {
    private Filters() {
    }

    public static <T> Filter<T> all() {
        return new Filter<T>(){

            @Override
            public boolean accept(T object) {
                return true;
            }
        };
    }

    public static <T> Filter<T> none() {
        return new Filter<T>(){

            @Override
            public boolean accept(T object) {
                return false;
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> filter) {
        Ensure.notNull("Filter", filter);
        return new Filter<T>(){

            @Override
            public boolean accept(T object) {
                return !filter.accept(object);
            }
        };
    }

    public static <T> Filter<T> and(final Filter<T> ... filters) {
        Ensure.notNull("Filters", filters);
        return new Filter<T>(){

            @Override
            public boolean accept(T object) {
                for (Filter filter : filters) {
                    if (filter.accept(object)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Filter<T> or(final Filter<T> ... filters) {
        Ensure.notNull("Filters", filters);
        return new Filter<T>(){

            @Override
            public boolean accept(T object) {
                for (Filter filter : filters) {
                    if (!filter.accept(object)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter<Field> fieldsProviding(final Class<?> type) {
        Ensure.notNull("Field type", type);
        return new Filter<Field>(){

            @Override
            public boolean accept(Field object) {
                return type.isAssignableFrom(object.getType());
            }
        };
    }

    public static Filter<Field> fieldsAccepting(final Class<?> type) {
        Ensure.notNull("Field type", type);
        return new Filter<Field>(){

            @Override
            public boolean accept(Field object) {
                return object.getType().isAssignableFrom(type);
            }
        };
    }

    public static Filter<Method> methodsReturning(final Class<?> type) {
        Ensure.notNull("Method return type", type);
        return new Filter<Method>(){

            @Override
            public boolean accept(Method object) {
                return type.isAssignableFrom(object.getReturnType());
            }
        };
    }

    public static Filter<Field> fieldsAnnotatedBy(final Class<? extends Annotation> annotation) {
        Ensure.notNull("Annotation", annotation);
        return new Filter<Field>(){

            @Override
            public boolean accept(Field object) {
                return object.isAnnotationPresent(annotation);
            }
        };
    }

    public static Filter<Method> methodsAnnotatedBy(final Class<? extends Annotation> annotation) {
        Ensure.notNull("Annotation", annotation);
        return new Filter<Method>(){

            @Override
            public boolean accept(Method object) {
                return object.isAnnotationPresent(annotation);
            }
        };
    }

    public static Filter<Method> excludeOverridenMethods(final Filter<Method> methodFilter) {
        return new Filter<Method>(){

            @Override
            public void add(Method element) {
                methodFilter.add(element);
            }

            @Override
            protected boolean accept(Method object) {
                return methodFilter.accept(object);
            }

            @Override
            public List<Method> select() {
                LinkedList methods = new LinkedList(methodFilter.select());
                Iterator iterator = methods.iterator();
                while (iterator.hasNext()) {
                    Method m = (Method)iterator.next();
                    int modifiers = m.getModifiers();
                    if ((modifiers & 0x11A) != 0) {
                        this.elements.add(m);
                        iterator.remove();
                        continue;
                    }
                    if ((modifiers & 0x640) == 0) continue;
                    iterator.remove();
                }
                while (!methods.isEmpty()) {
                    Method m1 = (Method)methods.poll();
                    boolean overriden = false;
                    Iterator iterator2 = methods.iterator();
                    while (iterator2.hasNext()) {
                        Method m2 = (Method)iterator2.next();
                        if (!m1.getName().equals(m2.getName()) || !Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes())) continue;
                        Class<?> c = m1.getDeclaringClass();
                        Class<?> a = m2.getDeclaringClass();
                        if (a.isAssignableFrom(c)) {
                            iterator2.remove();
                            continue;
                        }
                        if (!c.isAssignableFrom(a)) continue;
                        overriden = true;
                        break;
                    }
                    if (overriden) continue;
                    this.elements.add(m1);
                }
                return this.elements;
            }
        };
    }
}

