/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.mockrunner.test;

import junit.framework.TestCase;
import org.activemq.filter.mockrunner.ComparisonExpression;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.ExpressionFilter;
import org.activemq.filter.mockrunner.Filter;
import org.activemq.filter.mockrunner.LogicExpression;
import org.activemq.filter.mockrunner.PropertyExpression;
import org.activemq.selector.mockrunner.SelectorParser;

public class SelectorParserTest
extends TestCase {
    public void testParseWithParensAround() throws Exception {
        String[] stringArray = new String[]{"x = 1 and y = 2", "(x = 1) and (y = 2)", "((x = 1) and (y = 2))"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            System.out.println("Parsing: " + string);
            Filter filter = this.parse(string);
            SelectorParserTest.assertTrue((String)"Created ExpressionFilter filter", (boolean)(filter instanceof ExpressionFilter));
            Expression expression = ((ExpressionFilter)filter).getExpression();
            SelectorParserTest.assertTrue((String)"Created LogicExpression expression", (boolean)(expression instanceof LogicExpression));
            LogicExpression logicExpression = (LogicExpression)expression;
            Expression expression2 = logicExpression.getLeft();
            Expression expression3 = logicExpression.getRight();
            SelectorParserTest.assertTrue((String)"Left is a binary filter", (boolean)(expression2 instanceof ComparisonExpression));
            SelectorParserTest.assertTrue((String)"Right is a binary filter", (boolean)(expression3 instanceof ComparisonExpression));
            ComparisonExpression comparisonExpression = (ComparisonExpression)expression2;
            ComparisonExpression comparisonExpression2 = (ComparisonExpression)expression3;
            this.assertPropertyExpression("left", comparisonExpression.getLeft(), "x");
            this.assertPropertyExpression("right", comparisonExpression2.getLeft(), "y");
        }
    }

    protected void assertPropertyExpression(String string, Expression expression, String string2) {
        SelectorParserTest.assertTrue((String)(string + ". Must be PropertyExpression"), (boolean)(expression instanceof PropertyExpression));
        PropertyExpression propertyExpression = (PropertyExpression)expression;
        SelectorParserTest.assertEquals((String)(string + ". Property name"), (String)string2, (String)propertyExpression.getName());
    }

    protected Filter parse(String string) throws Exception {
        return new SelectorParser().parse(string);
    }
}

