/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ManagedDevice;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ManagedDeviceReferenceRequest
extends BaseReferenceRequest<ManagedDevice> {
    public ManagedDeviceReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDevice.class);
    }

    @Nonnull
    public ManagedDeviceReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ManagedDeviceReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<ManagedDevice> putAsync(@Nonnull ManagedDevice srcManagedDevice) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/deviceManagement/managedDevices/" + srcManagedDevice.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public ManagedDevice put(@Nonnull ManagedDevice srcManagedDevice) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/deviceManagement/managedDevices/" + srcManagedDevice.id));
        return (ManagedDevice)this.send(HttpMethod.PUT, payload);
    }
}

