/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.correlation.InstrumentationKeyResolver;
import com.microsoft.applicationinsights.web.internal.correlation.TelemetryCorrelationUtils;
import com.microsoft.applicationinsights.web.internal.correlation.tracecontext.Traceparent;
import com.microsoft.applicationinsights.web.internal.correlation.tracecontext.Tracestate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TraceContextCorrelation {
    public static final String TRACEPARENT_HEADER_NAME = "traceparent";
    public static final String TRACESTATE_HEADER_NAME = "tracestate";
    public static final String REQUEST_CONTEXT_HEADER_NAME = "Request-Context";
    public static final String AZURE_TRACEPARENT_COMPONENT_INITIAL = "az";
    public static final String REQUEST_CONTEXT_HEADER_APPID_KEY = "appId";
    private static boolean isW3CBackCompatEnabled = true;

    private TraceContextCorrelation() {
    }

    public static void resolveCorrelation(HttpServletRequest request, HttpServletResponse response, RequestTelemetry requestTelemetry) {
        try {
            if (request == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. request is null.", new Object[0]);
                return;
            }
            if (response == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. response is null.", new Object[0]);
                return;
            }
            if (requestTelemetry == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. requestTelemetry is null.", new Object[0]);
                return;
            }
            Traceparent incomingTraceparent = TraceContextCorrelation.extractIncomingTraceparent(request);
            Traceparent processedTraceParent = TraceContextCorrelation.processIncomingTraceparent(incomingTraceparent, request);
            requestTelemetry.setId(processedTraceParent.getSpanId());
            requestTelemetry.getContext().getOperation().setId(processedTraceParent.getTraceId());
            if (incomingTraceparent != null) {
                requestTelemetry.getContext().getOperation().setParentId(incomingTraceparent.getSpanId());
            }
            ThreadContext.getRequestTelemetryContext().setTraceflag(processedTraceParent.getTraceFlags());
            String appId = TraceContextCorrelation.getAppId();
            Tracestate tracestate = TraceContextCorrelation.getTracestate(request, incomingTraceparent, appId);
            ThreadContext.getRequestTelemetryContext().setTracestate(tracestate);
            TraceContextCorrelation.addTargetAppIdInResponseHeaderViaRequestContext(response);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("unable to perform correlation :%s", ExceptionUtils.getStackTrace(e));
        }
    }

    private static Traceparent extractIncomingTraceparent(HttpServletRequest request) {
        Traceparent incomingTraceparent = null;
        Enumeration traceparents = request.getHeaders(TRACEPARENT_HEADER_NAME);
        List<String> traceparentList = TraceContextCorrelation.getEnumerationAsCollection(traceparents);
        if (traceparentList.size() != 1) {
            return null;
        }
        try {
            incomingTraceparent = Traceparent.fromString(traceparentList.get(0));
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error(String.format("Received invalid traceparent header with exception %s, distributed trace might be broken", ExceptionUtils.getStackTrace(e)), new Object[0]);
        }
        return incomingTraceparent;
    }

    private static Traceparent processIncomingTraceparent(Traceparent incomingTraceparent, HttpServletRequest request) {
        Traceparent processedTraceparent = null;
        if (incomingTraceparent == null) {
            if (isW3CBackCompatEnabled) {
                processedTraceparent = TraceContextCorrelation.processLegacyCorrelation(request);
            }
            if (processedTraceparent == null) {
                processedTraceparent = new Traceparent();
            }
        } else {
            processedTraceparent = new Traceparent(0, incomingTraceparent.getTraceId(), null, incomingTraceparent.getTraceFlags());
        }
        return processedTraceparent;
    }

    private static Traceparent processLegacyCorrelation(HttpServletRequest request) {
        String requestId = request.getHeader("Request-Id");
        try {
            if (requestId != null && !requestId.isEmpty()) {
                String legacyOperationId = TelemetryCorrelationUtils.extractRootId(requestId);
                RequestTelemetry requestTelemetry = ThreadContext.getRequestTelemetryContext().getHttpRequestTelemetry();
                requestTelemetry.getContext().getProperties().putIfAbsent("ai_legacyRootID", legacyOperationId);
                requestTelemetry.getContext().getOperation().setParentId(requestId);
                return new Traceparent(0, legacyOperationId, null, 0);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error(String.format("unable to create traceparent from legacy request-id header %s", ExceptionUtils.getStackTrace(e)), new Object[0]);
        }
        return null;
    }

    private static Tracestate getTracestate(HttpServletRequest request, Traceparent incomingTraceparent, String appId) {
        Tracestate tracestate = null;
        if (incomingTraceparent != null) {
            Enumeration tracestates = request.getHeaders(TRACESTATE_HEADER_NAME);
            List<String> tracestateList = TraceContextCorrelation.getEnumerationAsCollection(tracestates);
            try {
                tracestate = Tracestate.fromString(StringUtils.join(tracestateList, ","));
                if (appId != null && !appId.isEmpty()) {
                    tracestate = new Tracestate(tracestate, AZURE_TRACEPARENT_COMPONENT_INITIAL, appId);
                }
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error(String.format("Cannot parse incoming tracestate %s", ExceptionUtils.getStackTrace(e)), new Object[0]);
                try {
                    if (appId != null && !appId.isEmpty()) {
                        tracestate = new Tracestate(null, AZURE_TRACEPARENT_COMPONENT_INITIAL, appId);
                    }
                }
                catch (Exception ex) {
                    InternalLogger.INSTANCE.error(String.format("Cannot create default tracestate %s", ExceptionUtils.getStackTrace(ex)), new Object[0]);
                }
            }
        } else {
            try {
                if (appId != null && !appId.isEmpty()) {
                    tracestate = new Tracestate(null, AZURE_TRACEPARENT_COMPONENT_INITIAL, appId);
                }
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error(String.format("cannot create default traceparent %s", ExceptionUtils.getStackTrace(e)), new Object[0]);
            }
        }
        return tracestate;
    }

    private static List<String> getEnumerationAsCollection(Enumeration<String> e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    private static void addTargetAppIdInResponseHeaderViaRequestContext(HttpServletResponse response) {
        if (response.containsHeader(REQUEST_CONTEXT_HEADER_NAME)) {
            return;
        }
        String appId = TraceContextCorrelation.getAppId();
        if (appId.isEmpty()) {
            return;
        }
        response.addHeader(REQUEST_CONTEXT_HEADER_NAME, "appId=" + appId);
    }

    public static String getAppId() {
        String instrumentationKey = TelemetryConfiguration.getActive().getInstrumentationKey();
        String appId = InstrumentationKeyResolver.INSTANCE.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive());
        if (appId == null) {
            InternalLogger.INSTANCE.trace("Application correlation Id could not be retrieved (e.g. task may be pending or failed)", new Object[0]);
            return "";
        }
        return appId;
    }

    public static void resolveRequestSource(HttpServletRequest request, RequestTelemetry requestTelemetry, String instrumentationKey) {
        try {
            if (request == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. request is null.", new Object[0]);
                return;
            }
            if (instrumentationKey == null || instrumentationKey.isEmpty()) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. InstrumentationKey is null or empty.", new Object[0]);
                return;
            }
            if (requestTelemetry == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. requestTelemetry is null.", new Object[0]);
                return;
            }
            if (requestTelemetry.getSource() != null) {
                InternalLogger.INSTANCE.trace("Skip resolving request source as it is already initialized.", new Object[0]);
                return;
            }
            String tracestate = request.getHeader(TRACESTATE_HEADER_NAME);
            if (tracestate == null || tracestate.isEmpty()) {
                if (isW3CBackCompatEnabled && request.getHeader(REQUEST_CONTEXT_HEADER_NAME) != null) {
                    InternalLogger.INSTANCE.trace("Tracestate absent, In backward compatibility mode, will try to resolve request-context", new Object[0]);
                    TelemetryCorrelationUtils.resolveRequestSource(request, requestTelemetry, instrumentationKey);
                    return;
                }
                InternalLogger.INSTANCE.info("Skip resolving request source as the following header was not found: %s", TRACESTATE_HEADER_NAME);
                return;
            }
            Tracestate incomingTracestate = Tracestate.fromString(tracestate);
            String source = TraceContextCorrelation.generateSourceTargetCorrelation(instrumentationKey, incomingTracestate.get(AZURE_TRACEPARENT_COMPONENT_INITIAL));
            requestTelemetry.setSource(source);
        }
        catch (Exception ex) {
            InternalLogger.INSTANCE.error("Failed to resolve request source. Exception information: %s", ExceptionUtils.getStackTrace(ex));
        }
    }

    public static String generateChildDependencyTarget(String requestContext) {
        String currAppId;
        String target;
        if (requestContext == null || requestContext.isEmpty()) {
            InternalLogger.INSTANCE.trace("generateChildDependencyTarget: won't continue as requestContext is null or empty.", new Object[0]);
            return "";
        }
        String instrumentationKey = TelemetryConfiguration.getActive().getInstrumentationKey();
        if (instrumentationKey == null || instrumentationKey.isEmpty()) {
            InternalLogger.INSTANCE.error("Failed to generate target correlation. InstrumentationKey is null or empty.", new Object[0]);
            return "";
        }
        String[] keyValue = requestContext.split("=");
        String headerAppID = null;
        if (keyValue.length == 2 && keyValue[0].equals(REQUEST_CONTEXT_HEADER_APPID_KEY)) {
            headerAppID = keyValue[1];
        }
        if ((target = TraceContextCorrelation.resolve(headerAppID, currAppId = InstrumentationKeyResolver.INSTANCE.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive()))) == null) {
            InternalLogger.INSTANCE.warn("Target value is null and hence returning empty string", new Object[0]);
            return "";
        }
        return target;
    }

    private static String generateSourceTargetCorrelation(String instrumentationKey, String appId) {
        if (StringUtils.isEmpty(instrumentationKey)) {
            throw new IllegalArgumentException("instrumentationKey should be nonnull");
        }
        if (StringUtils.isEmpty(appId)) {
            throw new IllegalArgumentException("appId should be nonnull");
        }
        String myAppId = InstrumentationKeyResolver.INSTANCE.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive());
        return TraceContextCorrelation.resolve(appId, myAppId);
    }

    private static String resolve(String headerAppId, String currentAppId) {
        if (currentAppId == null) {
            InternalLogger.INSTANCE.trace("Could not generate source/target correlation as the appId could not be resolved (e.g. task may be pending or failed)", new Object[0]);
            return null;
        }
        String result = null;
        if (headerAppId != null && !headerAppId.equals(currentAppId)) {
            result = headerAppId;
        }
        return result;
    }

    public static String retriveTracestate() {
        if (ThreadContext.getRequestTelemetryContext() == null || ThreadContext.getRequestTelemetryContext().getTracestate() == null) {
            InternalLogger.INSTANCE.warn("No correlation wil happen, Thread context is null", new Object[0]);
            return null;
        }
        Tracestate tracestate = ThreadContext.getRequestTelemetryContext().getTracestate();
        return tracestate.toString();
    }

    public static String generateChildDependencyTraceparent() {
        Traceparent tp = TraceContextCorrelation.generateChildDependencyTraceparentObj();
        return tp == null ? null : tp.toString();
    }

    public static Traceparent generateChildDependencyTraceparentObj() {
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            if (context == null) {
                return new Traceparent();
            }
            RequestTelemetry requestTelemetry = context.getHttpRequestTelemetry();
            String traceId = requestTelemetry.getContext().getOperation().getId();
            Traceparent tp = new Traceparent(0, traceId, null, context.getTraceflag());
            return tp;
        }
        catch (Exception ex) {
            InternalLogger.INSTANCE.error("Failed to generate child ID. Exception information: %s", ex.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(ex));
            return null;
        }
    }

    @Deprecated
    public static String createChildIdFromTraceparentString(String traceparent) {
        if (traceparent == null) {
            throw new NullPointerException("traceparent cannot be null");
        }
        String[] traceparentArr = traceparent.split("-");
        if (traceparentArr.length != 4) {
            throw new IllegalArgumentException("Invalid traceparent");
        }
        return "|" + traceparentArr[1] + "." + traceparentArr[2] + ".";
    }

    public static void setIsW3CBackCompatEnabled(boolean isW3CBackCompatEnabled) {
        TraceContextCorrelation.isW3CBackCompatEnabled = isW3CBackCompatEnabled;
        InternalLogger.INSTANCE.trace(String.format("W3C Backport mode enabled on Incoming side %s", isW3CBackCompatEnabled), new Object[0]);
    }
}

