/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.protocol;

import com.microsoft.applicationinsights.web.dependencies.http.HttpEntityEnclosingRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequestInterceptor;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpDateGenerator;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

