/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.QueryMakerViewUI;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.models.GroupEmailEntityModel;
import com.jurismarches.vradi.ui.email.models.UserEmailEntityModel;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FormViewUI
extends EmailContentUI {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";
    public static final String BINDING_GROUPS_FORM_FORM = "groupsForm.form";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_FORM = "usersForm.form";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdmziOHT6CI0ICAQWwBAroHKBBSoBAwCKRAwITFOGGPd8Sb7iPZXcvuaRA/AR+AvQ0SHRUiIKaggbxFxCioEXM3p3tGC7Ywi7Wvp15b96M39zrb5CRAk6skyAwhO8q5lBj6drq6h1zndbVDSrrgnHlCYg+qTSkazBste6lglO1ioaXYnhpwXO451J3B3q2AnmptmwqG5QqBcc6EXUpS9VWeDbgvmiytkQlsb788T39wnr+Kg0QcFQ3hK1MdUO1OxmoQJpZCgpYaYOUbOKuoQzB3DXUu0/fLdhEytvEoU/hGWQrMMiJQDIFJ3tvOeQI8QFXMFK86RBmL3iuwvSVxRkF03XPMdZ9waRDRL1BpbEhiMUMnxlU5xplTzgPGN1cWeQ8ZBpUkJVUSoYscHoXONIzxfCxGmW2sQMmJQgsdgPqujsqFu8T06YoeLxjxHITB2aEMZ2ZawGGiksVYlIbEQU9zCBOjW51UqGVm18Tns+lrqhgpttA7vpUbC2TJ1REY+nkatY9r58Pd8ZyvqQiLKMvjsRBAUc7WkI/Gm0/tg2TqkFG+HiNM6j9beF7GIrMO/6HeTVhGP01Nvr53de35aZj81j7UGLqjoVDJ3HhcSr0v6LgQGRXXzG7tEz4bA1yktq4reE2TiYIq8ZhFIf1Dmq4oeHGLSIbSJHJfnn/YezRpz2QLkPe9ohVJjp/EXKqIXAKnm0F/Op8qGjv5hCeI1obWknRANehMMdcm7l0iijcH9NX9EqAY5hMGENLi5n7+HO0+ma+OYoUSpvYNb09jsxDGIyqhesbb2biug5zSX3La29g0k6m9PcYj41eDM8zSb1m6jbZ3lawf84iikyZzLXQztioRpwLO9C/jJBwogfCLHX11oQtXPx/moHHsZ374Gi+Tvqi0dfT+jibzDDZE8OFf2g43hPDpb4ZLvfNcL0Lw2+A8r+meQcAAA==";
    private static final Log log = LogFactory.getLog(FormViewUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected Form bean;
    protected QueryMakerViewUI<Group> groupsForm;
    protected Session session;
    protected QueryMakerViewUI<User> usersForm;
    private FormViewUI $EmailContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    @Override
    public void openUI(VradiTreeNode node) {
        this.getHandler().displayForm((JAXXContext)this, node);
        Form formSelected = this.getContextValue(Form.class);
        this.setBean(formSelected);
        this.session = this.getHelper().getSessionToDisplay(node);
        this.updateSession(this.session);
    }

    public void updateSession(Session currentSession) {
        this.setSession(currentSession);
        this.groupsForm.setSession(currentSession);
        this.usersForm.setSession(currentSession);
        List<User> userSending = EmailDataHelper.getUsersSendingConcernedBy(this.session, this.bean.getWikittyId());
        List<User> allUsers = this.getAdminHandler().getAllUsers();
        allUsers.removeAll(userSending);
        EmailFormsListCellRenderer emailFormsCellRenderer = new EmailFormsListCellRenderer();
        emailFormsCellRenderer.updateDatas(this.getSession(), this.getBean().getWikittyId());
        this.usersForm.init(true, this.getBean(), emailFormsCellRenderer, allUsers, userSending);
        this.usersForm.getQueryMakerForm().getList().setModel(new UserEmailEntityModel(emailFormsCellRenderer, this.session, this.getBean()));
        List<Group> groupSending = EmailDataHelper.getGroupsSendingConcernedBy(this.session, this.bean.getWikittyId());
        List<Group> allGroups = this.getAdminHandler().getAllGroups();
        allGroups.removeAll(groupSending);
        this.groupsForm.init(true, this.getBean(), emailFormsCellRenderer, allGroups, groupSending);
        this.groupsForm.getQueryMakerForm().getList().setModel(new GroupEmailEntityModel(emailFormsCellRenderer, this.session, this.getBean()));
        this.usersForm.setEnabled(this.sessionCanBeSent());
        this.groupsForm.setEnabled(this.sessionCanBeSent());
    }

    protected boolean sessionCanBeSent() {
        if (this.session == null) {
            return false;
        }
        return VradiConstants.SessionStatus.isActive((Session)this.session);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public FormViewUI() {
        this.$initialize();
    }

    public FormViewUI(JAXXContext parentContext) {
        super(parentContext);
        this.$initialize();
    }

    public Form getBean() {
        return this.bean;
    }

    public QueryMakerViewUI<Group> getGroupsForm() {
        return this.groupsForm;
    }

    public Session getSession() {
        return this.session;
    }

    public QueryMakerViewUI<User> getUsersForm() {
        return this.usersForm;
    }

    public void setBean(Form newValue) {
        Form oldValue = this.bean;
        this.bean = newValue;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setSession(Session newValue) {
        Session oldValue = this.session;
        this.session = newValue;
        this.firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    protected void createGroupsForm() {
        this.groupsForm = new QueryMakerViewUI((JAXXContext)this);
        this.$objectMap.put("groupsForm", this.groupsForm);
        this.groupsForm.setName("groupsForm");
    }

    protected void createSession() {
        this.session = null;
        this.$objectMap.put(PROPERTY_SESSION, null);
    }

    protected void createUsersForm() {
        this.usersForm = new QueryMakerViewUI((JAXXContext)this);
        this.$objectMap.put("usersForm", this.usersForm);
        this.usersForm.setName("usersForm");
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.add((Component)this.$Table0, "Center");
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add(this.groupsForm, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add(this.usersForm, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.groupsForm.setClazz(Group.class);
        this.groupsForm.setEnabled(this.sessionCanBeSent());
        this.usersForm.setClazz(User.class);
        this.usersForm.setEnabled(this.sessionCanBeSent());
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$EmailContentUI0", this);
        this.createSession();
        this.createBean();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"vradi.email.formGroupTitle"));
        this.createGroupsForm();
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"vradi.email.formUserTitle"));
        this.createUsersForm();
        this.setName("$EmailContentUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_FORM, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                FormViewUI.this.groupsForm.setForm(FormViewUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true, new String[]{PROPERTY_SESSION}){

            public void processDataBinding() {
                FormViewUI.this.groupsForm.setSession(FormViewUI.this.getSession());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_FORM, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                FormViewUI.this.usersForm.setForm(FormViewUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true, new String[]{PROPERTY_SESSION}){

            public void processDataBinding() {
                FormViewUI.this.usersForm.setSession(FormViewUI.this.getSession());
            }
        });
    }
}

