/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.task;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.task.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class AbstractProgressBarUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_SHOW_CANCEL_BUTTON = "showCancelButton";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_BUTTON_VISIBLE = "cancelButton.visible";
    public static final String BINDING_MSG_LABEL_TEXT = "msgLabel.text";
    public static final String BINDING_MSG_LABEL_VISIBLE = "msgLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRBdO7Ed5wNCrESJCJL5kEAU5yYNShSSGEUkMgQRIUW4Ye9usTesb5fdueTSIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZu8cXwyXxIIr7k4z7719Mzvz+hspGE0u7tIocnQYAO8wZ3N1Z2fL3WUe3GLG01yB1CR5cnmSb5Ixvxc3QC43G5Ze69JrddlRMmDBEfZig4waOBDMtBkDIBf6GZ4xte1eejFSoT5U7ZnKUn3543v+hf/8VZ6QSKG7IpZSPY2VVjLcIHnuA5nCk/ZoTdCghTY0D1rod8LG6oIac5d22FPyjJQapKioRjEglwYvOdaI+ZECMk1dA5p6cE/LlmbGrFH9YAPIgic7zm6ouelQ7bWZcfY09bkTcgeoeeKsZtGUioWLQCZNW+7XaeAxsRYCyADIOVuAY4ty1qQUjAYpfKhjWkhKEUnZKWAEAQ3qMoHdsajIMfsIcDbjoAWVe9gxlXoCMtsHP2K3nzTu9Zmt9LGSaJegyfm+K8VhcdJhSW8z1yQFHWIYPTT/nq/7mEoma/aPybKCcfbXTOXzu69v1w/HqYxnT2dCj2wDXjPWr5gGbo8+m8xSCFzU7lC12EQVJnCV4lWZzzC23U2jOTwvuTVLd25T00aJQunL+w8zjz4Nkfw6GRWS+uvU4jdIGdrY27YUfqRursSOxvdH8D1pveGs+ewxDQXUhTRsCy1S4LbZZ5Z8CrTq8sDHdi9H2JP5jJ70jLnljz8r229WDvuSQ59zx8LT3hQekiIPBA9YvGjdHcpcrDFlWOjLdFeytidnv6OqO6XV+H0lq/CioAcyBJu/GoX2cy22bf+uD6xSAA4CJ2xqKSmiSgG3xA2BLf+76DCw6CRjlQE0SnvccFew/5SZwPtnwHSHBxRisYVssZlB6uJesrHHGJo7VcOGb5zgYjCF5VM8/AaLZwW58QYAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.task.AbstractProgressBarUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AbstractProgressBarUI abstractProgressBarUI = this;
    protected javax.swing.JButton cancelButton;
    protected java.lang.String msg;
    protected javax.swing.JLabel msgLabel;
    protected javax.swing.JProgressBar progressBar;
    protected java.lang.Boolean showCancelButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public abstract void cancel();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractProgressBarUI() {
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doWindowClosing__on__abstractProgressBarUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public java.lang.String getMsg() {
        return msg;
    }

    public javax.swing.JLabel getMsgLabel() {
        return msgLabel;
    }

    public javax.swing.JProgressBar getProgressBar() {
        return progressBar;
    }

    public java.lang.Boolean getShowCancelButton() {
        return showCancelButton;
    }

    public java.lang.Boolean isShowCancelButton() {
        return showCancelButton !=null && showCancelButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setMsg(java.lang.String newValue) {
        java.lang.String oldValue = this.msg;
        this.msg = newValue;
        firePropertyChange(PROPERTY_MSG, oldValue, newValue);
    }

    public void setShowCancelButton(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showCancelButton;
        this.showCancelButton = newValue;
        firePropertyChange(PROPERTY_SHOW_CANCEL_BUTTON, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAbstractProgressBarUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(msgLabel, BorderLayout.NORTH);
        add(progressBar, BorderLayout.CENTER);
        add(cancelButton, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new javax.swing.JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("vradi.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createMsg() {
        $objectMap.put("msg", msg = null);
    }

    protected void createMsgLabel() {
        $objectMap.put("msgLabel", msgLabel = new javax.swing.JLabel());
        
        msgLabel.setName("msgLabel");
    }

    protected void createProgressBar() {
        $objectMap.put("progressBar", progressBar = new javax.swing.JProgressBar());
        
        progressBar.setName("progressBar");
        progressBar.setIndeterminate(true);
    }

    protected void createShowCancelButton() {
        $objectMap.put("showCancelButton", showCancelButton = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAbstractProgressBarUI();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cancelButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        // late initializer
        abstractProgressBarUI.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("abstractProgressBarUI", this);
        createShowCancelButton();
        createMsg();
        createMsgLabel();
        createProgressBar();
        createCancelButton();
        // inline creation of abstractProgressBarUI
        setName("abstractProgressBarUI");
        abstractProgressBarUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.progressBar.title"));
        abstractProgressBarUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__abstractProgressBarUI"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_TEXT, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setText(_(getMsg()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_VISIBLE, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setVisible(getMsg() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CANCEL_BUTTON_VISIBLE, true ,"showCancelButton") {
        
            @Override
            public void processDataBinding() {
                cancelButton.setVisible(isShowCancelButton());
            }
        });
    }

}