/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: NumberListCellRenderer.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/renderers/NumberListCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.renderers;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/**
 * NumberListCellRenderer.
 * 
 * Display a special string for "-1" value;
 *
 * @author schorlet
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 24 mars 2010 12:26:58
 */
public class NumberListCellRenderer extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {
        
        Number number = (Number)value;
        Object newValue = number;

        // -1 means no search restriction
        if (number.intValue() == -1) {
            newValue = _("vradi.common.alls");
        }

        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                cellHasFocus);
    }
}
