/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FieldSelectModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/models/FieldSelectModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import com.jurismarches.vradi.entities.FieldTypeEnum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

/**
 * @author morin
 *         Date: 25 nov. 2009
 *         Time: 17:19:44
 */
public class FieldSelectModel implements Serializable {

    public static final String PROPERTY_NAME_VALUE = "nameValue";
    public static final String PROPERTY_DESC_VALUE = "descValue";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_POSITION = "position";
    public static final String PROPERTY_UP_OR_DOWN = "upOrDown";

    private static final long serialVersionUID = 1L;

    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    protected String nameValue;
    protected String descValue;
    protected FieldTypeEnum type;
    protected Integer position;
    //true if up, false if down, else null
    protected Boolean upOrDown = null;

    public FieldSelectModel() {
        super();
    }

    public FieldSelectModel(Integer position) {
        super();
        this.position = position;
    }

    public FieldSelectModel(String nameValue, String descValue, FieldTypeEnum type, Integer position) {
        super();
        this.nameValue = nameValue;
        this.descValue = descValue;
        this.type = type;
        this.position = position;
    }

    public void update(FieldSelectModel model) {
        setNameValue(model.getNameValue());
        setType(model.getType());
        setDescValue(model.getDescValue());
        setPosition(model.getPosition());
    }

    public String getNameValue() {
        return nameValue;
    }

    public void setNameValue(String value) {
        String oldValue = this.nameValue;
        this.nameValue = value;
        propertyChange.firePropertyChange(PROPERTY_NAME_VALUE, oldValue, value);
    }

    public String getDescValue() {
        return descValue;
    }

    public void setDescValue(String value) {
        String oldValue = this.descValue;
        this.descValue = value;
        propertyChange.firePropertyChange(PROPERTY_DESC_VALUE, oldValue, value);
    }

    public FieldTypeEnum getType() {
        return type;
    }

    public void setType(FieldTypeEnum value) {
        FieldTypeEnum oldValue = this.type;
        this.type = value;
        propertyChange.firePropertyChange(PROPERTY_TYPE, oldValue, value);
    }

    public Integer getPosition() {
        return position;
    }

    public void setPosition(Integer value) {
        Integer oldValue = this.position;
        this.position = value;
        propertyChange.firePropertyChange(PROPERTY_POSITION, oldValue, value);
    }

    public Boolean isUpOrDown() {
        return upOrDown;
    }

    public void setUpOrDown(Boolean value) {
        Boolean oldValue = this.upOrDown;
        this.upOrDown = value;
        propertyChange.firePropertyChange(PROPERTY_UP_OR_DOWN, oldValue, value);
    }


    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }

}
