/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class StatusEditionUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_WIKITTY = "wikitty";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESC_FIELD_BACKGROUND = "descField.background";
    public static final String BINDING_DESC_FIELD_EDITABLE = "descField.editable";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_NAME_FIELD_BACKGROUND = "nameField.background";
    public static final String BINDING_NAME_FIELD_EDITABLE = "nameField.editable";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.StatusEditionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Status bean;
    protected javax.swing.JTextArea descField;
    protected javax.swing.JButton down;
    protected javax.swing.JTextField nameField;
    protected javax.swing.JButton remove;
    protected StatusEditionUI statusEditionUI = this;
    protected javax.swing.JButton up;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Status > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected com.jurismarches.vradi.entities.Status wikitty;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
    }
    
    protected AdminStatusUI getAdminStatusUI() {
        return getParentContainer(AdminStatusUI.class);
    }
    
    public void confirmDeletion() {
        int confirm = JOptionPane.showConfirmDialog(this,
                _("vradi.admin.confirmDelete", VradiHelper.getEntityName(bean)),
                _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
    
        if (confirm == JOptionPane.YES_OPTION) {
            getAdminStatusUI().delete(this);
        }
    }
    
    public void up() {
         getAdminStatusUI().up(this);
    }
    
    public void down() {
         getAdminStatusUI().down(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusEditionUI() {
        $initialize();
    }

    public StatusEditionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Status > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__down(java.awt.event.ActionEvent event) {
        down();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        confirmDeletion();
    }

    public void doActionPerformed__on__up(java.awt.event.ActionEvent event) {
        up();
    }

    public void doKeyReleased__on__descField(java.awt.event.KeyEvent event) {
        bean.setDescription(descField.getText());
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setName(nameField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Status getBean() {
        return bean;
    }

    public javax.swing.JTextArea getDescField() {
        return descField;
    }

    public javax.swing.JButton getDown() {
        return down;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getUp() {
        return up;
    }

    public com.jurismarches.vradi.entities.Status getWikitty() {
        return wikitty;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Status newValue) {
        com.jurismarches.vradi.entities.Status oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setWikitty(com.jurismarches.vradi.entities.Status newValue) {
        com.jurismarches.vradi.entities.Status oldValue = this.wikitty;
        this.wikitty = newValue;
        firePropertyChange(PROPERTY_WIKITTY, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("description", descField);
        validator.setFieldRepresentation("name", nameField);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStatusEditionUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new javax.swing.JTextArea());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.setLineWrap(true);
        descField.setWrapStyleWord(true);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new javax.swing.JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.setColumns(20);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new javax.swing.JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Status >(com.jurismarches.vradi.entities.Status.class, null));
    }

    protected void createWikitty() {
        $objectMap.put("wikitty", wikitty = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToStatusEditionUI();
        addChildrenToValidator();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        up.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("statusEditionUI", this);
        createBean();
        createWikitty();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminStatus.desc"));
        createDescField();
        createUp();
        createDown();
        createRemove();
        // inline creation of statusEditionUI
        setName("statusEditionUI");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    nameField.setBackground(getBean().getModifiable() ? null : new Color(230, 230, 240));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    nameField.setEditable(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, _(getBean().getName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    descField.setBackground(getBean().getModifiable() ? null : new Color(230, 230, 240));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    descField.setEditable(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(descField, _(getBean().getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    remove.setVisible(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
    }

}