/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import java.util.List;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminUserUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<User> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";
    public static final String PROPERTY_USER_GROUPS_HANDLER = "userGroupsHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_USER_ADDRESS_TEXT = "userAddress.text";
    public static final String BINDING_USER_BEGIN_SEARCH_DATE_DATE = "userBeginSearchDate.date";
    public static final String BINDING_USER_EMAIL_TEXT = "userEmail.text";
    public static final String BINDING_USER_ENABLE_SELECTED = "userEnable.selected";
    public static final String BINDING_USER_GROUPS_VISIBLE = "userGroups.visible";
    public static final String BINDING_USER_NAME_TEXT = "userName.text";
    public static final String BINDING_USER_PHONE_TEXT = "userPhone.text";
    public static final String BINDING_USER_SERVICE_TEXT = "userService.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL7_VISIBLE = "$JLabel7.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminUserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminUserForm;
    protected com.jurismarches.vradi.entities.User bean;
    protected javax.swing.JButton createButton;
    protected java.lang.Boolean inGroup;
    protected javax.swing.JLabel title;
    protected javax.swing.JTextField userAddress;
    protected org.jdesktop.swingx.JXDatePicker userBeginSearchDate;
    protected javax.swing.JTextField userEmail;
    protected javax.swing.JCheckBox userEnable;
    protected jaxx.runtime.swing.ListSelectorUI< Group > userGroups;
    protected com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler userGroupsHandler;
    protected javax.swing.JTextField userName;
    protected javax.swing.JTextField userPhone;
    protected javax.swing.JTextField userService;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminUserUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(userGroups.getCombo(), EntityRenderer.getInstance());
    
        userGroups.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        userGroupsHandler = new GroupListSelectorHandler(userGroups);
        userGroups.setHandler(userGroupsHandler);
    }
    
    @Override
    protected void postLoadBean() {
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    
        createButton.setEnabled(!isInCreation());
    
        if (bean == null) {
            return;
        }
        
        List<Group> toCombo = getHandler().getAllGroups();
    
        List<Group> toList = new ArrayList<Group>();
        try {
            toList = VradiService.getVradiDataService().getGroupsForUser(bean.getWikittyId());
        } catch (VradiException eee){
            log.error("Could not retrieve groups for user : " + bean.getName(),
                    eee);
        }
        
        toCombo.removeAll(toList);
    
        userGroups.init(toCombo, toList);
        userGroupsHandler.setBean(bean);
    }
    
    @Override
    public void save() {
    
        // groups to save
        Map<String, Group> groups = new HashMap<String, Group>();
    
        if (log.isDebugEnabled()){
            log.debug("Will save user " + bean.getName());
        }
    
        String wikittyId = bean.getWikittyId();
    
        // FIXME EC20100628 move this code to handler
        //Remove the groups that were remove from the list.
        for (Group g : userGroups.getComboDatas()) {
        
            if (g != null && g.getUser() != null && g.getUser().contains(wikittyId)) {
    
                if (log.isDebugEnabled()){
                    log.debug("Removing user " + bean.getName() + " from group " + g.getName());
                }
    
                // group was containing user, but no more
                g.removeUser(wikittyId);
                
                // mark it for save
                groups.put(g.getWikittyId(), g);
            }
        }
    
        //Add groups that have been added to the list
        for (Group g : userGroups.getListDatas()) {
    
            if (g != null) {
    
                if (log.isDebugEnabled()){
                    log.debug("Adding user " + bean.getName() + " to group " +g.getName());
                }
    
                g.addUser(wikittyId);
                //mark group for save
                groups.put(g.getWikittyId(), g);
            }
    
        }
    
        //Effectively save bean
        User user = getHandler().saveUser(this, getHelper(), bean, groups.values());
    
        AdminNavigationTreeHelper helper = getHelper();
        VradiTreeNode userNode = helper.findNode(helper.getRootNode(), user.getWikittyId());
        helper.refresh(userNode);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setBean(null);
        setBean(user);
    
        userGroups.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        userName.setText("");
        userService.setText("");
        userAddress.setText("");
        userPhone.setText("");
        userEmail.setText("");
        userBeginSearchDate.setDate(null);
        userEnable.setSelected(false);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminUser.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(getBean().getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminUserUI() {
        super();
        $initialize();
    }

    public AdminUserUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper().getClientSelected());setModified(true);
    }

    public void doActionPerformed__on__userBeginSearchDate(java.awt.event.ActionEvent event) {
        getBean().setBeginSearchDate(userBeginSearchDate.getDate());
    }

    public void doActionPerformed__on__userEnable(java.awt.event.ActionEvent event) {
        getBean().setEnable(userEnable.isSelected());
    }

    public void doKeyReleased__on__userAddress(java.awt.event.KeyEvent event) {
        getBean().setAddress(userAddress.getText());
    }

    public void doKeyReleased__on__userEmail(java.awt.event.KeyEvent event) {
        getBean().setEmail(userEmail.getText());
    }

    public void doKeyReleased__on__userName(java.awt.event.KeyEvent event) {
        getBean().setName(userName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__userPhone(java.awt.event.KeyEvent event) {
        getBean().setPhone(userPhone.getText());
    }

    public void doKeyReleased__on__userService(java.awt.event.KeyEvent event) {
        getBean().setService(userService.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminUserForm() {
        return adminUserForm;
    }

    public com.jurismarches.vradi.entities.User getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JTextField getUserAddress() {
        return userAddress;
    }

    public org.jdesktop.swingx.JXDatePicker getUserBeginSearchDate() {
        return userBeginSearchDate;
    }

    public javax.swing.JTextField getUserEmail() {
        return userEmail;
    }

    public javax.swing.JCheckBox getUserEnable() {
        return userEnable;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getUserGroups() {
        return userGroups;
    }

    public com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler getUserGroupsHandler() {
        return userGroupsHandler;
    }

    public javax.swing.JTextField getUserName() {
        return userName;
    }

    public javax.swing.JTextField getUserPhone() {
        return userPhone;
    }

    public javax.swing.JTextField getUserService() {
        return userService;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.User newValue) {
        com.jurismarches.vradi.entities.User oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    public void setUserGroupsHandler(com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler newValue) {
        com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler oldValue = this.userGroupsHandler;
        this.userGroupsHandler = newValue;
        firePropertyChange(PROPERTY_USER_GROUPS_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("email", userEmail);
        validator.setFieldRepresentation("name", userName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminUserForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminUserForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userService, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JButton1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userPhone, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userEmail), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userBeginSearchDate, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userEnable, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminUserForm, BorderLayout.NORTH);
        body.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminUserForm() {
        $objectMap.put("adminUserForm", adminUserForm = new jaxx.runtime.swing.Table());
        
        adminUserForm.setName("adminUserForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminUser.createUser"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = false);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createUserAddress() {
        $objectMap.put("userAddress", userAddress = new javax.swing.JTextField());
        
        userAddress.setName("userAddress");
        userAddress.setColumns(15);
        userAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userAddress"));
    }

    protected void createUserBeginSearchDate() {
        $objectMap.put("userBeginSearchDate", userBeginSearchDate = new org.jdesktop.swingx.JXDatePicker());
        
        userBeginSearchDate.setName("userBeginSearchDate");
        userBeginSearchDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userBeginSearchDate"));
    }

    protected void createUserEmail() {
        $objectMap.put("userEmail", userEmail = new javax.swing.JTextField());
        
        userEmail.setName("userEmail");
        userEmail.setColumns(15);
        userEmail.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userEmail"));
    }

    protected void createUserEnable() {
        $objectMap.put("userEnable", userEnable = new javax.swing.JCheckBox());
        
        userEnable.setName("userEnable");
        userEnable.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userEnable"));
    }

    protected void createUserGroups() {
        $objectMap.put("userGroups", userGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        
        userGroups.setName("userGroups");
        userGroups.setShowHidor(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createUserGroupsHandler() {
        $objectMap.put("userGroupsHandler", userGroupsHandler = null);
    }

    protected void createUserName() {
        $objectMap.put("userName", userName = new javax.swing.JTextField());
        
        userName.setName("userName");
        userName.setColumns(15);
        userName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userName"));
    }

    protected void createUserPhone() {
        $objectMap.put("userPhone", userPhone = new javax.swing.JTextField());
        
        userPhone.setName("userPhone");
        userPhone.setColumns(15);
        userPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userPhone"));
    }

    protected void createUserService() {
        $objectMap.put("userService", userService = new javax.swing.JTextField());
        
        userService.setName("userService");
        userService.setColumns(15);
        userService.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userService"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User >(com.jurismarches.vradi.entities.User.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminUserForm();
        // inline complete setup of $Table0
        $Table0.add($JLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(userGroups, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        adminUserForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        userGroups.setAddToComboTip(_("vradi.adminUser.removeGroup"));
        userGroups.setAddToListTip(_("vradi.adminUser.addGroup"));
        userGroups.setHandler(userGroupsHandler);
        userGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        createUserGroupsHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminUser.deleteUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminUserForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminUser.name"));
        createUserName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminUser.service"));
        createUserService();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminUser.adresse"));
        createUserAddress();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminUser.phone"));
        createUserPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminUser.mail"));
        createUserEmail();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminUser.beginSearchDate"));
        createUserBeginSearchDate();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.admin.userEnable"));
        createUserEnable();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminClient.listGroup"));
        createUserGroups();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_SERVICE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userService, getBean().getService());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_EMAIL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userEmail, getBean().getEmail());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_BEGIN_SEARCH_DATE_DATE, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userBeginSearchDate.setDate(getBean().getBeginSearchDate());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ENABLE_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userEnable.setSelected(getBean().getEnable());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                userGroups.setVisible(!isInGroup());
            }
        });
    }

}